/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.commands.CustomCommand;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class CustomCommandHandler {
    private ProxySuite main;

    public CustomCommandHandler(ProxySuite main) {
        this.main = main;
    }

    public void registerCustomCommandsFromFile() {
        File folder = new File(this.main.getDataFolder(), "/customcommands");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        for (File f : folder.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".yml")) continue;
            try {
                String[] messages;
                Configuration config = ConfigurationProvider.getProvider(YamlConfiguration.class).load((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
                String command = f.getName().replace(".yml", "").trim();
                ArrayList disabledServers = (ArrayList)config.getStringList("DisabledServers");
                String permission = config.getString("Permission");
                this.main.getPermissionHandler().getAvailablePermissions().add(permission);
                for (String msg : messages = config.getStringList("Messages").toArray(new String[config.getStringList("Messages").size()])) {
                    if (!msg.startsWith("%permission:")) continue;
                    String full = msg.substring(1, msg.length() - 1);
                    String perm = full.split(":")[1];
                    this.main.getPermissionHandler().getAvailablePermissions().add(perm);
                }
                CustomCommand cmd = new CustomCommand(this.main, command, permission, messages, disabledServers);
                this.main.getProxy().getPluginManager().registerCommand((Plugin)this.main, (Command)cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String translateVariables(String input, ProxiedPlayer p) {
        String output = "" + input;
        if (output.contains("%totalPlayers%")) {
            int totalPlayers = 0;
            try {
                ResultSet rs = this.main.getSQLConnection().createStatement().executeQuery("SELECT COUNT(*) AS count FROM " + this.main.getTablePrefix() + "players");
                if (rs.next()) {
                    totalPlayers = rs.getInt("count");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            output = output.replace("%totalPlayers%", "" + totalPlayers);
        }
        if (output.contains("%world%") || output.contains("%worldTime%")) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("GetPlayerWorldInfo");
                out.writeUTF(p.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
            int count = 0;
            while (!this.main.getPlayerHandler().getWorldInfos().containsKey(p) && count < 100) {
                try {
                    ++count;
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (count != 100) {
                output = output.replace("%world%", this.main.getPlayerHandler().getWorldInfos().get(p).getWorld()).replace("%worldTime%", new SimpleDateFormat("HH:mm").format(new Date(this.main.getPlayerHandler().getWorldInfos().get(p).getTime())));
                this.main.getPlayerHandler().getWorldInfos().remove(p);
            }
        }
        if (output.startsWith("%permission:")) {
            String full = output.substring(1, output.length() - 1);
            String permission = full.split(":")[1];
            String format = full.split(":")[2];
            String replace = "";
            for (ProxiedPlayer pl : this.main.getProxy().getPlayers()) {
                if (!this.main.getPermissionHandler().hasPermission((CommandSender)pl, permission, true)) continue;
                replace = replace + format.replace("%player%", pl.getName()).replace("%prefix%", this.main.getPlayerHandler().getPrefix(pl)).replace("%suffix%", this.main.getPlayerHandler().getSuffix(pl)).replace("%server%", pl.getServer().getInfo().getName()) + ChatColor.RESET + ", ";
            }
            if (replace.length() > 1) {
                replace = replace.substring(0, replace.length() - 2);
            }
            output = output.replace("%" + full + "%", replace);
        }
        return output.replace("%player%", p.getName()).replace("%prefix%", this.main.getPlayerHandler().getPrefix(p)).replace("%suffix%", this.main.getPlayerHandler().getSuffix(p)).replace("%server%", p.getServer().getInfo().getName()).replace("%playersOnlineBungee%", "" + this.main.getProxy().getPlayers().size()).replace("%playersOnlineServer%", "" + p.getServer().getInfo().getPlayers().size());
    }
}

