/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Home;
import de.sabbertran.proxysuite.utils.Location;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class HomeHandler {
    private ProxySuite main;
    private HashMap<ProxiedPlayer, ArrayList<Home>> homes;

    public HomeHandler(ProxySuite main) {
        this.main = main;
        this.homes = new HashMap();
    }

    public Home getHome(String player, String name) {
        ProxiedPlayer p = this.main.getPlayerHandler().getPlayer(player, null, false);
        if (p != null && this.homes.containsKey(p)) {
            for (Home h : this.homes.get(p)) {
                if (!h.getName().equalsIgnoreCase(name)) continue;
                return h;
            }
        } else {
            try {
                ResultSet rs = this.main.getSQLConnection().createStatement().executeQuery("SELECT " + this.main.getTablePrefix() + "homes.* FROM " + this.main.getTablePrefix() + "homes, " + this.main.getTablePrefix() + "players " + "WHERE " + this.main.getTablePrefix() + "homes.player = " + this.main.getTablePrefix() + "players.uuid" + " AND " + this.main.getTablePrefix() + "players.name = '" + player + "' AND " + this.main.getTablePrefix() + "homes.name = '" + name + "'");
                if (rs.next()) {
                    Location loc = new Location(this.main.getProxy().getServerInfo(rs.getString("server")), rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("pitch"), rs.getFloat("yaw"));
                    Home h = new Home(p, name, loc);
                    return h;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setHome(String player, String name, Location loc) {
        String sql;
        ProxiedPlayer p = this.main.getPlayerHandler().getPlayer(player, null, false);
        Home old = p != null ? this.getHome(p.getName(), name) : null;
        String sqlDel = "";
        if (old != null) {
            old.setName(name);
            old.setLocation(loc);
            sql = "UPDATE " + this.main.getTablePrefix() + "homes SET `name` = '" + name + "', `server` = '" + loc.getServer().getName() + "', " + "`world` = '" + loc.getWorld() + "'," + " `x` = '" + loc.getX() + "', `y` = '" + loc.getY() + "', `z` = '" + loc.getZ() + "', `pitch` = '" + loc.getPitch() + "'," + " `yaw` = '" + loc.getYaw() + "' WHERE player = '" + p.getUniqueId() + "' AND LOWER(name) = '" + name.toLowerCase() + "'";
        } else {
            if (p != null) {
                Home h = new Home(p, name, loc);
                this.homes.get(p).add(h);
            }
            sqlDel = "DELETE FROM " + this.main.getTablePrefix() + "homes WHERE LOWER(name) = '" + name.toLowerCase() + "'" + " AND player IN (SELECT uuid FROM " + this.main.getTablePrefix() + "players WHERE LOWER(name) = '" + (p != null ? p.getName().toLowerCase() : player.toLowerCase()) + "')";
            sql = "INSERT INTO " + this.main.getTablePrefix() + "homes (player, name, server, world, x, y, z, pitch, yaw) " + "SELECT " + this.main.getTablePrefix() + "players.uuid, '" + name + "', '" + loc.getServer().getName() + "', '" + loc.getWorld() + "', '" + loc.getX() + "', '" + loc.getY() + "', '" + loc.getZ() + "'," + " '" + loc.getPitch() + "', '" + loc.getYaw() + "' FROM " + this.main.getTablePrefix() + "players " + "WHERE LOWER(" + this.main.getTablePrefix() + "players.name) = '" + player.toLowerCase() + "'";
        }
        final String sql2 = sql;
        final String sqlDel2 = sqlDel;
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    if (!sqlDel2.equals("")) {
                        HomeHandler.this.main.getSQLConnection().createStatement().execute(sqlDel2);
                    }
                    HomeHandler.this.main.getSQLConnection().createStatement().execute(sql2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteHome(final String player, final String name) {
        ProxiedPlayer p = this.main.getPlayerHandler().getPlayer(player, null, false);
        if (p != null) {
            for (Home h : this.homes.get(p)) {
                if (!h.getName().equalsIgnoreCase(name)) continue;
                this.homes.get(p).remove(h);
                break;
            }
        }
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                String sql = "DELETE FROM " + HomeHandler.this.main.getTablePrefix() + "homes WHERE LOWER(name) = '" + name.toLowerCase() + "' AND player IN (SELECT uuid FROM " + HomeHandler.this.main.getTablePrefix() + "players " + "WHERE name = '" + player + "')";
                try {
                    HomeHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public int getHomesInWorld(ProxiedPlayer p, ServerInfo server, String world) {
        int ret = 0;
        for (Home h : this.homes.get(p)) {
            if (!h.getLocation().getServer().equals(server) || !h.getLocation().getWorld().equals(world)) continue;
            ++ret;
        }
        return ret;
    }

    public void updateHomesFromDatabase(final ProxiedPlayer p) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                HomeHandler.this.homes.remove(p);
                ArrayList<Home> insert = new ArrayList<Home>();
                try {
                    ResultSet rs = HomeHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT * FROM " + HomeHandler.this.main.getTablePrefix() + "homes WHERE player = '" + p.getUniqueId() + "'");
                    while (rs.next()) {
                        String name = rs.getString("name");
                        Location loc = new Location(HomeHandler.this.main.getProxy().getServerInfo(rs.getString("server")), rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("pitch"), rs.getFloat("yaw"));
                        Home h = new Home(p, name, loc);
                        insert.add(h);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                HomeHandler.this.homes.put(p, insert);
            }
        });
    }

    public void sendHomeList(final CommandSender sender, final String player) {
        ScheduledTask[] task;
        final ArrayList<Home> homes = new ArrayList<Home>();
        homes.add(new Home(null, null, null));
        ProxiedPlayer p = this.main.getPlayerHandler().getPlayer(player, sender, false);
        if (p != null && this.homes.containsKey(p)) {
            homes.clear();
            for (Home h : this.homes.get(p)) {
                homes.add(h);
            }
            if (this.main.getConfig().getBoolean("ProxySuite.Homes.SortAlphabetically")) {
                Collections.sort(homes, new Comparator<Home>(){

                    @Override
                    public int compare(Home o1, Home o2) {
                        return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                    }
                });
            }
        } else {
            this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

                public void run() {
                    try {
                        homes.clear();
                        PreparedStatement pst = HomeHandler.this.main.getSQLConnection().prepareStatement("SELECT h.name, h.server, h.world, h.x, h.y, h.z, h.pitch, h.yaw FROM " + HomeHandler.this.main.getTablePrefix() + "homes h " + "INNER JOIN " + HomeHandler.this.main.getTablePrefix() + "players p ON h.player = p.uuid " + "WHERE p.name = ? " + (HomeHandler.this.main.getConfig().getBoolean("ProxySuite.Homes.SortAlphabetically") ? "ORDER BY LOWER(h.name)" : ""));
                        pst.setString(1, player);
                        ResultSet rs = pst.executeQuery();
                        while (rs.next()) {
                            String name = rs.getString("name");
                            Location loc = new Location(HomeHandler.this.main.getProxy().getServerInfo(rs.getString("server")), rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("pitch"), rs.getFloat("yaw"));
                            Home h = new Home(null, name, loc);
                            homes.add(h);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        task = new ScheduledTask[]{this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

            public void run() {
                if (homes.size() != 1 || ((Home)homes.get(0)).getPlayer() != null && ((Home)homes.get(0)).getName() != null && ((Home)homes.get(0)).getLocation() != null) {
                    String message;
                    HomeHandler.this.main.getProxy().getScheduler().cancel(task[0]);
                    if (homes.size() != 0) {
                        message = sender.getName() == player ? HomeHandler.this.main.getMessageHandler().getMessage("home.list.header") : HomeHandler.this.main.getMessageHandler().getMessage("home.list.header.others").replace("%player%", player);
                        HomeHandler.this.main.getMessageHandler().sendMessage(sender, message);
                    }
                    if (sender instanceof ProxiedPlayer) {
                        ProxiedPlayer p = (ProxiedPlayer)sender;
                        String homeList = "[";
                        for (Home h : homes) {
                            String entry = HomeHandler.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.homes.showcoordinates") ? (sender.getName() == player ? HomeHandler.this.main.getMessageHandler().getMessage("home.list.entry.withlocation").replace("%home%", h.getName()).replace("%server%", h.getLocation().getServer().getName()).replace("%world%", h.getLocation().getWorld()).replace("%coordX%", "" + h.getLocation().getXInt()).replace("%coordY%", "" + h.getLocation().getYInt()).replace("%coordZ%", "" + h.getLocation().getZInt()) : HomeHandler.this.main.getMessageHandler().getMessage("home.list.entry.withlocation.others").replace("%home%", h.getName()).replace("%server%", h.getLocation().getServer().getName()).replace("%world%", h.getLocation().getWorld()).replace("%coordX%", "" + h.getLocation().getXInt()).replace("%coordY%", "" + h.getLocation().getYInt()).replace("%coordZ%", "" + h.getLocation().getZInt()).replace("%player%", player)) : (sender.getName() == player ? HomeHandler.this.main.getMessageHandler().getMessage("home.list.entry").replace("%home%", h.getName()) : HomeHandler.this.main.getMessageHandler().getMessage("home.list.entry.others").replace("%home%", h.getName()).replace("%player%", player));
                            entry = entry.startsWith("{") && entry.endsWith("}") || entry.startsWith("[") && entry.endsWith("]") ? entry + ",{\"text\":\", \"}," : entry + ", ";
                            homeList = homeList + entry;
                        }
                        if (homeList.endsWith(", ")) {
                            homeList = homeList.substring(0, homeList.length() - 2);
                        } else if (homeList.endsWith(",{\"text\":\", \"},")) {
                            homeList = homeList.substring(0, homeList.length() - 15);
                        }
                        homeList = homeList + "]";
                        if (homes.size() == 0) {
                            homeList = HomeHandler.this.main.getMessageHandler().getMessage("home.list.nofound");
                        }
                        HomeHandler.this.main.getMessageHandler().sendMessage(sender, homeList);
                        message = HomeHandler.this.main.getMessageHandler().getMessage("home.list.footer");
                    } else {
                        String homeList = "";
                        for (Home h : homes) {
                            homeList = homeList + h.getName() + ", ";
                        }
                        if (homeList.length() > 0) {
                            homeList = homeList.substring(0, homeList.length() - 2);
                        }
                        sender.sendMessage((BaseComponent)new TextComponent(homeList));
                    }
                }
            }
        }, 10L, 500L, TimeUnit.MILLISECONDS)};
    }

    public int getMaximumHomes(String player) {
        int highest = this.main.getConfig().getInt("ProxySuite.Homes.DefaultMaximum");
        if (this.main.getPermissionHandler().getPermissions().containsKey(player)) {
            if (this.main.getPermissionHandler().hasPermission(player, "proxysuite.commands.sethome.multiple.*")) {
                return -1;
            }
            for (String s : this.main.getPermissionHandler().getPermissions().get(player)) {
                if (!s.startsWith("proxysuite.commands.sethome.multiple.")) continue;
                String amount = s.replace("proxysuite.commands.sethome.multiple.", "");
                try {
                    int temp = Integer.parseInt(amount);
                    if (temp <= highest) continue;
                    highest = temp;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return highest;
    }

    public int getMaximumHomesPerWorld(String player) {
        int highest = this.main.getConfig().getInt("ProxySuite.Homes.DefaultMaximumPerWorld");
        if (this.main.getPermissionHandler().getPermissions().containsKey(player)) {
            if (this.main.getPermissionHandler().hasPermission(player, "proxysuite.commands.sethome.world.multiple.*")) {
                return -1;
            }
            for (String s : this.main.getPermissionHandler().getPermissions().get(player)) {
                if (!s.startsWith("proxysuite.commands.sethome.world.multiple.")) continue;
                String amount = s.replace("proxysuite.commands.sethome.world.multiple.", "");
                try {
                    int temp = Integer.parseInt(amount);
                    if (temp <= highest) continue;
                    highest = temp;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return highest;
    }

    public int getHomeAmount(ProxiedPlayer p) {
        return this.homes.containsKey(p) ? this.homes.get(p).size() : 0;
    }

    public void removeHomesFromCache(ProxiedPlayer p) {
        this.homes.remove(p);
    }
}

