/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.LoggedMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Chat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler {
    private ProxySuite main;
    private HashMap<String, String> messages;
    private HashMap<ProxiedPlayer, LoggedMessage[]> lastMessages;

    public MessageHandler(ProxySuite main) {
        this.main = main;
        this.lastMessages = new HashMap();
    }

    public void readMessagesFromFile() {
        this.messages = new HashMap();
        File f = new File(this.main.getDataFolder(), "messages.yml");
        try {
            String line;
            BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF8"));
            while ((line = read.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                String[] split = line.split(": ");
                String msg = "";
                for (int i = 1; i < split.length; ++i) {
                    msg = msg + split[i] + ": ";
                }
                msg = msg.substring(1, msg.length() - 3);
                this.messages.put(split[0], msg);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(CommandSender receiver, String message) {
        if (receiver != null && !message.trim().equals("")) {
            if (message.contains("%newMessage%")) {
                for (String s : message.split("%newMessage%")) {
                    this.sendMessage(receiver, s);
                }
            } else if (receiver instanceof ProxiedPlayer && message.startsWith("[") && message.endsWith("]")) {
                ((ProxiedPlayer)receiver).unsafe().sendPacket((DefinedPacket)new Chat(message));
            } else {
                receiver.sendMessage((BaseComponent)this.translateColorCodes(message));
            }
        }
    }

    public void broadcast(String message) {
        if (!message.trim().equals("")) {
            for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
                this.sendMessage((CommandSender)p, message.trim());
            }
        }
    }

    public void sendMessageWithPermission(String message, String permission) {
        for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
            if (permission != null && !this.main.getPermissionHandler().hasPermission((CommandSender)p, permission)) continue;
            this.sendMessage((CommandSender)p, message);
        }
    }

    public void logMessage(ProxiedPlayer p, String message) {
        if (this.lastMessages.containsKey(p)) {
            for (int i = this.lastMessages.get(p).length - 1; i > 0; --i) {
                this.lastMessages.get((Object)p)[i] = this.lastMessages.get(p)[i - 1];
            }
            this.lastMessages.get((Object)p)[0] = new LoggedMessage(p, message, new Date());
        }
    }

    public String getMessage(String identifier) {
        if (this.messages.containsKey(identifier)) {
            return this.messages.get(identifier);
        }
        this.main.getLogger().info("Message '" + identifier + "' could not be found. Please update your messages.yml");
        return "";
    }

    public TextComponent translateColorCodes(String text) {
        TextComponent t = new TextComponent("");
        for (BaseComponent b : TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text))) {
            t.addExtra(b);
        }
        return t;
    }

    public HashMap<ProxiedPlayer, LoggedMessage[]> getLastMessages() {
        return this.lastMessages;
    }
}

