/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionHandler {
    private ProxySuite main;
    private List<String> availablePermissions;
    private HashMap<String, List<String>> permissions;

    public PermissionHandler(ProxySuite main) {
        this.main = main;
        this.permissions = new HashMap();
        this.availablePermissions = new ArrayList<String>();
    }

    public void updatePermissions() {
        for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
            this.updatePermissions(p);
        }
    }

    public void updatePermissions(ProxiedPlayer p) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("GetPermissions");
            out.writeUTF(p.getName());
            for (String perm : this.availablePermissions) {
                out.writeUTF(perm);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        p.getServer().sendData("ProxySuite", b.toByteArray());
    }

    public void readAvailablePermissionsFromFile() {
        try {
            String line;
            BufferedReader read = new BufferedReader(new InputStreamReader(((Object)((Object)this.main)).getClass().getResourceAsStream("/availablePermissions.yml")));
            while ((line = read.readLine()) != null) {
                if ((line = line.trim()).trim().equals("") || line.startsWith("#")) continue;
                this.availablePermissions.add(line.trim());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetPermissions() {
        for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
            this.resetPermissions((CommandSender)p);
        }
    }

    public void resetPermissions(CommandSender player) {
        this.permissions.remove(player.getName());
    }

    public void resetPermissions(String player) {
        this.permissions.remove(player);
    }

    public boolean hasPermission(CommandSender sender, String permission) {
        return this.hasPermission(sender, permission, false);
    }

    public boolean hasPermission(CommandSender sender, String permission, boolean ignoreSternchen) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer p = (ProxiedPlayer)sender;
            if (this.permissions.containsKey(p.getName())) {
                if (this.permissions.get(p.getName()).contains(permission.toLowerCase()) || !ignoreSternchen && this.permissions.get(p.getName()).contains("*") || !ignoreSternchen && this.permissions.get(p.getName()).contains(permission.toLowerCase() + ".*")) {
                    return true;
                }
                if (!ignoreSternchen) {
                    String check = "";
                    for (String s : permission.toLowerCase().split("\\.")) {
                        check = check + s + ".";
                        if (!this.permissions.get(p.getName()).contains(check + "*")) continue;
                        this.main.getLogger().info(sender.getName() + " has '" + check + "*'");
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean hasPermission(String player, String permission) {
        if (this.permissions.containsKey(player)) {
            if (this.permissions.get(player).contains(permission.toLowerCase()) || this.permissions.get(player).contains("*")) {
                return true;
            }
            String check = "";
            for (String s : permission.toLowerCase().split("\\.")) {
                check = check + s + ".";
                if (!this.permissions.get(player).contains(check + "*")) continue;
                return true;
            }
        }
        return false;
    }

    public void sendMissingPermissionInfo(CommandSender sender) {
        this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("command.nopermission"));
    }

    public HashMap<String, List<String>> getPermissions() {
        return this.permissions;
    }

    public List<String> getAvailablePermissions() {
        return this.availablePermissions;
    }
}

