/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.ProxySuiteUtils;
import de.sabbertran.proxysuite.utils.WorldInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerHandler {
    private ProxySuite main;
    private ArrayList<UUID> pendingFirstSpawnTeleports;
    private HashMap<ProxiedPlayer, String> prefixes;
    private HashMap<ProxiedPlayer, String> suffixes;
    private ArrayList<ProxiedPlayer> vanishedPlayers;
    private HashMap<String, Integer> ips;
    private HashMap<ProxiedPlayer, WorldInfo> worldInfos;
    private ArrayList<ProxiedPlayer> flying;
    private HashMap<ProxiedPlayer, String> gamemode;

    public PlayerHandler(ProxySuite main) {
        this.main = main;
        this.pendingFirstSpawnTeleports = new ArrayList();
        this.prefixes = new HashMap();
        this.suffixes = new HashMap();
        this.vanishedPlayers = new ArrayList();
        this.ips = new HashMap();
        this.worldInfos = new HashMap();
        this.flying = new ArrayList();
        this.gamemode = new HashMap();
    }

    public ProxiedPlayer getPlayer(String name, CommandSender questioner, boolean useLevenshtein) {
        if (questioner == null) {
            return this.main.getProxy().getPlayer(name);
        }
        if (questioner.getName().toLowerCase().equals(name.toLowerCase())) {
            return (ProxiedPlayer)questioner;
        }
        ProxiedPlayer p = this.main.getProxy().getPlayer(name);
        if (p != null) {
            if (!this.vanishedPlayers.contains(p) || this.main.getPermissionHandler().hasPermission(questioner, "proxysuite.vanish.useincommands", false)) {
                return p;
            }
        } else if (useLevenshtein) {
            Map.Entry<ProxiedPlayer, Integer> entry;
            HashMap<ProxiedPlayer, Integer> distances = new HashMap<ProxiedPlayer, Integer>();
            for (ProxiedPlayer p1 : this.main.getProxy().getPlayers()) {
                if (questioner == p1 || this.vanishedPlayers.contains(p1) && !this.main.getPermissionHandler().hasPermission(questioner, "proxysuite.vanish.useincommands", false)) continue;
                distances.put(p1, ProxySuiteUtils.levenshteinDistance(p1.getName(), name));
            }
            ProxySuiteUtils.sortMapAsc(distances);
            if (distances.size() > 0 && ((entry = distances.entrySet().iterator().next()).getValue() <= 4 || entry.getKey().getName().toLowerCase().contains(name.toLowerCase()) && entry.getKey().getName().length() - entry.getKey().getName().toLowerCase().replace(name.toLowerCase(), "").length() >= 4)) {
                return entry.getKey();
            }
        }
        return null;
    }

    public void registerLogin(final PendingConnection con) {
        block7: {
            try {
                ResultSet rs = this.main.getSQLConnection().createStatement().executeQuery("SELECT id, name FROM " + this.main.getTablePrefix() + "players WHERE uuid = '" + con.getUniqueId() + "'");
                if (rs.next()) {
                    String sql = "UPDATE " + this.main.getTablePrefix() + "players SET name = '" + con.getName() + "', online " + "= '1', last_seen = now() WHERE uuid = '" + con.getUniqueId() + "'";
                    try {
                        this.main.getSQLConnection().createStatement().execute(sql);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                this.pendingFirstSpawnTeleports.add(con.getUniqueId());
                String sql = "INSERT INTO " + this.main.getTablePrefix() + "players (uuid, name, online, last_seen) VALUES" + " ('" + con.getUniqueId() + "', '" + con.getName() + "', '1', now())";
                try {
                    this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.main.getProxy().getScheduler().schedule((Plugin)this.main, new Runnable(){

                    public void run() {
                        PlayerHandler.this.announceNewPlayer(con.getName());
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void registerLogout(final ProxiedPlayer p) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                String sql = "UPDATE " + PlayerHandler.this.main.getTablePrefix() + "players SET name = '" + p.getName() + "', online = " + "'0', last_seen = now() WHERE uuid = '" + p.getUniqueId() + "'";
                try {
                    PlayerHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void sendVanishToServer(ProxiedPlayer p) {
        if (p != null && p.getServer() != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Vanish");
                out.writeUTF(p.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
        }
    }

    public void sendFlyToServer(ProxiedPlayer p) {
        if (p != null && p.getServer() != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("EnableFlight");
                out.writeUTF(p.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
        }
    }

    public void sendUnflyToServer(ProxiedPlayer p) {
        if (p != null && p.getServer() != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("DisableFlight");
                out.writeUTF(p.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
        }
    }

    public void writeFlyToDatabase(final ProxiedPlayer p, final boolean flying) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    String sql = "UPDATE " + PlayerHandler.this.main.getTablePrefix() + "players SET flying = '" + (flying ? "1" : "0") + "' WHERE uuid = '" + p.getUniqueId() + "'";
                    PlayerHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setGamemode(final ProxiedPlayer p, final String gamemode) {
        this.gamemode.put(p, gamemode);
        this.sendGamemodeToServer(p, gamemode);
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    String sql = "UPDATE " + PlayerHandler.this.main.getTablePrefix() + "players SET gamemode = '" + gamemode + "', flying = " + (gamemode.equals("CREATIVE") || gamemode.equals("SPECTATOR") ? "1" : "0") + " WHERE uuid = " + "'" + p.getUniqueId() + "'";
                    PlayerHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        if (this.flying.contains(p)) {
            this.sendFlyToServer(p);
        }
    }

    public void sendGamemodeToServer(ProxiedPlayer p, String gamemode) {
        if (p != null && p.getServer() != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Gamemode");
                out.writeUTF(p.getName());
                out.writeUTF(gamemode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
        }
    }

    public void sendUnvanishToServer(ProxiedPlayer p) {
        if (p != null && p.getServer() != null) {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Unvanish");
                out.writeUTF(p.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.getServer().sendData("ProxySuite", b.toByteArray());
        }
    }

    public void announceNewPlayer(String name) {
        this.main.getMessageHandler().broadcast(this.main.getMessageHandler().getMessage("join.newplayer.announcement").replace("%player%", name));
        if (this.main.getConfig().getBoolean("ProxySuite.WelcomeSound.Enabled")) {
            String sound = this.main.getConfig().getString("ProxySuite.WelcomeSound.Sound");
            float volume = this.main.getConfig().getFloat("ProxySuite.WelcomeSound.Volume");
            float pitch = this.main.getConfig().getFloat("ProxySuite.WelcomeSound.Pitch");
            for (ProxiedPlayer p : this.main.getProxy().getPlayers()) {
                if (!this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.join.welcomesound.receive")) continue;
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(b);
                try {
                    out.writeUTF("PlaySound");
                    out.writeUTF(p.getName());
                    out.writeUTF(sound.toUpperCase());
                    out.writeUTF("" + volume);
                    out.writeUTF("" + pitch);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                p.getServer().sendData("ProxySuite", b.toByteArray());
            }
        }
    }

    public String getPrefix(ProxiedPlayer p) {
        return this.prefixes.containsKey(p) ? this.prefixes.get(p) : "";
    }

    public String getSuffix(ProxiedPlayer p) {
        return this.suffixes.containsKey(p) ? this.suffixes.get(p) : "";
    }

    public ArrayList<UUID> getPendingFirstSpawnTeleports() {
        return this.pendingFirstSpawnTeleports;
    }

    public HashMap<ProxiedPlayer, String> getPrefixes() {
        return this.prefixes;
    }

    public HashMap<ProxiedPlayer, String> getSuffixes() {
        return this.suffixes;
    }

    public ArrayList<ProxiedPlayer> getVanishedPlayers() {
        return this.vanishedPlayers;
    }

    public HashMap<String, Integer> getIps() {
        return this.ips;
    }

    public HashMap<ProxiedPlayer, WorldInfo> getWorldInfos() {
        return this.worldInfos;
    }

    public ArrayList<ProxiedPlayer> getFlying() {
        return this.flying;
    }

    public HashMap<ProxiedPlayer, String> getGamemode() {
        return this.gamemode;
    }
}

