/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Location;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionHandler {
    private ProxySuite main;
    private HashMap<UUID, Runnable> positionRunnables;
    private HashMap<UUID, Location> positions;
    private HashMap<UUID, Location> localPositions;

    public PositionHandler(ProxySuite main) {
        this.main = main;
        this.positionRunnables = new HashMap();
        this.positions = new HashMap();
        this.localPositions = new HashMap();
    }

    public void requestPosition(ProxiedPlayer p) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("GetPosition");
            out.writeUTF(p.getName());
            out.writeUTF(p.getServer().getInfo().getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        p.getServer().sendData("ProxySuite", b.toByteArray());
    }

    public void locationReceived(ProxiedPlayer p, Location loc) {
        if (this.positionRunnables.containsKey(p.getUniqueId())) {
            this.localPositions.put(p.getUniqueId(), loc);
            this.positionRunnables.remove(p.getUniqueId()).run();
        } else {
            this.positions.put(p.getUniqueId(), loc);
        }
    }

    public HashMap<UUID, Location> getLocalPositions() {
        return this.localPositions;
    }

    public void addPositionRunnable(ProxiedPlayer p, Runnable run) {
        this.positionRunnables.put(p.getUniqueId(), run);
    }
}

