/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Home;
import de.sabbertran.proxysuite.utils.Location;
import de.sabbertran.proxysuite.utils.PendingTeleport;
import de.sabbertran.proxysuite.utils.Warp;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeleportHandler {
    private HashMap<ProxiedPlayer, Location> lastPositions;
    private ProxySuite main;
    private ArrayList<PendingTeleport> pendingTeleports;
    private HashMap<ProxiedPlayer, Date> lastTeleports;

    public TeleportHandler(ProxySuite main) {
        this.main = main;
        this.pendingTeleports = new ArrayList();
        this.lastTeleports = new HashMap();
        this.lastPositions = new HashMap();
    }

    public void teleportToPlayer(ProxiedPlayer p, ProxiedPlayer to, boolean ignoreCooldown) {
        if (ignoreCooldown || this.getRemainingCooldown(p) == 0) {
            this.savePlayerLocation(p);
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Teleport");
                out.writeUTF(p.getName());
                out.writeUTF("PLAYER");
                out.writeUTF(to.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            to.getServer().sendData("ProxySuite", b.toByteArray());
            if (p.getServer().getInfo() != to.getServer().getInfo()) {
                p.connect(to.getServer().getInfo());
            }
            this.lastTeleports.put(p, new Date());
        }
    }

    public void teleportToLocation(ProxiedPlayer p, Location loc, boolean ignoreCooldown, boolean ignoreBackSave) {
        if (ignoreCooldown || this.getRemainingCooldown(p) == 0) {
            if (!ignoreBackSave) {
                this.savePlayerLocation(p);
            }
            String sY = "" + loc.getY();
            if (loc.getY() == Double.MAX_VALUE) {
                sY = "HIGHEST";
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Teleport");
                out.writeUTF(p.getName());
                out.writeUTF("LOCATION");
                out.writeUTF(loc.getWorld());
                out.writeUTF("" + loc.getX());
                out.writeUTF(sY);
                out.writeUTF("" + loc.getZ());
                out.writeUTF("" + loc.getPitch());
                out.writeUTF("" + loc.getYaw());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            loc.getServer().sendData("ProxySuite", b.toByteArray());
            if (p.getServer().getInfo() != loc.getServer()) {
                p.connect(loc.getServer());
            }
            this.lastTeleports.put(p, new Date());
        }
    }

    public void teleportToSpawn(ProxiedPlayer p, Location loc, boolean ignoreCooldown) {
        if (ignoreCooldown || this.getRemainingCooldown(p) == 0) {
            this.savePlayerLocation(p);
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Teleport");
                out.writeUTF(p.getName());
                out.writeUTF("SPAWN");
                out.writeUTF(loc.getWorld());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            loc.getServer().sendData("ProxySuite", b.toByteArray());
            if (p.getServer().getInfo() != loc.getServer()) {
                p.connect(loc.getServer());
            }
            this.lastTeleports.put(p, new Date());
        }
    }

    public void teleportToWarp(ProxiedPlayer p, Warp w, boolean ignoreCooldown) {
        if (ignoreCooldown || this.getRemainingCooldown(p) == 0) {
            this.savePlayerLocation(p);
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Teleport");
                out.writeUTF(p.getName());
                out.writeUTF("LOCATION");
                out.writeUTF(w.getLocation().getWorld());
                out.writeUTF("" + w.getLocation().getX());
                out.writeUTF("" + w.getLocation().getY());
                out.writeUTF("" + w.getLocation().getZ());
                out.writeUTF("" + w.getLocation().getPitch());
                out.writeUTF("" + w.getLocation().getYaw());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            w.getLocation().getServer().sendData("ProxySuite", b.toByteArray());
            if (p.getServer().getInfo() != w.getLocation().getServer()) {
                p.connect(w.getLocation().getServer());
            }
            this.lastTeleports.put(p, new Date());
        }
    }

    public void teleportToHome(ProxiedPlayer p, Home h, boolean ignoreCooldown) {
        if (ignoreCooldown || this.getRemainingCooldown(p) == 0) {
            this.savePlayerLocation(p);
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(b);
            try {
                out.writeUTF("Teleport");
                out.writeUTF(p.getName());
                out.writeUTF("LOCATION");
                out.writeUTF(h.getLocation().getWorld());
                out.writeUTF("" + h.getLocation().getX());
                out.writeUTF("" + h.getLocation().getY());
                out.writeUTF("" + h.getLocation().getZ());
                out.writeUTF("" + h.getLocation().getPitch());
                out.writeUTF("" + h.getLocation().getYaw());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            h.getLocation().getServer().sendData("ProxySuite", b.toByteArray());
            if (p.getServer().getInfo() != h.getLocation().getServer()) {
                p.connect(h.getLocation().getServer());
            }
            this.lastTeleports.put(p, new Date());
        }
    }

    private void savePlayerLocation(final ProxiedPlayer p) {
        if (this.main.getPermissionHandler().hasPermission((CommandSender)p, "proxysuite.teleport.savelocation")) {
            this.main.getPositionHandler().requestPosition(p);
            this.main.getPositionHandler().addPositionRunnable(p, new Runnable(){

                public void run() {
                    TeleportHandler.this.lastPositions.put(p, TeleportHandler.this.main.getPositionHandler().getLocalPositions().remove(p.getUniqueId()));
                }
            });
        }
    }

    public void savePlayerLocation(ProxiedPlayer p, Location loc) {
        this.lastPositions.put(p, loc);
    }

    public int getRemainingCooldown(ProxiedPlayer p) {
        int cooldown = this.getCooldown(p.getName());
        if (this.lastTeleports.containsKey(p)) {
            double since = new Date().getTime() - this.lastTeleports.get(p).getTime();
            return since < (double)(cooldown * 1000) ? (int)((double)(cooldown * 1000) - since) / 1000 : 0;
        }
        return 0;
    }

    public boolean canIgnoreCooldown(CommandSender sender) {
        return this.main.getPermissionHandler().hasPermission(sender, "proxysuite.teleport.ignorecooldown");
    }

    private int getCooldown(String player) {
        int lowest = this.main.getConfig().getInt("ProxySuite.Teleport.DefaultCooldown");
        if (this.main.getPermissionHandler().getPermissions().containsKey(player)) {
            for (String s : this.main.getPermissionHandler().getPermissions().get(player)) {
                if (!s.startsWith("proxysuite.teleport.cooldown.")) continue;
                String amount = s.replace("proxysuite.teleport.cooldown.", "");
                try {
                    int temp = Integer.parseInt(amount);
                    if (temp >= lowest) continue;
                    lowest = temp;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return lowest;
    }

    public PendingTeleport getPendingTeleport(ProxiedPlayer p) {
        List test = (List)this.pendingTeleports.clone();
        Collections.reverse(test);
        for (PendingTeleport teleport : test) {
            if ((teleport.getType() != PendingTeleport.TeleportType.TPA || teleport.getTo() != p) && (teleport.getType() != PendingTeleport.TeleportType.TPAHERE || teleport.getFrom() != p)) continue;
            return teleport;
        }
        return null;
    }

    public ProxySuite getMain() {
        return this.main;
    }

    public ArrayList<PendingTeleport> getPendingTeleports() {
        return this.pendingTeleports;
    }

    public HashMap<ProxiedPlayer, Location> getLastPositions() {
        return this.lastPositions;
    }
}

