/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Location;
import de.sabbertran.proxysuite.utils.LoggedMessage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class WarningHandler {
    private ProxySuite main;

    public WarningHandler(ProxySuite main) {
        this.main = main;
    }

    public void addWarn(final String player, final String reason, Location loc, final CommandSender sender) {
        final ProxiedPlayer p = this.main.getPlayerHandler().getPlayer(player, sender, false);
        String lastMessages = "";
        if (p != null && this.main.getMessageHandler().getLastMessages().containsKey(p)) {
            for (LoggedMessage m : this.main.getMessageHandler().getLastMessages().get(p)) {
                if (m == null) continue;
                try {
                    String sql = "INSERT INTO " + this.main.getTablePrefix() + "lastMessages (player, message, date) " + "VALUES (?, ?, FROM_UNIXTIME(" + m.getDate().getTime() / 1000L + "))";
                    PreparedStatement pst = this.main.getSQLConnection().prepareStatement(sql, 1);
                    pst.setString(1, p.getUniqueId().toString());
                    pst.setString(2, m.getMessage());
                    pst.execute();
                    ResultSet rs = pst.getGeneratedKeys();
                    if (!rs.next()) continue;
                    lastMessages = lastMessages + rs.getInt(1) + ";";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (lastMessages.length() > 0) {
                lastMessages = lastMessages.substring(0, lastMessages.length() - 1);
            }
        }
        final String sql = "INSERT INTO " + this.main.getTablePrefix() + "warnings (player, reason, author, server, world," + " x, y, z, pitch, yaw, player_read, lastMessages) SELECT " + this.main.getTablePrefix() + "players.uuid, " + "?, '" + (sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getUniqueId() : "CONSOLE") + "'," + " '" + (loc.getServer() != null ? loc.getServer().getName() : "") + "', '" + loc.getWorld() + "', '" + loc.getX() + "', '" + loc.getY() + "', '" + loc.getZ() + "', '" + loc.getPitch() + "', '" + loc.getYaw() + "', '" + (p != null ? 1 : 0) + "', '" + lastMessages + "' FROM " + this.main.getTablePrefix() + "players WHERE LOWER(" + this.main.getTablePrefix() + "players.name) = '" + player.toLowerCase() + "'";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                boolean ban = false;
                try {
                    PreparedStatement pst = WarningHandler.this.main.getSQLConnection().prepareStatement(sql);
                    pst.setString(1, reason);
                    pst.execute();
                    ResultSet rs = WarningHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT COUNT(" + WarningHandler.this.main.getTablePrefix() + "warnings" + ".id) AS count FROM " + WarningHandler.this.main.getTablePrefix() + "warnings, " + WarningHandler.this.main.getTablePrefix() + "players WHERE " + WarningHandler.this.main.getTablePrefix() + "warnings.player = " + WarningHandler.this.main.getTablePrefix() + "players.uuid AND LOWER(" + WarningHandler.this.main.getTablePrefix() + "players.name) = '" + player.toLowerCase() + "' AND " + WarningHandler.this.main.getTablePrefix() + "warnings.deleted = '0' AND " + WarningHandler.this.main.getTablePrefix() + "warnings" + ".archived = '0' GROUP BY " + WarningHandler.this.main.getTablePrefix() + "warnings.player");
                    ResultSet rs2 = WarningHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT " + WarningHandler.this.main.getTablePrefix() + "warnings.reason FROM " + WarningHandler.this.main.getTablePrefix() + "warnings, " + WarningHandler.this.main.getTablePrefix() + "players WHERE " + WarningHandler.this.main.getTablePrefix() + "warnings.player = " + WarningHandler.this.main.getTablePrefix() + "players.uuid AND LOWER(" + WarningHandler.this.main.getTablePrefix() + "players.name) = " + "'" + player.toLowerCase() + "' AND " + WarningHandler.this.main.getTablePrefix() + "warnings.deleted = '0' " + "AND " + WarningHandler.this.main.getTablePrefix() + "warnings.archived = '0'");
                    boolean bl = ban = rs.next() && rs.getInt("count") == WarningHandler.this.main.getConfig().getInt("ProxySuite.Warnings.UntilBan");
                    if (ban) {
                        String warnReason = "";
                        while (rs2.next()) {
                            warnReason = warnReason + rs2.getString(WarningHandler.this.main.getTablePrefix() + "warnings.reason") + "\n";
                        }
                        if (warnReason.length() > 0) {
                            warnReason = warnReason.substring(0, warnReason.length() - 1);
                        }
                        WarningHandler.this.main.getBanHandler().banPlayer(player, WarningHandler.this.main.getMessageHandler().getMessage("ban.toomanywarnings.reason").replace("%warnings%", warnReason), sender);
                    } else if (p != null && WarningHandler.this.main.getConfig().getBoolean("ProxySuite.Warnings.KickOnWarn")) {
                        WarningHandler.this.main.getBanHandler().kickPlayer(p, reason, sender, true);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (!ban) {
                    WarningHandler.this.main.getMessageHandler().sendMessageWithPermission(WarningHandler.this.main.getMessageHandler().getMessage("warning.info").replace("%player%", p != null ? p.getName() : player).replace("%author%", sender.getName()).replace("%reason%", reason), "proxysuite.messages.warninfo");
                }
            }
        });
    }

    public void deleteWarn(int id) {
        final String sql = "UPDATE " + this.main.getTablePrefix() + "warnings SET deleted = '1' WHERE id = '" + id + "'";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    WarningHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void archiveWarn(int id) {
        final String sql = "UPDATE " + this.main.getTablePrefix() + "warnings SET archived = '1' WHERE id = '" + id + "'";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    WarningHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void teleportToWarn(final ProxiedPlayer p, final int id) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    ResultSet rs = WarningHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT server, world, x, y, z, pitch, yaw FROM " + WarningHandler.this.main.getTablePrefix() + "warnings WHERE id = '" + id + "'");
                    if (rs.next()) {
                        Location loc = new Location(WarningHandler.this.main.getProxy().getServerInfo(rs.getString("server")), rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("pitch"), rs.getFloat("yaw"));
                        WarningHandler.this.main.getTeleportHandler().teleportToLocation(p, loc, true, false);
                    } else {
                        WarningHandler.this.main.getMessageHandler().sendMessage((CommandSender)p, WarningHandler.this.main.getMessageHandler().getMessage("warning.notexists").replace("%id%", "" + id));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void sendWarningList(final String player, final CommandSender sender) {
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    ResultSet rs = WarningHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT name, uuid FROM " + WarningHandler.this.main.getTablePrefix() + "players WHERE LOWER(name) = '" + player.toLowerCase() + "'");
                    if (rs.next()) {
                        ResultSet rs2 = WarningHandler.this.main.getSQLConnection().createStatement().executeQuery("SELECT " + WarningHandler.this.main.getTablePrefix() + "warnings.*, " + WarningHandler.this.main.getTablePrefix() + "players.name AS " + "authorName FROM " + WarningHandler.this.main.getTablePrefix() + "warnings, " + WarningHandler.this.main.getTablePrefix() + "players WHERE " + WarningHandler.this.main.getTablePrefix() + "warnings.player = '" + rs.getString("uuid") + "' AND " + WarningHandler.this.main.getTablePrefix() + "warnings.deleted = '0' AND " + WarningHandler.this.main.getTablePrefix() + "players.uuid = " + WarningHandler.this.main.getTablePrefix() + "warnings.author " + "ORDER BY " + WarningHandler.this.main.getTablePrefix() + "warnings.id DESC");
                        if (rs2.next()) {
                            rs2.previous();
                            WarningHandler.this.main.getMessageHandler().sendMessage(sender, WarningHandler.this.main.getMessageHandler().getMessage("warning.list.header").replace("%player%", rs.getString("name")));
                            while (rs2.next()) {
                                String message = WarningHandler.this.main.getPermissionHandler().hasPermission(sender, "proxysuite.warnings.showadditionalinfo") ? (!rs2.getBoolean("archived") ? WarningHandler.this.main.getMessageHandler().getMessage("warning.list.entry.withextrainfo") : WarningHandler.this.main.getMessageHandler().getMessage("warning.list.entry.archived.withextrainfo")) : (!rs2.getBoolean("archived") ? WarningHandler.this.main.getMessageHandler().getMessage("warning.list.entry") : WarningHandler.this.main.getMessageHandler().getMessage("warning.list.entry.archived"));
                                message = message.replace("%id%", "" + rs2.getInt("id")).replace("%warning%", rs2.getString(WarningHandler.this.main.getTablePrefix() + "warnings.reason")).replace("%dateCreated%", WarningHandler.this.main.getDateFormat().format(rs2.getTimestamp(WarningHandler.this.main.getTablePrefix() + "warnings" + ".date"))).replace("%author%", rs2.getString("authorName")).replace("%server%", rs2.getString(WarningHandler.this.main.getTablePrefix() + "warnings.server")).replace("%world%", rs2.getString(WarningHandler.this.main.getTablePrefix() + "warnings.world")).replace("%coordX%", "" + rs2.getInt(WarningHandler.this.main.getTablePrefix() + "warnings.x")).replace("%coordY%", "" + rs2.getInt(WarningHandler.this.main.getTablePrefix() + "warnings.y")).replace("%coordZ%", "" + rs2.getInt(WarningHandler.this.main.getTablePrefix() + "warnings.z"));
                                WarningHandler.this.main.getMessageHandler().sendMessage(sender, message);
                            }
                        } else {
                            WarningHandler.this.main.getMessageHandler().sendMessage(sender, WarningHandler.this.main.getMessageHandler().getMessage("warning.nofound").replace("%player%", rs.getString("name")));
                        }
                    } else {
                        WarningHandler.this.main.getMessageHandler().sendMessage(sender, WarningHandler.this.main.getMessageHandler().getMessage("command.player.notseen").replace("%player%", player));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void hideWarningInfo(String player) {
        final String sql = "UPDATE " + this.main.getTablePrefix() + "warnings SET player_read = '1' WHERE player_read = " + "'0' AND player IN (SELECT uuid FROM " + this.main.getTablePrefix() + "players WHERE name = '" + player + "')";
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    WarningHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

