/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.handlers;

import de.sabbertran.proxysuite.ProxySuite;
import de.sabbertran.proxysuite.utils.Location;
import de.sabbertran.proxysuite.utils.Warp;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class WarpHandler {
    private ProxySuite main;
    private ArrayList<Warp> warps;

    public WarpHandler(ProxySuite main) {
        this.main = main;
        this.warps = new ArrayList();
    }

    public void readWarpsFromDatabase() {
        this.warps.clear();
        try {
            ResultSet rs = this.main.getSQLConnection().createStatement().executeQuery("SELECT * FROM " + this.main.getTablePrefix() + "warps");
            while (rs.next()) {
                Warp w = new Warp(rs.getString("name"), new Location(this.main.getProxy().getServerInfo(rs.getString("server")), rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("pitch"), rs.getFloat("yaw")), rs.getBoolean("hidden"));
                this.warps.add(w);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setWarp(String name, Location loc, boolean hidden) {
        String sql;
        Warp old = this.getWarp(name, true);
        if (old != null) {
            this.warps.remove(old);
            sql = "UPDATE " + this.main.getTablePrefix() + "warps SET `name` = '" + name + "', `hidden` = '" + (hidden ? 1 : 0) + "', `server` = '" + loc.getServer().getName() + "', " + "`world` = '" + loc.getWorld() + "'," + " `x` = '" + loc.getX() + "', `y` = '" + loc.getY() + "', `z` = '" + loc.getZ() + "', " + "`pitch` = '" + loc.getPitch() + "', `yaw` = '" + loc.getYaw() + "' WHERE LOWER(name) = '" + name.toLowerCase() + "'";
        } else {
            sql = "INSERT INTO " + this.main.getTablePrefix() + "warps (name, hidden, server, world, x, y, z, pitch, yaw) " + "VALUES ('" + name + "', '" + (hidden ? 1 : 0) + "', '" + loc.getServer().getName() + "', '" + loc.getWorld() + "', '" + loc.getX() + "', " + "'" + loc.getY() + "', '" + loc.getZ() + "', '" + loc.getPitch() + "', '" + loc.getYaw() + "')";
        }
        Warp w = new Warp(name, loc, hidden);
        this.warps.add(w);
        final String sql2 = sql;
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    WarpHandler.this.main.getSQLConnection().createStatement().execute(sql2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteWarp(Warp w) {
        final String sql = "DELETE FROM " + this.main.getTablePrefix() + "warps WHERE `name` = '" + w.getName() + "'";
        this.warps.remove(w);
        this.main.getProxy().getScheduler().runAsync((Plugin)this.main, new Runnable(){

            public void run() {
                try {
                    WarpHandler.this.main.getSQLConnection().createStatement().execute(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void sendWarpList(CommandSender sender, boolean includeHidden) {
        this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("warp.list.header"));
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer p = (ProxiedPlayer)sender;
            String warps = "[";
            for (Warp w : this.warps) {
                if (w.isHidden() && !includeHidden) continue;
                String entry = this.main.getPermissionHandler().hasPermission(sender, "proxysuite.warps.showcoordinates") ? (!w.isHidden() ? this.main.getMessageHandler().getMessage("warp.list.entry.withlocation") : this.main.getMessageHandler().getMessage("warp.list.entry.hidden.withlocation")) : (!w.isHidden() ? this.main.getMessageHandler().getMessage("warp.list.entry") : this.main.getMessageHandler().getMessage("warp.list.entry.hidden"));
                entry = entry.replace("%warp%", w.getName()).replace("%server%", w.getLocation().getServer().getName()).replace("%world%", w.getLocation().getWorld()).replace("%coordX%", "" + w.getLocation().getXInt()).replace("%coordY%", "" + w.getLocation().getYInt()).replace("%coordZ%", "" + w.getLocation().getZInt());
                entry = entry.startsWith("{") && entry.endsWith("}") || entry.startsWith("[") && entry.endsWith("]") ? entry + ",{\"text\":\", \"}," : entry + ", ";
                warps = warps + entry;
            }
            if (warps.endsWith(", ")) {
                warps = warps.substring(0, warps.length() - 2);
            } else if (warps.endsWith(",{\"text\":\", \"},")) {
                warps = warps.substring(0, warps.length() - 15);
            }
            warps = warps + "]";
            if (warps.equals("[\"\",]")) {
                warps = this.main.getMessageHandler().getMessage("warp.list.nofound");
            }
            this.main.getMessageHandler().sendMessage((CommandSender)p, warps);
        } else {
            String warps = "";
            for (Warp w : this.warps) {
                if (w.isHidden() && !includeHidden) continue;
                warps = warps + w.getName() + ", ";
            }
            if (warps.length() > 0) {
                warps = warps.substring(0, warps.length() - 2);
            }
            sender.sendMessage((BaseComponent)new TextComponent(warps));
        }
        this.main.getMessageHandler().sendMessage(sender, this.main.getMessageHandler().getMessage("warp.list.footer"));
    }

    public Warp getWarp(String name, boolean includeHidden) {
        if (name != null) {
            for (Warp w : this.warps) {
                if (!w.getName().equalsIgnoreCase(name) || w.isHidden() && !includeHidden) continue;
                return w;
            }
        }
        return null;
    }
}

