/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.utils;

import net.md_5.bungee.api.config.ServerInfo;

public class Location {
    private ServerInfo server;
    private String world;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public Location(ServerInfo server, String world) {
        this.server = server;
        this.world = world;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
    }

    public Location(ServerInfo server, String world, double x, double y, double z) {
        this.server = server;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
    }

    public Location(ServerInfo server, String world, double x, double y, double z, float pitch, float yaw) {
        this.server = server;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public String toString() {
        return "Location{server=" + this.server.getName() + ", world='" + this.world + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + '}';
    }

    public ServerInfo getServer() {
        return this.server;
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getXInt() {
        return (int)Math.floor(this.x);
    }

    public int getYInt() {
        return (int)Math.floor(this.y);
    }

    public int getZInt() {
        return (int)Math.floor(this.z);
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }
}

