/*
 * Decompiled with CFR 0.152.
 */
package de.sabbertran.proxysuite.utils;

import de.sabbertran.proxysuite.handlers.TeleportHandler;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;

public class PendingTeleport {
    private TeleportHandler handler;
    private TeleportType type;
    private ProxiedPlayer from;
    private ProxiedPlayer to;
    private ScheduledTask task;

    public PendingTeleport(TeleportHandler handler, TeleportType type, ProxiedPlayer from, ProxiedPlayer to, int delay) {
        this.handler = handler;
        this.type = type;
        this.from = from;
        this.to = to;
        this.scheduleCancel(delay);
    }

    private void scheduleCancel(int delay) {
        this.task = this.handler.getMain().getProxy().getScheduler().schedule((Plugin)this.handler.getMain(), new Runnable(){

            public void run() {
                PendingTeleport.this.cancel();
            }
        }, (long)delay, TimeUnit.SECONDS);
    }

    public void cancel() {
        if (this.type == TeleportType.TPA) {
            if (this.from.getServer() != null) {
                this.handler.getMain().getMessageHandler().sendMessage((CommandSender)this.from, this.handler.getMain().getMessageHandler().getMessage("teleport.request.timeout").replace("%player%", this.to.getName()).replace("%prefix%", this.handler.getMain().getPlayerHandler().getPrefix(this.to)).replace("%suffix%", this.handler.getMain().getPlayerHandler().getSuffix(this.to)));
            }
            if (this.to.getServer() != null) {
                this.handler.getMain().getMessageHandler().sendMessage((CommandSender)this.to, this.handler.getMain().getMessageHandler().getMessage("teleport.request.timeout.other").replace("%player%", this.from.getName()).replace("%prefix%", this.handler.getMain().getPlayerHandler().getPrefix(this.from)).replace("%suffix%", this.handler.getMain().getPlayerHandler().getSuffix(this.from)));
            }
        } else if (this.type == TeleportType.TPAHERE) {
            if (this.from.getServer() != null) {
                this.handler.getMain().getMessageHandler().sendMessage((CommandSender)this.from, this.handler.getMain().getMessageHandler().getMessage("teleport.request.timeout.other").replace("%player%", this.to.getName()).replace("%prefix%", this.handler.getMain().getPlayerHandler().getPrefix(this.to)).replace("%suffix%", this.handler.getMain().getPlayerHandler().getSuffix(this.to)));
            }
            if (this.to.getServer() != null) {
                this.handler.getMain().getMessageHandler().sendMessage((CommandSender)this.to, this.handler.getMain().getMessageHandler().getMessage("teleport.request.timeout").replace("%player%", this.from.getName()).replace("%prefix%", this.handler.getMain().getPlayerHandler().getPrefix(this.from)).replace("%suffix%", this.handler.getMain().getPlayerHandler().getSuffix(this.from)));
            }
        }
        this.handler.getPendingTeleports().remove(this);
    }

    public void cancelCancel() {
        if (this.task != null) {
            this.handler.getMain().getProxy().getScheduler().cancel(this.task);
            this.task = null;
        }
    }

    public ProxiedPlayer getTo() {
        return this.to;
    }

    public ProxiedPlayer getFrom() {
        return this.from;
    }

    public TeleportType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TeleportType {
        TPA,
        TPAHERE;

    }
}

