/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hider.VisibilityAdjuster;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class SVUtils {
    protected static SuperVanish plugin = (SuperVanish)Bukkit.getServer().getPluginManager().getPlugin("SuperVanish");
    protected static FileConfiguration cfg;
    protected static FileConfiguration pd;

    protected List<String> getInvisiblePlayers() {
        return pd.getStringList("InvisiblePlayers");
    }

    public void hidePlayer(Player p) {
        VisibilityAdjuster.getInstance().hidePlayer(p);
    }

    public void showPlayer(Player p) {
        VisibilityAdjuster.getInstance().showPlayer(p);
    }

    public void showPlayer(Player p, boolean hideJoinMsg) {
        VisibilityAdjuster.getInstance().showPlayer(p, hideJoinMsg);
    }

    protected boolean isHidden(Player p) {
        return this.getInvisiblePlayers().contains(p.getUniqueId().toString());
    }

    public SVUtils() {
        if (plugin == null) {
            throw new RuntimeException("Plugin cannot be null!");
        }
        cfg = SVUtils.plugin.cfg;
        pd = SVUtils.plugin.pd;
    }

    protected boolean canDo(CommandSender p, CommandAction cmd) {
        if (!(p instanceof Player) && !cmd.canConsole()) {
            p.sendMessage(this.convertString(this.getMsg("InvalidSenderMessage"), p));
            return false;
        }
        if (!p.hasPermission(cmd.getPerm())) {
            p.sendMessage(this.convertString(this.getMsg("NoPermissionMessage"), p));
            return false;
        }
        return true;
    }

    protected String getMsg(String msg) {
        return plugin.getMsg(msg);
    }

    public String convertString(String message, CommandSender p) {
        return plugin.convertString(message, p);
    }

    protected static enum CommandAction {
        VANISH_SELF("sv.use", false),
        VANISH_OTHER("sv.others", true),
        LIST("sv.list", true),
        LOGIN("sv.login", false),
        LOGOUT("sv.logout", false),
        TOGGLE_ITEM_PICKUPS("sv.toggleitempickups", false),
        UPDATE_CFG("sv.updatecfg", true),
        RELOAD("sv.reload", true);

        private String perm;
        private boolean console;

        private CommandAction(String perm, boolean console) {
            this.perm = perm;
            this.console = console;
        }

        String getPerm() {
            return this.perm;
        }

        boolean canConsole() {
            return this.console;
        }
    }
}

