/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import de.myzelyam.supervanish.SVUtils;
import de.myzelyam.supervanish.cmd.CmdManager;
import de.myzelyam.supervanish.config.ConfigCfg;
import de.myzelyam.supervanish.config.MessagesCfg;
import de.myzelyam.supervanish.events.JoinEvent;
import de.myzelyam.supervanish.events.PlayerControl;
import de.myzelyam.supervanish.events.QuitEvent;
import de.myzelyam.supervanish.events.WorldChangeEvent;
import de.myzelyam.supervanish.hider.ActionBarManager;
import de.myzelyam.supervanish.hider.ServerlistAdjustments;
import de.myzelyam.supervanish.hider.SilentChestListeners;
import de.myzelyam.supervanish.hooks.DisguiseCraftHook;
import de.myzelyam.supervanish.hooks.LibsDisguisesHook;
import de.myzelyam.supervanish.hooks.SuperTrailsHook;
import de.myzelyam.supervanish.hooks.TrailGUIHook;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import me.confuser.barapi.BarAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class SuperVanish
extends JavaPlugin {
    private final List<String> nonRequiredConfigUpdates = Arrays.asList(new String[0]);
    private final List<String> nonRequiredMsgsUpdates = Arrays.asList("5.3.1-5.4.5", "5.3.2-5.4.5", "5.3.3-5.4.5", "5.3.4-5.4.5", "5.3.5-5.4.5", "5.4.0-5.4.5", "5.4.1-5.4.5", "5.4.2-5.4.5", "5.4.3-5.4.5", "5.4.4-5.4.5");
    public static final boolean SERVER_IS_ONE_DOT_SEVEN = Bukkit.getVersion().contains("(MC: 1.7");
    public boolean requiresCfgUpdate = false;
    public boolean requiresMsgsUpdate = false;
    public Team ghostTeam;
    public FileConfiguration msgs;
    public FileConfiguration cfg;
    public File pdf = new File(String.valueOf(this.getDataFolder().getPath()) + File.separator + "playerdata.yml");
    public FileConfiguration pd = YamlConfiguration.loadConfiguration((File)this.pdf);
    public MessagesCfg mcfg;
    public ConfigCfg ccfg;

    public void spd() {
        try {
            this.pd.save(this.pdf);
        }
        catch (IOException e) {
            this.printException(e);
        }
    }

    public void onEnable() {
        try {
            this.prepareConfig();
            this.registerEvents();
            this.checkForReload();
            this.checkGhostPlayers();
            if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
                ServerlistAdjustments.setupProtocolLib();
                if (this.cfg.getBoolean("Configuration.Players.SilentOpenChest")) {
                    SilentChestListeners.setupAnimationListener();
                    SilentChestListeners.setupSoundListener();
                }
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void onDisable() {
        SVUtils.cfg = null;
        SVUtils.pd = null;
    }

    private void prepareConfig() {
        try {
            this.mcfg = new MessagesCfg();
            this.mcfg.saveDefaultConfig();
            this.msgs = this.mcfg.getConfig();
            this.ccfg = new ConfigCfg();
            this.ccfg.saveDefaultConfig();
            this.cfg = this.ccfg.getConfig();
            this.pd.options().header("SuperVanish v" + this.getDescription().getVersion() + " - Playerdata");
            this.pd.options().copyHeader(true);
            this.spd();
            this.checkConfig();
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    private void checkGhostPlayers() {
        try {
            if (this.cfg.getBoolean("Configuration.Players.EnableGhostPlayers")) {
                List vpl = this.pd.getStringList("InvisiblePlayers");
                this.ghostTeam = Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeam("SuperVanishGT");
                if (this.ghostTeam == null) {
                    this.ghostTeam = Bukkit.getServer().getScoreboardManager().getMainScoreboard().registerNewTeam("SuperVanishGT");
                }
                this.ghostTeam.setCanSeeFriendlyInvisibles(true);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!this.ghostTeam.hasPlayer((OfflinePlayer)p)) {
                        if (!p.hasPermission("sv.see") && !p.hasPermission("sv.use") && !vpl.contains(p.getUniqueId().toString())) continue;
                        this.ghostTeam.addPlayer((OfflinePlayer)p);
                        continue;
                    }
                    if (p.hasPermission("sv.see") || p.hasPermission("sv.use") || vpl.contains(p.getUniqueId().toString())) continue;
                    this.ghostTeam.removePlayer((OfflinePlayer)p);
                }
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    private void checkForReload() {
        try {
            List vpl = this.pd.getStringList("InvisiblePlayers");
            if (this.getServer().getPluginManager().getPlugin("BarAPI") != null && this.cfg.getBoolean("Configuration.Messages.UseBarAPI")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!vpl.contains(p.getUniqueId().toString())) continue;
                    String onVanish = this.msgs.getString("Messages.OnVanish");
                    BarAPI.setMessage((Player)p, (String)this.convertString(onVanish, p), (float)100.0f);
                }
            }
            if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null && this.cfg.getBoolean("Configuration.Messages.DisplayActionBarsToInvisiblePlayers") && !SERVER_IS_ONE_DOT_SEVEN) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!vpl.contains(p.getUniqueId().toString())) continue;
                    ActionBarManager.getInstance(this).addActionBar(p);
                }
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    private EventPriority getEventPriority(Class<? extends Event> clazz) {
        try {
            String eventName = clazz.getSimpleName();
            String cfgp = this.cfg.getString("Configuration.CompatibilityOptions." + eventName + "Priority");
            if (cfgp == null) {
                return EventPriority.NORMAL;
            }
            EventPriority priority = EventPriority.valueOf((String)cfgp);
            return priority == null ? EventPriority.NORMAL : priority;
        }
        catch (Exception e) {
            this.printException(e);
            return EventPriority.NORMAL;
        }
    }

    private void registerEvents() {
        try {
            PluginManager pm = this.getServer().getPluginManager();
            pm.registerEvents((Listener)new PlayerControl(), (Plugin)this);
            pm.registerEvents((Listener)WorldChangeEvent.getInstance(), (Plugin)this);
            if (pm.isPluginEnabled("LibsDisguises") && this.cfg.getBoolean("Configuration.Hooks.EnableLibsDisguisesHook")) {
                pm.registerEvents((Listener)new LibsDisguisesHook(), (Plugin)this);
            }
            if (pm.isPluginEnabled("DisguiseCraft") && this.cfg.getBoolean("Configuration.Hooks.EnableDisguiseCraftHook")) {
                pm.registerEvents((Listener)new DisguiseCraftHook(), (Plugin)this);
            }
            if (pm.isPluginEnabled("TrailGUI") && this.cfg.getBoolean("Configuration.Hooks.EnableTrailGUIHook", true)) {
                TrailGUIHook.replaceMoveListener();
            }
            if (pm.isPluginEnabled("SuperTrails") && this.cfg.getBoolean("Configuration.Hooks.EnableSuperTrailsHook", true)) {
                new SuperTrailsHook((Plugin)this);
            }
            JoinEvent jevent = new JoinEvent();
            pm.registerEvent(PlayerJoinEvent.class, (Listener)jevent, this.getEventPriority(PlayerJoinEvent.class), (EventExecutor)jevent, (Plugin)this, false);
            QuitEvent qevent = new QuitEvent();
            pm.registerEvent(PlayerQuitEvent.class, (Listener)qevent, this.getEventPriority(PlayerQuitEvent.class), (EventExecutor)qevent, (Plugin)this, false);
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    public void printException(Exception e) {
        try {
            System.err.println("[SuperVanish] Unknown Exception occurred!");
            if (this.requiresCfgUpdate || this.requiresMsgsUpdate) {
                System.err.println("[SuperVanish] You have an outdated configuration,");
                System.err.println("[SuperVanish] regenerating it by using '/sv updatecfg' might fix this problem.");
            } else {
                System.err.println("[SuperVanish] Please report this issue!");
            }
            System.err.println("Message: ");
            System.err.println("  " + e.getMessage());
            System.err.println("General information: ");
            String plugins = "";
            Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
            int n = pluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                Plugin pl = pluginArray[n2];
                if (!pl.getName().equalsIgnoreCase("SuperVanish")) {
                    plugins = String.valueOf(plugins) + pl.getName() + " v" + pl.getDescription().getVersion().toString() + ", ";
                }
                ++n2;
            }
            System.err.println("  ServerVersion: " + this.getServer().getVersion().toString());
            System.err.println("  PluginVersion: " + this.getDescription().getVersion().toString());
            System.err.println("  ServerPlugins: " + plugins);
            System.err.println("StackTrace: ");
            e.printStackTrace();
            System.err.println("[SuperVanish] Please include this information");
            System.err.println("[SuperVanish] if you report the issue.");
        }
        catch (Exception e2) {
            System.err.println("[SuperVanish] An exception occurred while trying to print a detailed stacktrace, printing an undetailed stacktrace of both exceptions:");
            System.err.println("ORIGINAL EXCEPTION:");
            e.printStackTrace();
            System.err.println("SECOND EXCEPTION:");
            e2.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdLabel, String[] args) {
        new CmdManager(cmd, sender, args, cmdLabel);
        return true;
    }

    public void checkConfig() {
        try {
            String currentCfgVersion = this.cfg.getString("ConfigVersion");
            String newestVersion = this.getDescription().getVersion();
            String currentMsgsVersion = this.msgs.getString("MessagesVersion");
            this.requiresMsgsUpdate = this.requiresUpdate(currentMsgsVersion, newestVersion, false);
            this.requiresCfgUpdate = this.requiresUpdate(currentCfgVersion, newestVersion, true);
            if (newestVersion.equals(currentCfgVersion)) {
                this.requiresCfgUpdate = false;
            }
            if (newestVersion.equals(currentMsgsVersion)) {
                this.requiresMsgsUpdate = false;
            }
        }
        catch (Exception e) {
            this.printException(e);
        }
    }

    private boolean requiresUpdate(String currentVersion, String newestVersion, boolean checkCfg) {
        if (currentVersion == null) {
            return true;
        }
        for (String s : checkCfg ? this.nonRequiredConfigUpdates : this.nonRequiredMsgsUpdates) {
            String[] splitted = s.split("-");
            if (!currentVersion.equalsIgnoreCase(splitted[0]) || !newestVersion.equalsIgnoreCase(splitted[1])) continue;
            return false;
        }
        return true;
    }

    public String convertString(String msg, Object unspecifiedPlayer) {
        try {
            if (unspecifiedPlayer instanceof OfflinePlayer && !(unspecifiedPlayer instanceof Player)) {
                OfflinePlayer specifiedPlayer = (OfflinePlayer)unspecifiedPlayer;
                if (this.getServer().getPluginManager().getPlugin("PermissionsEx") != null) {
                    msg = msg.replace("%prefix", "").replace("%suffix", "");
                }
                if (this.getServer().getPluginManager().getPlugin("Essentials") != null) {
                    msg = msg.replace("%nick", specifiedPlayer.getName());
                }
                msg = msg.replace("%d", specifiedPlayer.getName()).replace("%p", specifiedPlayer.getName()).replace("%t", specifiedPlayer.getName());
            } else if (unspecifiedPlayer instanceof Player) {
                Essentials ess;
                User u;
                PermissionUser user;
                Player specifiedPlayer = (Player)unspecifiedPlayer;
                if (this.getServer().getPluginManager().getPlugin("PermissionsEx") != null && (user = PermissionsEx.getUser((Player)specifiedPlayer)) != null) {
                    if (user.getPrefix() != null) {
                        msg = msg.replace("%prefix", user.getPrefix());
                    }
                    if (user.getSuffix() != null) {
                        msg = msg.replace("%suffix", user.getSuffix());
                    }
                }
                if (this.getServer().getPluginManager().getPlugin("Essentials") != null && (u = (ess = (Essentials)Bukkit.getServer().getPluginManager().getPlugin("Essentials")).getUser(specifiedPlayer)) != null && u.getNickname() != null) {
                    msg = msg.replace("%nick", u.getNickname());
                }
                msg = msg.replace("%d", specifiedPlayer.getDisplayName()).replace("%p", specifiedPlayer.getName()).replace("%t", specifiedPlayer.getPlayerListName());
            } else if (unspecifiedPlayer instanceof CommandSender && !(unspecifiedPlayer instanceof Player)) {
                if (this.getServer().getPluginManager().getPlugin("PermissionsEx") != null) {
                    msg = msg.replace("%prefix", "").replace("%suffix", "");
                }
                msg = msg.replace("%d", "Console").replace("%p", "Console").replace("%t", "Console");
            }
            msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
            return msg;
        }
        catch (Exception e) {
            this.printException(e);
            return "SV-Error occurred; more information in console";
        }
    }

    public String getMsg(String msg) {
        String rn = this.msgs.getString("Messages." + msg);
        if (rn == null) {
            rn = "SV: Unavailable message in messages.yml: " + msg;
        }
        return rn;
    }

    public FileConfiguration getConfig() {
        return this.cfg;
    }

    public void saveDefaultConfig() {
        this.ccfg.saveDefaultConfig();
    }
}

