/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.events;

import de.myzelyam.supervanish.SVUtils;
import de.myzelyam.supervanish.hooks.EssentialsHook;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PlayerControl
extends SVUtils
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTp(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        if (!this.isHidden(p)) {
            return;
        }
        if (e.getFrom().getWorld().getName().equals(e.getTo().getWorld().getName())) {
            return;
        }
        if (cfg.getBoolean("Configuration.Players.AddNightVision")) {
            p.removePotionEffect(PotionEffectType.NIGHT_VISION);
        }
        if (cfg.getBoolean("Configuration.Players.EnableGhostPlayers")) {
            p.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void food(FoodLevelChangeEvent e) {
        try {
            Player p;
            List vpl = pd.getStringList("InvisiblePlayers");
            if (e.getEntity() instanceof Player && !cfg.getBoolean("Configuration.Players.DisableHungerForInvisiblePlayers") && vpl.contains((p = (Player)e.getEntity()).getUniqueId().toString())) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void dmg(EntityDamageEvent e) {
        try {
            if (!(e.getEntity() instanceof Player)) {
                return;
            }
            Player p = (Player)e.getEntity();
            List vpl = pd.getStringList("InvisiblePlayers");
            if (vpl.contains(p.getUniqueId().toString())) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void target(EntityTargetEvent e) {
        try {
            if (!(e.getTarget() instanceof Player)) {
                return;
            }
            Player p = (Player)e.getTarget();
            List vpl = pd.getStringList("InvisiblePlayers");
            if (vpl.contains(p.getUniqueId().toString())) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void pressurePlate(PlayerInteractEvent e) {
        try {
            List vpl = pd.getStringList("InvisiblePlayers");
            if (!cfg.getBoolean("Configuration.Players.DisablePressurePlatesForInvisiblePlayers")) {
                return;
            }
            if (e.getAction().equals((Object)Action.PHYSICAL) && (e.getClickedBlock().getType() == Material.STONE_PLATE || e.getClickedBlock().getType() == Material.WOOD_PLATE || e.getClickedBlock().getType() == Material.TRIPWIRE) && vpl.contains(e.getPlayer().getUniqueId().toString())) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPickUp(PlayerPickupItemEvent e) {
        try {
            Player p = e.getPlayer();
            List vpl = pd.getStringList("InvisiblePlayers");
            if (vpl.contains(p.getUniqueId().toString())) {
                if (pd.get("PlayerData." + p.getUniqueId().toString() + ".itemPickUps") == null) {
                    if (cfg.getBoolean("Configuration.Players.DisableItemPickUpsByDefault")) {
                        e.setCancelled(true);
                    } else {
                        return;
                    }
                }
                if (!pd.getBoolean("PlayerData." + p.getUniqueId().toString() + ".itemPickUps")) {
                    e.setCancelled(true);
                }
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlace(BlockPlaceEvent e) {
        try {
            Player p = e.getPlayer();
            List<String> vpl = this.getInvisiblePlayers();
            if (vpl.contains(p.getUniqueId().toString()) && cfg.getBoolean("Configuration.Players.PreventBlockPlacing")) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBreak(BlockBreakEvent e) {
        try {
            Player p = e.getPlayer();
            List<String> vpl = this.getInvisiblePlayers();
            if (vpl.contains(p.getUniqueId().toString()) && cfg.getBoolean("Configuration.Players.PreventBlockBreaking")) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHit(EntityDamageByEntityEvent e) {
        try {
            if (!(e.getDamager() instanceof Player)) {
                return;
            }
            if (e.getEntity() == null) {
                return;
            }
            Player p = (Player)e.getDamager();
            List<String> vpl = this.getInvisiblePlayers();
            if (vpl == null) {
                return;
            }
            if (vpl.contains(p.getUniqueId().toString()) && cfg.getBoolean("Configuration.Players.PreventHittingEntities")) {
                e.setCancelled(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler
    public void onBlockBlock(BlockCanBuildEvent e) {
        try {
            List vpl = pd.getStringList("InvisiblePlayers");
            Block b = e.getBlock();
            Location blockloc = b.getLocation();
            for (Player p : b.getWorld().getPlayers()) {
                if (!vpl.contains(p.getUniqueId().toString()) || !(p.getLocation().distanceSquared(blockloc) <= 2.0)) continue;
                e.setBuildable(true);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler
    public void onPlayerArrowBlock(EntityDamageByEntityEvent e) {
        try {
            List vpl = pd.getStringList("InvisiblePlayers");
            Entity entityDamager = e.getDamager();
            Entity entityDamaged = e.getEntity();
            if (entityDamager instanceof Arrow) {
                Player damaged;
                Arrow arrow = (Arrow)entityDamager;
                if (entityDamaged instanceof Player && arrow.getShooter() instanceof Player && vpl.contains((damaged = (Player)entityDamaged).getUniqueId().toString())) {
                    Vector velocity = arrow.getVelocity();
                    damaged.teleport(damaged.getLocation().add(0.0, 2.0, 0.0));
                    Arrow nextArrow = (Arrow)arrow.getShooter().launchProjectile(Arrow.class);
                    nextArrow.setVelocity(velocity);
                    nextArrow.setBounce(false);
                    nextArrow.setShooter(arrow.getShooter());
                    nextArrow.setFireTicks(arrow.getFireTicks());
                    nextArrow.setCritical(arrow.isCritical());
                    nextArrow.setKnockbackStrength(arrow.getKnockbackStrength());
                    e.setCancelled(true);
                    arrow.remove();
                }
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEssentialsEnable(PluginEnableEvent e) {
        try {
            final List vpl = pd.getStringList("InvisiblePlayers");
            if (e.getPlugin().getName().equalsIgnoreCase("Essentials") && cfg.getBoolean("Configuration.Hooks.EnableEssentialsHook")) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Player p : Bukkit.getOnlinePlayers()) {
                            if (!vpl.contains(p.getUniqueId().toString())) continue;
                            EssentialsHook.hidePlayer(p);
                        }
                    }
                }, 5L);
            }
        }
        catch (Exception er) {
            plugin.printException(er);
        }
    }
}

