/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.events;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hider.PlayerHider;
import de.myzelyam.supervanish.hider.TabManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WorldChangeEvent
extends PlayerHider
implements Listener {
    private SuperVanish plugin = (SuperVanish)Bukkit.getServer().getPluginManager().getPlugin("SuperVanish");
    private static WorldChangeEvent instance;
    private int hideDelay = cfg.getInt("Configuration.CompatibilityOptions.AdctionDelay.HideDelayOnWorldChangeInTicks");
    private int invisDelay;
    private int tabDelay;

    public static WorldChangeEvent getInstance() {
        if (instance == null) {
            instance = new WorldChangeEvent();
        }
        return instance;
    }

    private WorldChangeEvent() {
        if (!cfg.getBoolean("Configuration.CompatibilityOptions.ActionDelay.Enable")) {
            this.hideDelay = 0;
        }
        this.invisDelay = cfg.getInt("Configuration.CompatibilityOptions.ActionDelay.InvisibilityPotionDelayOnWorldChangeInTicks");
        if (!cfg.getBoolean("Configuration.CompatibilityOptions.ActionDelay.Enable")) {
            this.invisDelay = 0;
        }
        this.tabDelay = cfg.getInt("Configuration.CompatibilityOptions.ActionDelay.TabNameChangeDelayOnWorldChangeInTicks");
        if (!cfg.getBoolean("Configuration.CompatibilityOptions.ActionDelay.Enable")) {
            this.tabDelay = 0;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWC(PlayerChangedWorldEvent e) {
        try {
            final Player p = e.getPlayer();
            if (!this.isHidden(p)) {
                return;
            }
            if (cfg.getBoolean("Configuration.Players.ReappearOnWorldChange")) {
                this.showPlayer(p);
                return;
            }
            if (this.hideDelay > 0) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        WorldChangeEvent.this.hideToAll(p);
                    }
                }, (long)this.hideDelay);
            } else {
                this.hideToAll(p);
            }
            if (!p.getActivePotionEffects().contains(PotionEffectType.INVISIBILITY) && cfg.getBoolean("Configuration.Players.EnableGhostPlayers")) {
                if (this.invisDelay > 0) {
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
                        }
                    }, (long)this.invisDelay);
                } else {
                    p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
                }
            }
            if (cfg.getBoolean("Configuration.Players.AddNightVision")) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 1));
            }
            if (cfg.getBoolean("Configuration.Tablist.ChangeTabNames")) {
                if (this.tabDelay > 0) {
                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            TabManager.getInstance().adjustTabname(p, TabManager.SVTabAction.SET_CUSTOM_TABNAME);
                        }
                    }, (long)this.tabDelay);
                } else {
                    TabManager.getInstance().adjustTabname(p, TabManager.SVTabAction.SET_CUSTOM_TABNAME);
                }
            }
        }
        catch (Exception er) {
            this.plugin.printException(er);
        }
    }
}

