/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hider;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.myzelyam.supervanish.SuperVanish;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarManager {
    private static ActionBarManager instance;
    private List<Player> actionBars = new ArrayList<Player>();

    private ActionBarManager(SuperVanish plugin) {
        this.startTimerTask(plugin);
    }

    public static ActionBarManager getInstance(SuperVanish plugin) {
        if (instance == null) {
            instance = new ActionBarManager(plugin);
        }
        return instance;
    }

    private void startTimerTask(final SuperVanish plugin) {
        new BukkitRunnable(){

            public void run() {
                for (Player p : ActionBarManager.this.actionBars) {
                    ActionBarManager.this.sendActionBar(p, plugin.convertString(plugin.getMsg("ActionBarMessage"), p));
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 40L);
    }

    private void sendActionBar(Player p, String bar) {
        String json = "{\"text\": \"" + ChatColor.translateAlternateColorCodes((char)'&', (String)bar) + "\"}";
        WrappedChatComponent msg = WrappedChatComponent.fromJson((String)json);
        PacketContainer chatMsg = new PacketContainer(PacketType.Play.Server.CHAT);
        chatMsg.getChatComponents().write(0, (Object)msg);
        chatMsg.getBytes().write(0, (Object)2);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(p, chatMsg);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot send packet " + chatMsg, e);
        }
    }

    public void addActionBar(Player p) {
        if (!this.actionBars.contains(p)) {
            this.actionBars.add(p);
        }
    }

    public void removeActionBar(Player p) {
        this.actionBars.remove(p);
    }
}

