/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hider;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import de.myzelyam.api.vanish.VanishAPI;
import de.myzelyam.supervanish.SVUtils;
import de.myzelyam.supervanish.SuperVanish;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class SilentChestListeners
extends SVUtils {
    private static SuperVanish plugin = (SuperVanish)Bukkit.getPluginManager().getPlugin("SuperVanish");

    public static void setupAnimationListener() {
        final SuperVanish sv = plugin;
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)plugin, ListenerPriority.HIGH, new PacketType[]{PacketType.Play.Server.BLOCK_ACTION}){

            public void onPacketSending(PacketEvent e) {
                try {
                    if (e.getPacketType() == PacketType.Play.Server.BLOCK_ACTION) {
                        Player listener = e.getPlayer();
                        if ((Integer)e.getPacket().getIntegers().read(1) != 1) {
                            return;
                        }
                        BlockPosition position = (BlockPosition)e.getPacket().getBlockPositionModifier().read(0);
                        if (position == null) {
                            return;
                        }
                        Location loc = position.toVector().toLocation(listener.getWorld());
                        Block b = listener.getWorld().getBlockAt(loc);
                        if (!(b.getState() instanceof Chest)) {
                            return;
                        }
                        Chest chest = (Chest)b.getState();
                        Inventory inv = chest.getBlockInventory();
                        List humanViewers = inv.getViewers();
                        for (HumanEntity entity : humanViewers) {
                            if (!(entity instanceof Player) || !VanishAPI.isInvisible((Player)entity)) continue;
                            e.setCancelled(true);
                        }
                    }
                }
                catch (Exception er) {
                    sv.printException(er);
                }
            }
        });
    }

    public static void setupSoundListener() {
        final SuperVanish sv = plugin;
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)plugin, ListenerPriority.HIGH, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT}){

            public void onPacketSending(PacketEvent e) {
                block8: {
                    try {
                        Block b;
                        Object loc;
                        Player listener;
                        block9: {
                            if (e.getPacketType() != PacketType.Play.Server.NAMED_SOUND_EFFECT) break block8;
                            listener = e.getPlayer();
                            if (!((String)e.getPacket().getStrings().read(0)).equalsIgnoreCase("random.chestopen") && !((String)e.getPacket().getStrings().read(0)).equalsIgnoreCase("random.chestclosed")) {
                                return;
                            }
                            loc = new Location(listener.getWorld(), (double)((Integer)e.getPacket().getIntegers().read(0) / 8), (double)((Integer)e.getPacket().getIntegers().read(1) / 8), (double)((Integer)e.getPacket().getIntegers().read(2) / 8));
                            b = listener.getWorld().getBlockAt(loc);
                            if (!(b.getState() instanceof Chest)) {
                                List adjacentBlockLocations = SilentChestListeners.getAdjacentBlockLocations(loc);
                                for (Object otherLocation : adjacentBlockLocations) {
                                    Block otherBlock = listener.getWorld().getBlockAt((Location)otherLocation);
                                    if (!(otherBlock.getState() instanceof Chest)) continue;
                                    b = otherBlock;
                                    loc = otherLocation;
                                    break block9;
                                }
                                return;
                            }
                        }
                        if (((String)e.getPacket().getStrings().read(0)).equalsIgnoreCase("random.chestclosed")) {
                            for (Player p : listener.getWorld().getPlayers()) {
                                if (!VanishAPI.isInvisible(p) || !(p.getLocation().distanceSquared(loc) < 8.5)) continue;
                                e.setCancelled(true);
                            }
                            return;
                        }
                        Chest chest = (Chest)b.getState();
                        Inventory inv = chest.getBlockInventory();
                        List humanViewers = inv.getViewers();
                        for (HumanEntity entity : humanViewers) {
                            if (!(entity instanceof Player) || !VanishAPI.isInvisible((Player)entity)) continue;
                            e.setCancelled(true);
                        }
                    }
                    catch (Exception er) {
                        sv.printException(er);
                    }
                }
            }
        });
    }

    private static Location addToLocation(Location l, int x, int z) {
        return new Location(l.getWorld(), l.getX() + (double)x, l.getY(), l.getZ() + (double)z);
    }

    private static List<Location> getAdjacentBlockLocations(Location loc) {
        ArrayList<Location> adjacentBlockLocations = new ArrayList<Location>();
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, 1, 0));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, -1, 0));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, 0, -1));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, 0, 1));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, 1, 1));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, -1, -1));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, 1, -1));
        adjacentBlockLocations.add(SilentChestListeners.addToLocation(loc, -1, 1));
        return adjacentBlockLocations;
    }
}

