/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hider;

import de.myzelyam.supervanish.SVUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TabManager
extends SVUtils {
    private boolean enabled = cfg.getBoolean("Configuration.Tablist.ChangeTabNames");
    private static TabManager instance;

    public static TabManager getInstance() {
        if (instance == null) {
            instance = new TabManager();
        }
        return instance;
    }

    private TabManager() {
    }

    public void adjustTabname(Player p, SVTabAction action) {
        if (action == SVTabAction.RESTORE_NORMAL_TABNAME) {
            this.restoreNormalTabname(p);
        } else {
            this.setCustomTabname(p);
        }
    }

    private void restoreNormalTabname(Player p) {
        String ntn = TabData.loadData(p);
        if (ntn == null) {
            return;
        }
        p.setPlayerListName(this.convertString(ntn, (CommandSender)p));
    }

    private void setCustomTabname(Player p) {
        if (!this.enabled) {
            return;
        }
        String tn = this.getMsg("TabName");
        if (tn != null) {
            TabData.storeData(p);
            StringBuffer sb = new StringBuffer(this.convertString(tn, (CommandSender)p));
            if (this.convertString(tn, (CommandSender)p).length() > 16) {
                sb.setLength(16);
            } else {
                sb.setLength(this.convertString(tn, (CommandSender)p).length());
            }
            p.setPlayerListName(sb.toString());
        }
    }

    public static enum SVTabAction {
        RESTORE_NORMAL_TABNAME,
        SET_CUSTOM_TABNAME;

    }

    private static class TabData
    extends SVUtils {
        private TabData() {
        }

        private static void storeData(Player p) {
            pd.set("PlayerData." + p.getUniqueId().toString() + ".normalTabName", (Object)p.getPlayerListName());
            plugin.spd();
        }

        private static String loadData(Player p) {
            return pd.getString("PlayerData." + p.getUniqueId().toString() + ".normalTabName");
        }
    }
}

