/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hider;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.config.MessagesCfg;
import de.myzelyam.supervanish.hider.ActionBarManager;
import de.myzelyam.supervanish.hider.PlayerHider;
import de.myzelyam.supervanish.hider.TabManager;
import de.myzelyam.supervanish.hooks.DynmapHook;
import de.myzelyam.supervanish.hooks.EssentialsHook;
import java.util.List;
import me.MyzelYam.SuperVanish.api.PlayerHideEvent;
import me.MyzelYam.SuperVanish.api.PlayerShowEvent;
import me.confuser.barapi.BarAPI;
import me.libraryaddict.disguise.DisguiseAPI;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import pgDev.bukkit.DisguiseCraft.DisguiseCraft;
import pgDev.bukkit.DisguiseCraft.api.DisguiseCraftAPI;

public class VisibilityAdjuster
extends PlayerHider {
    private static VisibilityAdjuster instance;

    public static VisibilityAdjuster getInstance() {
        if (instance == null) {
            return new VisibilityAdjuster();
        }
        return instance;
    }

    @Override
    public void hidePlayer(Player p) {
        try {
            DisguiseCraftAPI dcAPI;
            if (p == null) {
                throw new NullPointerException("The player cannot be null!");
            }
            MessagesCfg mcfg = new MessagesCfg();
            FileConfiguration messages = mcfg.getConfig();
            String bossbar = messages.getString("Messages.BossBarVanishMessage");
            String vanishMessage = messages.getString("Messages.VanishMessage");
            String vanishMessageWithPermission = messages.getString("Messages.VanishMessageWithPermission");
            String onVanishMessage = messages.getString("Messages.OnVanish");
            if (this.getInvisiblePlayers().contains(p.getUniqueId().toString())) {
                System.err.println("[SuperVanish] Error: Could not hide player " + p.getName() + ", he is already invisible!");
                return;
            }
            PlayerHideEvent e = new PlayerHideEvent(p);
            de.myzelyam.api.vanish.PlayerHideEvent e2 = new de.myzelyam.api.vanish.PlayerHideEvent(p);
            plugin.getServer().getPluginManager().callEvent((Event)e);
            plugin.getServer().getPluginManager().callEvent((Event)e2);
            if (e.isCancelled() || e2.isCancelled()) {
                return;
            }
            if (plugin.getServer().getPluginManager().getPlugin("DisguiseCraft") != null && cfg.getBoolean("Configuration.Hooks.EnableDisguiseCraftHook") && (dcAPI = DisguiseCraft.getAPI()).isDisguised(p)) {
                p.sendMessage("\u00a7c[SV] Please undisguise yourself.");
                return;
            }
            if (plugin.getServer().getPluginManager().getPlugin("LibsDisguises") != null && cfg.getBoolean("Configuration.Hooks.EnableLibsDisguisesHook") && DisguiseAPI.isDisguised((Entity)p)) {
                p.sendMessage("\u00a7c[SV] Please undisguise yourself.");
                return;
            }
            if (plugin.getServer().getPluginManager().getPlugin("BarAPI") != null && cfg.getBoolean("Configuration.Messages.UseBarAPI")) {
                BarAPI.setMessage((Player)p, (String)plugin.convertString(bossbar, p), (float)100.0f);
            }
            if (plugin.getServer().getPluginManager().getPlugin("Essentials") != null && cfg.getBoolean("Configuration.Hooks.EnableEssentialsHook")) {
                EssentialsHook.hidePlayer(p);
            }
            if (cfg.getBoolean("Configuration.Players.Fly.Enable")) {
                p.setAllowFlight(true);
            }
            if (plugin.getServer().getPluginManager().getPlugin("dynmap") != null && cfg.getBoolean("Configuration.Hooks.EnableDynmapHook")) {
                DynmapHook.adjustVisibility(p, true);
            }
            if (plugin.getServer().getPluginManager().getPlugin("ProtocolLib") != null && cfg.getBoolean("Configuration.Messages.DisplayActionBarsToInvisiblePlayers") && !SuperVanish.SERVER_IS_ONE_DOT_SEVEN) {
                ActionBarManager.getInstance(plugin).addActionBar(p);
            }
            if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.BroadcastMessageOnVanish")) {
                String msg1 = vanishMessage;
                String msg2 = vanishMessageWithPermission;
                for (Player ap : Bukkit.getOnlinePlayers()) {
                    if (!ap.hasPermission("sv.see") || !cfg.getBoolean("Configuration.Players.EnableSeePermission")) {
                        if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendMessageOnlyToAdmins")) continue;
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendMessageOnlyToUsers")) continue;
                    if (!cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendDifferentMessages")) {
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    if (ap.getUniqueId().toString().equals(p.getUniqueId().toString())) {
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    ap.sendMessage(plugin.convertString(msg2, p));
                }
            }
            if (cfg.getBoolean("Configuration.Tablist.ChangeTabNames")) {
                TabManager.getInstance().adjustTabname(p, TabManager.SVTabAction.SET_CUSTOM_TABNAME);
            }
            p.sendMessage(this.convertString(onVanishMessage, (CommandSender)p));
            List<String> vpl = this.getInvisiblePlayers();
            vpl.add(p.getUniqueId().toString());
            VisibilityAdjuster.plugin.pd.set("InvisiblePlayers", vpl);
            plugin.spd();
            if (cfg.getBoolean("Configuration.Players.EnableGhostPlayers") && VisibilityAdjuster.plugin.ghostTeam != null) {
                if (!VisibilityAdjuster.plugin.ghostTeam.hasPlayer((OfflinePlayer)p) && (p.hasPermission("sv.see") || p.hasPermission("sv.use") || this.getInvisiblePlayers().contains(p.getUniqueId().toString()))) {
                    VisibilityAdjuster.plugin.ghostTeam.addPlayer((OfflinePlayer)p);
                }
                p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
            }
            if (cfg.getBoolean("Configuration.Players.AddNightVision")) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 1));
            }
            this.hideToAll(p);
        }
        catch (Exception e) {
            plugin.printException(e);
        }
    }

    @Override
    public void showPlayer(Player p) {
        this.showPlayer(p, false);
    }

    @Override
    public void showPlayer(Player p, boolean hideJoinMsg) {
        try {
            if (p == null) {
                throw new NullPointerException("The player cannot be null!");
            }
            final Player fp = p;
            MessagesCfg mcfg = new MessagesCfg();
            FileConfiguration messages = mcfg.getConfig();
            String bossbar = messages.getString("Messages.BossBarReappearMessage");
            String reappearMessage = messages.getString("Messages.ReappearMessage");
            String reappearMessageWithPermission = messages.getString("Messages.ReappearMessageWithPermission");
            String onReappearMessage = messages.getString("Messages.OnReappear");
            if (!this.getInvisiblePlayers().contains(p.getUniqueId().toString())) {
                System.err.println("[SuperVanish] Error: Could not show player " + p.getName() + ", he is already visible!");
                return;
            }
            PlayerShowEvent e = new PlayerShowEvent(p);
            de.myzelyam.api.vanish.PlayerShowEvent e2 = new de.myzelyam.api.vanish.PlayerShowEvent(p);
            plugin.getServer().getPluginManager().callEvent((Event)e);
            plugin.getServer().getPluginManager().callEvent((Event)e2);
            if (e.isCancelled() || e2.isCancelled()) {
                return;
            }
            if (cfg.getBoolean("Configuration.Players.EnableGhostPlayers") && p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                p.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (plugin.getServer().getPluginManager().getPlugin("BarAPI") != null && cfg.getBoolean("Configuration.Messages.UseBarAPI")) {
                BarAPI.setMessage((Player)p, (String)plugin.convertString(bossbar, p), (float)100.0f);
                BarAPI.removeBar((Player)fp);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        BarAPI.removeBar((Player)fp);
                    }
                }, 20L);
            }
            if (cfg.getBoolean("Configuration.Players.Fly.DisableOnReappear") && !p.hasPermission("sv.fly") && p.getGameMode() != GameMode.CREATIVE && p.getGameMode() != GameMode.SPECTATOR) {
                p.setAllowFlight(false);
            }
            if (plugin.getServer().getPluginManager().getPlugin("Essentials") != null && cfg.getBoolean("Configuration.Hooks.EnableEssentialsHook")) {
                EssentialsHook.showPlayer(p);
            }
            if (plugin.getServer().getPluginManager().getPlugin("dynmap") != null && cfg.getBoolean("Configuration.Hooks.EnableDynmapHook")) {
                DynmapHook.adjustVisibility(p, false);
            }
            if (plugin.getServer().getPluginManager().getPlugin("ProtocolLib") != null && cfg.getBoolean("Configuration.Messages.DisplayActionBarsToInvisiblePlayers") && !SuperVanish.SERVER_IS_ONE_DOT_SEVEN) {
                ActionBarManager.getInstance(plugin).removeActionBar(p);
            }
            if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.BroadcastMessageOnReappear") && !hideJoinMsg) {
                String msg1 = reappearMessage;
                String msg2 = reappearMessageWithPermission;
                for (Player ap : Bukkit.getOnlinePlayers()) {
                    if (!ap.hasPermission("sv.see") || !cfg.getBoolean("Configuration.Players.EnableSeePermission")) {
                        if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendMessageOnlyToAdmins")) continue;
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    if (cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendMessageOnlyToUsers")) continue;
                    if (!cfg.getBoolean("Configuration.Messages.VanishReappearMessages.SendDifferentMessages")) {
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    if (ap.getUniqueId().toString().equals(p.getUniqueId().toString())) {
                        ap.sendMessage(plugin.convertString(msg1, p));
                        continue;
                    }
                    ap.sendMessage(plugin.convertString(msg2, p));
                }
            }
            if (cfg.getBoolean("Configuration.Tablist.ChangeTabNames")) {
                TabManager.getInstance().adjustTabname(p, TabManager.SVTabAction.RESTORE_NORMAL_TABNAME);
            }
            p.sendMessage(plugin.convertString(onReappearMessage, p));
            List<String> vpl = this.getInvisiblePlayers();
            vpl.remove(p.getUniqueId().toString());
            VisibilityAdjuster.plugin.pd.set("InvisiblePlayers", vpl);
            plugin.spd();
            if (cfg.getBoolean("Configuration.Players.AddNightVision")) {
                p.removePotionEffect(PotionEffectType.NIGHT_VISION);
            }
            this.showToAll(p);
        }
        catch (Exception e) {
            plugin.printException(e);
        }
    }
}

