/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.hooks.BungeeCordHook;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class PlaceholderAPI
implements Listener {
    private PlaceholderAPIPlugin plugin;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([a-zA-Z0-9_.-@-]+)[%]");
    private static final Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([a-zA-Z0-9_.-@-]+)[}]");
    private static Map<String, PlaceholderHook> placeholders = new HashMap<String, PlaceholderHook>();
    private static Set<String> externalHooks = new HashSet<String>();

    public PlaceholderAPI(PlaceholderAPIPlugin i) {
        this.plugin = i;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)i);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPluginUnload(PluginDisableEvent e) {
        String n = e.getPlugin().getName();
        if (n != null && !n.equals(this.plugin.getName()) && PlaceholderAPI.unregisterPlaceholderHook(n)) {
            this.plugin.getLogger().info("Unregistered placeholder hook to: " + n);
        }
    }

    protected void resetInternalPlaceholderHooks() {
        Set<String> registered = PlaceholderAPI.getRegisteredPlaceholderPlugins();
        Set<String> external = PlaceholderAPI.getExternalPlaceholderPlugins();
        for (String pl : registered) {
            int id;
            if (pl.equalsIgnoreCase("bungeecord") && (id = BungeeCordHook.getTaskId()) > 0) {
                Bukkit.getScheduler().cancelTask(id);
            }
            if (external.contains(pl)) continue;
            PlaceholderAPI.unregisterPlaceholderHook(pl);
        }
        this.plugin.initializeHooks();
    }

    protected void unregisterAll() {
        placeholders = null;
        externalHooks = null;
    }

    public static boolean registerPlaceholderHook(Plugin plugin, PlaceholderHook placeholderHook) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderAPI.registerPlaceholderHook(plugin.getName(), placeholderHook, false);
    }

    public static boolean registerPlaceholderHook(String plugin, PlaceholderHook placeholderHook) {
        return PlaceholderAPI.registerPlaceholderHook(plugin, placeholderHook, false);
    }

    public static boolean registerPlaceholderHook(Plugin plugin, PlaceholderHook placeholderHook, boolean isInternalHook) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderAPI.registerPlaceholderHook(plugin.getName(), placeholderHook, isInternalHook);
    }

    public static boolean registerPlaceholderHook(String plugin, PlaceholderHook placeholderHook, boolean isInternalHook) {
        if (placeholders == null) {
            placeholders = new HashMap<String, PlaceholderHook>();
        }
        if (plugin == null || placeholderHook == null || placeholders.containsKey(plugin)) {
            return false;
        }
        placeholders.put(plugin, placeholderHook);
        if (!isInternalHook) {
            if (externalHooks == null) {
                externalHooks = new HashSet<String>();
            }
            if (!externalHooks.contains(plugin)) {
                externalHooks.add(plugin);
            }
        }
        return true;
    }

    public static boolean unregisterPlaceholderHook(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderAPI.unregisterPlaceholderHook(plugin.getName());
    }

    public static boolean unregisterPlaceholderHook(String plugin) {
        if (plugin == null) {
            return false;
        }
        if (placeholders == null || placeholders.isEmpty()) {
            return false;
        }
        if (externalHooks != null && externalHooks.contains(plugin)) {
            externalHooks.remove(plugin);
        }
        return placeholders.remove(plugin) != null;
    }

    public static Set<String> getRegisteredPlaceholderPlugins() {
        if (placeholders == null || placeholders.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(placeholders.keySet());
    }

    public static Set<String> getExternalPlaceholderPlugins() {
        if (externalHooks == null || externalHooks.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(externalHooks);
    }

    public static Map<String, PlaceholderHook> getPlaceholders() {
        return new HashMap<String, PlaceholderHook>(placeholders);
    }

    public static boolean containsServerPlaceholders(String text) {
        if (text == null || placeholders == null || placeholders.isEmpty()) {
            return false;
        }
        Matcher placeholderMatcher = PLACEHOLDER_PATTERN.matcher(text);
        boolean containsServer = false;
        while (placeholderMatcher.find()) {
            String format = placeholderMatcher.group(1);
            StringBuilder pluginBuilder = new StringBuilder();
            char[] formatArray = format.toCharArray();
            int i = 0;
            while (i < formatArray.length) {
                if (formatArray[i] == '_') break;
                pluginBuilder.append(formatArray[i]);
                ++i;
            }
            String pl = pluginBuilder.toString();
            containsServer = pl.equalsIgnoreCase("server");
            if (containsServer) break;
        }
        return containsServer;
    }

    public static boolean containsPlaceholders(String text) {
        if (text == null || placeholders == null || placeholders.isEmpty()) {
            return false;
        }
        Matcher placeholderMatcher = PLACEHOLDER_PATTERN.matcher(text);
        while (placeholderMatcher.find()) {
            String format = placeholderMatcher.group(1);
            StringBuilder pluginBuilder = new StringBuilder();
            char[] formatArray = format.toCharArray();
            int i = 0;
            while (i < formatArray.length) {
                if (formatArray[i] == '_') break;
                pluginBuilder.append(formatArray[i]);
                ++i;
            }
            String pl = pluginBuilder.toString();
            StringBuilder identifierBuilder = new StringBuilder();
            int b = i + 1;
            while (b < formatArray.length) {
                identifierBuilder.append(formatArray[b]);
                ++b;
            }
            String identifier = identifierBuilder.toString();
            if (identifier.isEmpty()) {
                identifier = pl;
            }
            for (String registered : PlaceholderAPI.getRegisteredPlaceholderPlugins()) {
                if (!pl.equalsIgnoreCase(registered)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> setBracketPlaceholders(Player p, List<String> text) {
        if (text == null) {
            return text;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (String line : text) {
            temp.add(PlaceholderAPI.setBracketPlaceholders(p, line));
        }
        return temp;
    }

    public static String setBracketPlaceholders(Player player, String text) {
        if (text == null || placeholders == null || placeholders.isEmpty()) {
            return text;
        }
        Matcher placeholderMatcher = BRACKET_PLACEHOLDER_PATTERN.matcher(text);
        while (placeholderMatcher.find()) {
            String format = placeholderMatcher.group(1);
            StringBuilder pluginBuilder = new StringBuilder();
            char[] formatArray = format.toCharArray();
            int i = 0;
            while (i < formatArray.length) {
                if (formatArray[i] == '_') break;
                pluginBuilder.append(formatArray[i]);
                ++i;
            }
            String pl = pluginBuilder.toString();
            StringBuilder identifierBuilder = new StringBuilder();
            int b = i + 1;
            while (b < formatArray.length) {
                identifierBuilder.append(formatArray[b]);
                ++b;
            }
            String identifier = identifierBuilder.toString();
            if (identifier.isEmpty()) {
                identifier = pl;
            }
            for (String registered : PlaceholderAPI.getRegisteredPlaceholderPlugins()) {
                String value;
                if (!pl.equalsIgnoreCase(registered) || (value = PlaceholderAPI.getPlaceholders().get(registered).onPlaceholderRequest(player, identifier)) == null) continue;
                text = text.replaceAll("\\{" + format + "\\}", Matcher.quoteReplacement(value));
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static List<String> setPlaceholders(Player p, List<String> text) {
        if (text == null) {
            return text;
        }
        ArrayList<String> temp = new ArrayList<String>();
        for (String line : text) {
            temp.add(PlaceholderAPI.setPlaceholders(p, line));
        }
        return temp;
    }

    public static String setPlaceholders(Player player, String text) {
        if (text == null || placeholders == null || placeholders.isEmpty()) {
            return text;
        }
        Matcher placeholderMatcher = PLACEHOLDER_PATTERN.matcher(text);
        while (placeholderMatcher.find()) {
            String format = placeholderMatcher.group(1);
            StringBuilder pluginBuilder = new StringBuilder();
            char[] formatArray = format.toCharArray();
            int i = 0;
            while (i < formatArray.length) {
                if (formatArray[i] == '_') break;
                pluginBuilder.append(formatArray[i]);
                ++i;
            }
            String pl = pluginBuilder.toString();
            StringBuilder identifierBuilder = new StringBuilder();
            int b = i + 1;
            while (b < formatArray.length) {
                identifierBuilder.append(formatArray[b]);
                ++b;
            }
            String identifier = identifierBuilder.toString();
            if (identifier.isEmpty()) {
                identifier = pl;
            }
            for (String registered : PlaceholderAPI.getRegisteredPlaceholderPlugins()) {
                String value;
                if (!pl.equalsIgnoreCase(registered) || (value = PlaceholderAPI.getPlaceholders().get(registered).onPlaceholderRequest(player, identifier)) == null) continue;
                text = text.replaceAll("%" + format + "%", Matcher.quoteReplacement(value));
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static Pattern getPlaceholderPattern() {
        return PLACEHOLDER_PATTERN;
    }

    public static Pattern getBracketPlaceholderPattern() {
        return BRACKET_PLACEHOLDER_PATTERN;
    }
}

