/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlaceholderAPICommands
implements CommandExecutor {
    private PlaceholderAPIPlugin plugin;

    public PlaceholderAPICommands(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    private void sms(CommandSender s, String msg) {
        s.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }

    public boolean onCommand(CommandSender s, Command c, String label, String[] args) {
        Player p;
        if (args.length == 0) {
            this.sms(s, "&8&m-----------------------------------------------------");
            this.sms(s, "&cClips &fPlaceholder&7API &f&o" + this.plugin.getDescription().getVersion());
            this.sms(s, "&7Created by &fextended_clip");
            this.sms(s, "&8&m-----------------------------------------------------");
            return true;
        }
        if (s instanceof Player && !(p = (Player)s).hasPermission("placeholderapi.admin")) {
            this.sms(s, "&cYou don't have permission to do that!");
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.sms(s, "&8&m-----------------------------------------------------");
            this.sms(s, "&cClips &fPlaceholder&7API &eHelp");
            this.sms(s, "&c/placeholderapi");
            this.sms(s, "&fView plugin info/version info");
            this.sms(s, "&c/placeholderapi list");
            this.sms(s, "&fList all placeholder hook plugins that are currently active");
            this.sms(s, "&c/placeholderapi reload");
            this.sms(s, "&fReload the config settings");
            this.sms(s, "&8&m-----------------------------------------------------");
        } else if (args[0].equalsIgnoreCase("reload")) {
            this.sms(s, "&8&m-----------------------------------------------------");
            this.sms(s, "&cClips &fPlaceholder&7API &bconfiguration reloaded!");
            this.plugin.reloadConf(s);
            this.sms(s, "&8&m-----------------------------------------------------");
        } else if (args[0].equalsIgnoreCase("list")) {
            this.sms(s, "&8&m-----------------------------------------------------");
            Set<String> registered = PlaceholderAPI.getRegisteredPlaceholderPlugins();
            if (registered == null || registered.isEmpty()) {
                this.sms(s, "&7There are no placeholder hooks currently registered!");
                this.sms(s, "&8&m-----------------------------------------------------");
                return true;
            }
            this.sms(s, String.valueOf(registered.size()) + " &7Placeholder hooks registered:");
            this.sms(s, registered.toString());
            this.sms(s, "&8&m-----------------------------------------------------");
        } else {
            this.sms(s, "&8&m-----------------------------------------------------");
            this.sms(s, "&cIncorrect usage! &7/placeholderhook help");
            this.sms(s, "&8&m-----------------------------------------------------");
        }
        return true;
    }
}

