/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.javascript.JavascriptPlaceholder;
import me.clip.placeholderapi.javascript.JavascriptReturnType;
import me.clip.placeholderapi.placeholders.JavascriptPlaceholders;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JavascriptPlaceholdersConfig {
    private PlaceholderAPIPlugin plugin;
    private FileConfiguration config = null;
    private File file = null;

    public JavascriptPlaceholdersConfig(PlaceholderAPIPlugin i) {
        this.plugin = i;
        this.reload();
    }

    public void reload() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), "javascript_placeholders.yml");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.config.options().header("javascript_placeholders.yml\nYou can create custom placeholders which utilize javascript to determine the result of the custom placeholder you create.\nYou can specify if the result is based on a boolean or the actual javascript.\n\nIf you do not specify a type: the placeholder will default to a boolean type\nA boolean type must contain a true_result: and false_result:\n\nA string type only requires the expression: entry\n\nJavascript placeholders can contain normal placeholders in the expression, true_result, or false_result\nThese placeholders will be parsed to the correct values before the expression is evaluated.\n\nYour javascript placeholders will be identified by: %javascript_<identifier>%\n\nJavascript placeholder format:\n\n    BOOLEAN TYPE\n<identifier>:\n  expression: <expression>\n  type: 'boolean'\n  true_result: <result if expression is true>\n  false_result: <result if expression is false>\n\n    STRING TYPE\n<identifier>:\n  expression: <expression>\n  type: 'string'\n\n\n ==== ADVANCED VARIABLES ====\nDO NOT USE THESE VARIABLES UNLESS YOU KNOW WHAT YOU ARE DOING!\n\nYou can access a few Bukkit API classes and methods using certain keywords:\n\nUsing \"BukkitServer\" in your javascript will return Bukkit.getServer()\nYou can use any methods inside of the Server class:\n\nExample: BukkitServer.getBannedPlayers().size().toFixed()\nWill return how many players are banned\n\nThis variable is handy if you want to iterate through all online players.'\n\nUsing \"BukkitPlayer\" in your javascript will return the Player object you are setting placeholders for.\nYou can use any methods inside of the Player class:\n\nExample: BukkitPlayer.hasPermission(\"some.permission\")\nWill return if the player has a specific permission\nThis variable is handy if you want to check a players permission node, or access other methods inside of\nthe player class for the specified player.\n\nMore advanced variables are coming soon! Only use these variables if you know what you are doing!\n\n ==================\n\n\nJavascript placeholder examples:\n\nmillionaire:\n  expression: '%vaulteco_balance% >= 1000000'\n  type: 'boolean'\n  true_result: '&aMillionaire'\n  false_result: '&cbroke'\nis_staff:\n  expression: '\"%vault_group%\" == \"Moderator\" || \"%vault_group%\" == \"Admin\" || \"%vault_group%\" == \"Owner\"'\n  type: 'boolean'\n  true_result: '&bStaff'\n  false_result: '&ePlayer'\nhealth_rounded:\n  expression: 'Math.round(%player_health%)'\n  type: 'string'\nstaff_online:\n  expression: 'var i = 0; for (var p in BukkitServer.getOnlinePlayers()) { if (BukkitServer.getOnlinePlayers()[p].hasPermission(\"staff.online\")) {i = i+1;};} i.toFixed();'\n  type: 'string'\n\n\nYou can optionally specify a file that the javascript expression will be loaded from if your expression\nis bigger than 1 line. To specify javascript be loaded from a file, follow this format:\n\nis_op:\n  expression: 'file: is_op.js'\n  type: 'string'\n\nThe following placeholder will attempt to load javascript from the /plugins/PlaceholderAPI/javascripts/is_op.js file\nif the folder/file exists. If the folder/file does not exist it will be created.\nYou must specify the file extension with the file name. Any file extension is accepted.\n");
        if (this.config.getKeys(false) == null || this.config.getKeys(false).isEmpty()) {
            this.config.set("millionaire.expression", (Object)"%vaulteco_balance% >= 1000000");
            this.config.set("millionaire.type", (Object)"boolean");
            this.config.set("millionaire.true_result", (Object)"&aMillionaire");
            this.config.set("millionaire.false_result", (Object)"&cbroke");
            this.config.set("is_staff.expression", (Object)"\"%vault_group%\" == \"Moderator\" || \"%vault_group%\" == \"Admin\" || \"%vault_group%\" == \"Owner\"");
            this.config.set("is_staff.type", (Object)"boolean");
            this.config.set("is_staff.true_result", (Object)"&bStaff");
            this.config.set("is_staff.false_result", (Object)"&ePlayer");
            this.config.set("health_rounded.expression", (Object)"Math.round(%player_health%)");
            this.config.set("health_rounded.type", (Object)"string");
            this.config.set("staff_online", (Object)"var i = 0; for (var p in BukkitServer.getOnlinePlayers()) { if (BukkitServer.getOnlinePlayers()[p].hasPermission(\"staff.online\")) {i = i+1;};} i.toFixed();");
            this.config.set("staff_online.type", (Object)"string");
        }
        this.save();
    }

    public FileConfiguration load() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void save() {
        if (this.config == null || this.file == null) {
            return;
        }
        try {
            this.load().save(this.file);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save to " + this.file, ex);
        }
    }

    public int loadPlaceholders() {
        if (this.config.getKeys(false) == null || this.config.getKeys(false).isEmpty()) {
            return 0;
        }
        File dir = new File(this.plugin.getDataFolder() + File.separator + "javascripts");
        try {
            if (!dir.exists()) {
                dir.mkdirs();
                this.plugin.getLogger().info("Creating directory: plugins" + File.separator + "PlaceholderAPI" + File.separator + "javascripts");
            }
        }
        catch (SecurityException e) {
            this.plugin.getLogger().severe("Could not create directory: plugins" + File.separator + "PlaceholderAPI" + File.separator + "javascripts");
        }
        JavascriptPlaceholders.cleanup();
        for (String identifier : this.config.getKeys(false)) {
            String t;
            JavascriptReturnType type = JavascriptReturnType.BOOLEAN;
            if (this.config.contains(String.valueOf(identifier) + ".type") && JavascriptReturnType.getType(t = this.config.getString(String.valueOf(identifier) + ".type")) != null) {
                type = JavascriptReturnType.getType(t);
            }
            if (!this.isValid(identifier, type)) {
                this.plugin.getLogger().warning("Javascript " + type.getType() + " placeholder " + identifier + " is invalid!");
                continue;
            }
            JavascriptPlaceholder pl = null;
            String expression = this.config.getString(String.valueOf(identifier) + ".expression");
            if (expression.startsWith("file: ")) {
                expression = expression.replace("file: ", "");
                File f = new File(this.plugin.getDataFolder() + File.separator + "javascripts", expression);
                expression = this.loadFileExpression(f);
                if (expression == null || expression.isEmpty()) {
                    this.plugin.getLogger().info("javascript expression from file: " + f.getName() + " is empty!");
                    continue;
                }
                this.plugin.getLogger().info("javascript expression loaded from file: " + f.getName());
            }
            if (type == JavascriptReturnType.BOOLEAN) {
                String trueResult = this.config.getString(String.valueOf(identifier) + ".true_result");
                String falseResult = this.config.getString(String.valueOf(identifier) + ".false_result");
                pl = new JavascriptPlaceholder(identifier, type, expression, trueResult, falseResult);
            } else {
                pl = new JavascriptPlaceholder(identifier, type, expression, null, null);
            }
            boolean added = JavascriptPlaceholders.addJavascriptPlaceholder(pl);
            if (added) {
                this.plugin.getLogger().info("Javascript " + type.getType() + " placeholder %javascript_" + identifier + "% has been loaded!");
                continue;
            }
            this.plugin.getLogger().warning("Javascript " + type.getType() + " placeholder %javascript_" + identifier + "% is a duplicate!");
        }
        return JavascriptPlaceholders.getJavascriptPlaceholdersAmount();
    }

    private String loadFileExpression(File f) {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            if (f.exists()) break block6;
            this.plugin.getLogger().warning(String.valueOf(f.getName()) + " does not exist!");
            try {
                f.createNewFile();
                this.plugin.getLogger().info(String.valueOf(f.getName()) + " created! Add your javascript expression to this file and use /placeholderapi reload to load it!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        try {
            Scanner scanner = new Scanner(f);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.isEmpty()) continue;
                sb.append(String.valueOf(line) + " ");
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return sb.toString();
    }

    private boolean isValid(String identifier, JavascriptReturnType type) {
        if (type == JavascriptReturnType.BOOLEAN) {
            return this.config.isString(String.valueOf(identifier) + ".expression") && this.config.isString(String.valueOf(identifier) + ".true_result") && this.config.isString(String.valueOf(identifier) + ".false_result");
        }
        return this.config.isString(String.valueOf(identifier) + ".expression");
    }
}

