/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.armar.plugins.autorank.Autorank;
import me.armar.plugins.autorank.api.API;
import me.armar.plugins.autorank.util.AutorankTools;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoRankHook {
    private PlaceholderAPIPlugin plugin;
    private API autorank;

    public AutoRankHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        Autorank ar;
        if (Bukkit.getPluginManager().isPluginEnabled("Autorank") && (ar = (Autorank)Bukkit.getPluginManager().getPlugin("Autorank")) != null) {
            this.autorank = ar.getAPI();
            if (this.autorank == null) {
                return;
            }
            boolean hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)ar, new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (p == null) {
                        return "";
                    }
                    switch (identifier) {
                        case "current_rank": {
                            return AutoRankHook.this.autorank.getPrimaryGroup(p) != null ? AutoRankHook.this.autorank.getPrimaryGroup(p) : "";
                        }
                        case "time_of_player": {
                            return String.valueOf(AutoRankHook.this.autorank.getTimeOfPlayer(p));
                        }
                        case "local_time": {
                            String localTime = AutorankTools.timeToString((int)AutoRankHook.this.autorank.getLocalPlayTime(p.getUniqueId()), (AutorankTools.Time)AutorankTools.Time.MINUTES);
                            return localTime != null ? localTime : "";
                        }
                        case "global_time": {
                            String globalTime = AutorankTools.timeToString((int)AutoRankHook.this.autorank.getGlobalPlayTime(p.getUniqueId()), (AutorankTools.Time)AutorankTools.Time.MINUTES);
                            return globalTime != null ? globalTime : "";
                        }
                    }
                    return null;
                }
            }, true);
            if (hooked) {
                this.plugin.log.info("Hooked into Autorank for placeholders!");
            }
        }
    }
}

