/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.autosell.AutoSell;
import me.clip.autosell.SellHandler;
import me.clip.autosell.multipliers.Multipliers;
import me.clip.autosell.objects.Multiplier;
import me.clip.autosell.objects.PermissionMultiplier;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoSellHook {
    private PlaceholderAPIPlugin plugin;

    public AutoSellHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        AutoSell as;
        if (Bukkit.getPluginManager().isPluginEnabled("AutoSell") && (as = AutoSell.getInstance()) != null && (hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)as, new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "in_autosell_mode": {
                        return AutoSellHook.this.inSell(p);
                    }
                    case "in_autoblocks_mode": {
                        return AutoSellHook.this.inBlocks(p);
                    }
                    case "in_automelt_mode": {
                        return AutoSellHook.this.inSmelt(p);
                    }
                    case "current_shop": {
                        return AutoSellHook.this.getCurrentShop(p);
                    }
                    case "total_multiplier": {
                        return AutoSellHook.this.getTotalMulti(p);
                    }
                    case "time_multiplier_minsleft": {
                        return AutoSellHook.this.getTimeMultiMins(p);
                    }
                    case "time_multiplier_timeleft": {
                        return AutoSellHook.this.getTimeMultiTime(p);
                    }
                    case "time_multiplier": {
                        return AutoSellHook.this.getTimeMulti(p);
                    }
                    case "perm_multiplier_name": {
                        return AutoSellHook.this.getPermMultiName(p);
                    }
                    case "perm_multiplier": {
                        return AutoSellHook.this.getPermMulti(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into AutoSell for placeholders!");
        }
    }

    private String getPermMulti(Player p) {
        PermissionMultiplier m = Multipliers.getPermissionMultiplier((Player)p);
        if (m == null) {
            return "0.0";
        }
        return String.valueOf(m.getMultiplier());
    }

    private String getPermMultiName(Player p) {
        PermissionMultiplier m = Multipliers.getPermissionMultiplier((Player)p);
        if (m == null) {
            return "";
        }
        return String.valueOf(m.getIdentifier());
    }

    private String getTimeMulti(Player p) {
        Multiplier m = Multipliers.getMultiplier((String)p.getName());
        if (m == null) {
            return "0";
        }
        return String.valueOf(m.getMultiplier());
    }

    private String getTimeMultiTime(Player p) {
        Multiplier m = Multipliers.getMultiplier((String)p.getName());
        if (m == null) {
            return "0";
        }
        return String.valueOf(m.getTimeLeft());
    }

    private String getTimeMultiMins(Player p) {
        Multiplier m = Multipliers.getMultiplier((String)p.getName());
        if (m == null) {
            return "0";
        }
        return String.valueOf(m.getMinutesLeft());
    }

    private String getTotalMulti(Player p) {
        double multi = 0.0;
        if (Multipliers.getGlobalMultiplier() != null) {
            multi = Multipliers.getGlobalMultiplier().getMultiplier();
        }
        if (Multipliers.getPermissionMultiplier((Player)p) != null) {
            multi += Multipliers.getPermissionMultiplier((Player)p).getMultiplier();
        }
        if (Multipliers.getMultiplier((String)p.getName()) != null) {
            multi += Multipliers.getMultiplier((String)p.getName()).getMultiplier();
        }
        return String.valueOf(multi);
    }

    private String getCurrentShop(Player p) {
        if (SellHandler.getShop((Player)p) != null) {
            return SellHandler.getShop((Player)p).getName();
        }
        if (SellHandler.getPermShop((Player)p) != null) {
            return SellHandler.getPermShop((Player)p).getName();
        }
        return "";
    }

    private String inSmelt(Player p) {
        return AutoSell.inSmeltMode((Player)p) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    private String inSell(Player p) {
        return AutoSell.inSellMode((Player)p) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    private String inBlocks(Player p) {
        return AutoSell.inAutoBlockMode((Player)p) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }
}

