/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeCordHook
implements PluginMessageListener {
    private PlaceholderAPIPlugin plugin;
    private final Map<String, Integer> servers = new HashMap<String, Integer>();
    private int total = 0;
    private static int taskId = -1;
    private static boolean registered = false;
    private final String CHANNEL;

    public BungeeCordHook(PlaceholderAPIPlugin i, String channel) {
        int interval;
        this.plugin = i;
        this.CHANNEL = channel;
        if (!registered) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, this.CHANNEL);
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, this.CHANNEL, (PluginMessageListener)this);
            registered = true;
        }
        if ((interval = this.plugin.getConfig().getInt("bungeecord.check_interval")) < 1) {
            interval = 60;
        }
        this.startTask(interval);
        this.hook();
    }

    public void hook() {
        boolean hooked = PlaceholderAPI.registerPlaceholderHook(this.CHANNEL.toLowerCase(), new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (identifier.equalsIgnoreCase("total") || identifier.equalsIgnoreCase("all")) {
                    return String.valueOf(BungeeCordHook.this.total);
                }
                if (BungeeCordHook.this.servers == null || BungeeCordHook.this.servers.isEmpty()) {
                    return "0";
                }
                for (Map.Entry entry : BungeeCordHook.this.servers.entrySet()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase(identifier)) continue;
                    return String.valueOf(entry.getValue());
                }
                return null;
            }
        }, true);
        if (hooked) {
            this.plugin.log.info("Hooked into " + this.CHANNEL + " for placeholders!");
        }
    }

    private void startTask(int interval) {
        taskId = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (BungeeCordHook.this.servers == null || BungeeCordHook.this.servers.isEmpty()) {
                    BungeeCordHook.this.getServers();
                    BungeeCordHook.this.getPlayers("ALL");
                    return;
                }
                for (String server : BungeeCordHook.this.servers.keySet()) {
                    BungeeCordHook.this.getPlayers(server);
                }
                BungeeCordHook.this.getPlayers("ALL");
            }
        }, 100L, 20L * (long)interval).getTaskId();
    }

    public static int getTaskId() {
        return taskId;
    }

    private void getServers() {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("GetServers");
            ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this.plugin, this.CHANNEL, out.toByteArray());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get server names for " + this.CHANNEL + " placeholders!");
        }
    }

    private void getPlayers(String server) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("PlayerCount");
            out.writeUTF(server);
            ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this.plugin, this.CHANNEL, out.toByteArray());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get player count for server " + server + "!");
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(this.CHANNEL)) {
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
        try {
            String subChannel = in.readUTF();
            if (subChannel.equals("PlayerCount")) {
                String server = in.readUTF();
                if (in.available() > 0) {
                    int count = in.readInt();
                    if (server.equals("ALL")) {
                        this.total = count;
                    } else {
                        this.servers.put(server, count);
                    }
                }
            } else if (subChannel.equals("GetServers")) {
                String[] serverList = in.readUTF().split(", ");
                if (serverList == null || serverList.length == 0) {
                    return;
                }
                String[] stringArray = serverList;
                int n = serverList.length;
                int n2 = 0;
                while (n2 < n) {
                    String server = stringArray[n2];
                    this.servers.put(server, 0);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

