/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.ezrankslite.EZRanksLite;
import me.clip.ezrankslite.multipliers.CostHandler;
import me.clip.ezrankslite.rankdata.Rankup;
import me.clip.ezrankslite.util.EcoUtil;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EZRanksLiteHook {
    private PlaceholderAPIPlugin plugin;

    public EZRanksLiteHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        EZRanksLite ezr;
        if (Bukkit.getPluginManager().isPluginEnabled("EZRanksLite") && (ezr = (EZRanksLite)Bukkit.getPluginManager().getPlugin("EZRanksLite")) != null) {
            if (ezr.getDescription().getVersion().startsWith("2.")) {
                boolean hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)ezr, new PlaceholderHook(){

                    @Override
                    public String onPlaceholderRequest(Player p, String identifier) {
                        if (p == null) {
                            return "";
                        }
                        Rankup r = Rankup.getRankup((Player)p);
                        String replacement = null;
                        double cost = 0.0;
                        switch (identifier) {
                            case "player": {
                                replacement = p.getName();
                                break;
                            }
                            case "displayname": {
                                replacement = p.getDisplayName();
                                break;
                            }
                            case "world": {
                                replacement = p.getWorld().getName();
                                break;
                            }
                            case "rank": 
                            case "rankfrom": 
                            case "currentrank": {
                                replacement = r != null && r.getRank() != null ? r.getRank() : (Rankup.isLastRank((Player)p) && Rankup.getLastRank() != null && Rankup.getLastRank().getRank() != null ? Rankup.getLastRank().getRank() : (EZRanksLite.get().getPerms().getPrimaryGroup(p) != null ? EZRanksLite.get().getPerms().getPrimaryGroup(p) : "unknown"));
                                break;
                            }
                            case "rankto": 
                            case "rankup": 
                            case "nextrank": {
                                replacement = r != null && r.getRankup() != null ? r.getRankup() : "none";
                                break;
                            }
                            case "cost": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                long send = (long)cost;
                                replacement = String.valueOf(send);
                                break;
                            }
                            case "cost_formatted": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = EcoUtil.fixMoney((double)cost);
                                break;
                            }
                            case "difference": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = String.valueOf(EcoUtil.getDifference((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p), (double)cost));
                                break;
                            }
                            case "difference_formatted": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = EcoUtil.fixMoney((double)EcoUtil.getDifference((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p), (double)cost));
                                break;
                            }
                            case "progress": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = String.valueOf(EcoUtil.getProgress((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p), (double)cost));
                                break;
                            }
                            case "progressbar": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = EcoUtil.getProgressBar((int)EcoUtil.getProgressInt((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p), (double)cost));
                                break;
                            }
                            case "progressexact": {
                                if (r != null) {
                                    cost = r.getCost();
                                    cost = CostHandler.getMultiplier((Player)p, (double)cost);
                                    cost = CostHandler.getDiscount((Player)p, (double)cost);
                                }
                                replacement = EcoUtil.getProgressExact((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p), (double)cost);
                                break;
                            }
                            case "balance": {
                                replacement = String.valueOf(EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p));
                                break;
                            }
                            case "balance_formatted": {
                                replacement = EcoUtil.fixMoney((double)EZRanksLite.get().getEconomy().getBalance((OfflinePlayer)p));
                                break;
                            }
                            case "rank_prefix": 
                            case "rankprefix": {
                                replacement = r != null && r.getPrefix() != null ? r.getPrefix() : (Rankup.isLastRank((Player)p) && Rankup.getLastRank() != null && Rankup.getLastRank().getPrefix() != null ? Rankup.getLastRank().getPrefix() : "");
                                break;
                            }
                            case "lastrank": 
                            case "last_rank": {
                                replacement = Rankup.getLastRank() != null && Rankup.getLastRank().getRank() != null ? Rankup.getLastRank().getRank() : "";
                                break;
                            }
                            case "lastrank_prefix": 
                            case "lastrankprefix": {
                                replacement = Rankup.getLastRank() != null && Rankup.getLastRank().getPrefix() != null ? Rankup.getLastRank().getPrefix() : "";
                                break;
                            }
                            case "rankup_prefix": 
                            case "rankupprefix": {
                                replacement = r == null ? "" : (Rankup.getRankup((String)r.getRankup()) == null ? (Rankup.getLastRank() != null && Rankup.getLastRank().getPrefix() != null ? Rankup.getLastRank().getPrefix() : "") : (Rankup.getRankup((String)r.getRankup()).getPrefix() != null ? Rankup.getRankup((String)r.getRankup()).getPrefix() : ""));
                            }
                        }
                        return replacement;
                    }
                }, true);
                if (hooked) {
                    this.plugin.log.info("Hooked into EZRanksLite for placeholders!");
                }
            } else {
                this.plugin.log.info("This version of PlaceholderAPI is only compatible with EZRanksLite 2.0 or higher!");
            }
        }
    }
}

