/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.massivecraft.factions.entity.MPlayer;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsHook {
    private PlaceholderAPIPlugin plugin;

    public FactionsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    private boolean isCompatible(String version) {
        String v = version.replace(".", "");
        int i = 0;
        try {
            i = Integer.parseInt(v);
        }
        catch (Exception e) {
            return false;
        }
        return i >= 275;
    }

    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Factions")) {
            Plugin factions = Bukkit.getPluginManager().getPlugin("Factions");
            String version = factions.getDescription().getVersion();
            if (this.isCompatible(version)) {
                boolean hooked = PlaceholderAPI.registerPlaceholderHook(factions, new PlaceholderHook(){

                    @Override
                    public String onPlaceholderRequest(Player p, String identifier) {
                        if (p == null) {
                            return "";
                        }
                        switch (identifier) {
                            case "faction": {
                                return FactionsHook.this.getFaction(p);
                            }
                            case "power": {
                                return FactionsHook.this.getFPower(p);
                            }
                            case "powermax": {
                                return FactionsHook.this.getFPowerMax(p);
                            }
                            case "factionpower": {
                                return FactionsHook.this.getFacPower(p);
                            }
                            case "factionpowermax": {
                                return FactionsHook.this.getFacPowerMax(p);
                            }
                            case "title": {
                                return FactionsHook.this.getFactionTitle(p);
                            }
                            case "role": {
                                return FactionsHook.this.getFactionRole(p);
                            }
                            case "claims": {
                                return FactionsHook.this.getFactionClaims(p);
                            }
                            case "onlinemembers": {
                                return FactionsHook.this.getOnlineFactionMembers(p);
                            }
                            case "allmembers": {
                                return FactionsHook.this.getFactionMembers(p);
                            }
                        }
                        return null;
                    }
                }, true);
                if (hooked) {
                    this.plugin.log.info("Hooked into Factions " + version + " for placeholders!");
                }
            } else {
                this.plugin.log.info("This version of PlaceholderAPI is only compatible with Factions MCore version 2.7.4 or higher!");
            }
        }
    }

    private boolean hasFaction(Player p) {
        if (MPlayer.get((Object)p) == null) {
            return false;
        }
        return MPlayer.get((Object)p).hasFaction();
    }

    private String getFaction(Player p) {
        if (!this.hasFaction(p)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)p).getFactionName());
    }

    private String getFactionTitle(Player p) {
        if (!this.hasFaction(p)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)p).getTitle());
    }

    private String getFactionRole(Player p) {
        if (!this.hasFaction(p)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)p).getRole().getPrefix());
    }

    private String getFactionClaims(Player p) {
        if (!this.hasFaction(p)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)p).getFaction().getLandCount());
    }

    private String getFactionMembers(Player p) {
        if (!this.hasFaction(p)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)p).getFaction().getMPlayers().size());
    }

    private String getOnlineFactionMembers(Player p) {
        if (!this.hasFaction(p)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)p).getFaction().getOnlinePlayers().size());
    }

    private String getFPower(Player p) {
        MPlayer uplayer = MPlayer.get((Object)p);
        if (uplayer == null) {
            return "0";
        }
        return String.valueOf(uplayer.getPowerRounded());
    }

    private String getFPowerMax(Player p) {
        MPlayer uplayer = MPlayer.get((Object)p);
        if (uplayer == null) {
            return "0";
        }
        return String.valueOf(uplayer.getPowerMaxRounded());
    }

    private String getFacPower(Player p) {
        if (!this.hasFaction(p)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)p).getFaction().getPowerRounded());
    }

    private String getFacPowerMax(Player p) {
        if (!this.hasFaction(p)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)p).getFaction().getPowerMaxRounded());
    }
}

