/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.brcdev.gangs.GangsPlugin;
import me.brcdev.gangs.GangsPlusAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GangsPlusHook {
    private PlaceholderAPIPlugin plugin;

    public GangsPlusHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        GangsPlugin gp;
        if (Bukkit.getPluginManager().isPluginEnabled("GangsPlus") && (gp = (GangsPlugin)Bukkit.getPluginManager().getPlugin("GangsPlus")) != null && (hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)gp, new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "in_gang": {
                        return GangsPlusHook.this.inGang(p);
                    }
                    case "gang": {
                        return GangsPlusHook.this.getGang(p);
                    }
                    case "gang_tag": {
                        return GangsPlusHook.this.getGangTag(p);
                    }
                    case "gang_rank": {
                        return GangsPlusHook.this.getGangRank(p);
                    }
                    case "gang_homes": {
                        return GangsPlusHook.this.getGangHomes(p);
                    }
                    case "gang_friendlyfire": {
                        return GangsPlusHook.this.getGangFF(p);
                    }
                    case "gang_online": {
                        return GangsPlusHook.this.getGangOnline(p);
                    }
                    case "gang_size": {
                        return GangsPlusHook.this.getGangSize(p);
                    }
                    case "gang_leader": {
                        return GangsPlusHook.this.getGangLeader(p);
                    }
                    case "gang_level": {
                        return GangsPlusHook.this.getGangLevel(p);
                    }
                    case "gang_wins": {
                        return GangsPlusHook.this.getGangWins(p);
                    }
                    case "gang_losses": {
                        return GangsPlusHook.this.getGangLosses(p);
                    }
                    case "gang_wlr": {
                        return GangsPlusHook.this.getGangWLR(p);
                    }
                    case "gang_kills": {
                        return GangsPlusHook.this.getGangKills(p);
                    }
                    case "gang_deaths": {
                        return GangsPlusHook.this.getGangDeaths(p);
                    }
                    case "gang_kdr": {
                        return GangsPlusHook.this.getGangKDR(p);
                    }
                    case "gang_bank_money": {
                        return GangsPlusHook.this.getGangBankMoney(p);
                    }
                    case "gang_business_money": {
                        return GangsPlusHook.this.getGangBusinessMoney(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into GangsPlus for placeholders!");
        }
    }

    private String inGang(Player p) {
        return GangsPlusAPI.isInGang((Player)p) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    private String getGang(Player p) {
        if (GangsPlusAPI.isInGang((Player)p)) {
            return GangsPlusAPI.getPlayersGang((Player)p).getName();
        }
        return "";
    }

    private String getGangTag(Player p) {
        if (GangsPlusAPI.isInGang((Player)p)) {
            return GangsPlusAPI.getPlayersGang((Player)p).getFormattedName();
        }
        return "";
    }

    private String getGangLeader(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "";
        }
        return GangsPlusAPI.getPlayersGang((Player)p).getLeadersName();
    }

    private String getGangSize(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getMembersNumber());
    }

    private String getGangKills(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getKills());
    }

    private String getGangDeaths(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getDeaths());
    }

    private String getGangKDR(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getKdr());
    }

    private String getGangBankMoney(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getBankMoney());
    }

    private String getGangBusinessMoney(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getBusinessMoney());
    }

    private String getGangLevel(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getLevel());
    }

    private String getGangLosses(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getLost());
    }

    private String getGangWLR(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getWlr());
    }

    private String getGangWins(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getWon());
    }

    private String getGangOnline(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getOnlinePlayers().size());
    }

    private String getGangRank(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "";
        }
        return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getPlayersRankName(p));
    }

    private String getGangHomes(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "0";
        }
        if (GangsPlusAPI.getPlayersGang((Player)p).getHomes() != null) {
            return String.valueOf(GangsPlusAPI.getPlayersGang((Player)p).getHomes().size());
        }
        return "0";
    }

    private String getGangFF(Player p) {
        if (!GangsPlusAPI.isInGang((Player)p)) {
            return "";
        }
        return GangsPlusAPI.getPlayersGang((Player)p).isFriendlyFire() ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }
}

