/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.islandworld.IslandWorld;
import pl.islandworld.api.IslandWorldApi;

public class IslandWorldHook {
    private PlaceholderAPIPlugin plugin;

    public IslandWorldHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        IslandWorld is;
        if (Bukkit.getPluginManager().isPluginEnabled("IslandWorld") && (is = IslandWorld.getInstance()) != null && IslandWorldApi.isInitialized() && (hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)is, new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "points_with_party": {
                        return IslandWorldHook.this.getPoints(p, true);
                    }
                    case "points_without_party": {
                        return IslandWorldHook.this.getPoints(p, false);
                    }
                    case "island_members": {
                        return IslandWorldHook.this.getMembers(p, false);
                    }
                    case "all_members": {
                        return IslandWorldHook.this.getMembers(p, true);
                    }
                    case "can_build": {
                        return IslandWorldHook.this.canBuild(p, true);
                    }
                    case "in_party": {
                        return IslandWorldHook.this.inParty(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into IslandWorld for placeholders!");
        }
    }

    private String getPoints(Player p, boolean b) {
        return String.valueOf(IslandWorldApi.getPoints((String)p.getName(), (boolean)b, (boolean)false));
    }

    private String inParty(Player p) {
        return IslandWorldApi.isHelpingIsland((String)p.getName()) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    private String getMembers(Player p, boolean b) {
        String[] players = IslandWorldApi.getMembers((String)p.getName(), (boolean)b);
        if (players == null) {
            return "0";
        }
        return String.valueOf(players.length);
    }

    private String canBuild(Player p, boolean b) {
        return IslandWorldApi.canBuildOnLocation((Player)p, (Location)p.getLocation(), (boolean)b) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }
}

