/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MarriageMasterHook {
    private PlaceholderAPIPlugin plugin;
    private MarriageMaster marriage;

    public MarriageMasterHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("MarriageMaster")) {
            this.marriage = (MarriageMaster)Bukkit.getPluginManager().getPlugin("MarriageMaster");
            if (this.marriage != null) {
                boolean hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)this.marriage, new PlaceholderHook(){

                    @Override
                    public String onPlaceholderRequest(Player p, String identifier) {
                        if (p == null) {
                            return "";
                        }
                        switch (identifier) {
                            case "married": {
                                return MarriageMasterHook.this.married(p);
                            }
                            case "partner": {
                                return MarriageMasterHook.this.getPartner(p);
                            }
                        }
                        return null;
                    }
                }, true);
                if (hooked) {
                    this.plugin.log.info("Hooked into MarriageMaster for paceholders!");
                } else {
                    this.marriage = null;
                }
            }
        }
    }

    private boolean isMarried(Player p) {
        return this.marriage.HasPartner(p);
    }

    private String married(Player p) {
        return this.isMarried(p) ? "&c\u2665" : "&8\u2665";
    }

    private String getPartner(Player p) {
        if (!this.isMarried(p)) {
            return "";
        }
        String partner = this.marriage.DB.GetPartner(p);
        if (partner == null) {
            return "";
        }
        return partner;
    }
}

