/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.bimmr.mcinfectedranks.McInfectedRanks;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class McInfectedRanksHook {
    private PlaceholderAPIPlugin plugin;

    public McInfectedRanksHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("McInfected-Ranks") && (hooked = PlaceholderAPI.registerPlaceholderHook("McInfected-Ranks", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "rank": {
                        return McInfectedRanksHook.this.getRank(p);
                    }
                    case "prefix": {
                        return McInfectedRanksHook.this.getPrefix(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into McInfected-Ranks for placeholders!");
        }
    }

    private String getRank(Player p) {
        String rank = McInfectedRanks.getRankManager().getPlayersRank(p).getName();
        return rank != null ? rank : "";
    }

    private String getPrefix(Player p) {
        String pre = McInfectedRanks.getRankManager().getPlayersRank(p).getPrefix();
        return pre != null ? pre : "";
    }
}

