/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerPointsHook {
    private PlaceholderAPIPlugin plugin;
    private PlayerPoints playerPoints;

    public PlayerPointsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        PlayerPoints points;
        if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints") && (points = (PlayerPoints)Bukkit.getPluginManager().getPlugin("PlayerPoints")) != null) {
            this.playerPoints = points;
            boolean hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)points, new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (p == null) {
                        return "";
                    }
                    if (identifier.equals("points")) {
                        return PlayerPointsHook.this.getPoints(p);
                    }
                    return null;
                }
            }, true);
            if (hooked) {
                this.plugin.log.info("Hooked into PlayerPoints for placeholders!");
            }
        }
    }

    public boolean enabled() {
        return this.playerPoints != null;
    }

    private String getPoints(Player p) {
        if (!this.enabled()) {
            return "0";
        }
        return String.valueOf(this.playerPoints.getAPI().look(p.getUniqueId()));
    }
}

