/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.intellectualcrafters.plot.api.PlotAPI;
import com.intellectualcrafters.plot.object.Plot;
import com.intellectualcrafters.plot.util.PlotHelper;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlotSquaredHook {
    private PlaceholderAPIPlugin plugin;
    private PlotAPI plotAPI = null;

    public PlotSquaredHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlotSquared")) {
            boolean hooked;
            this.plotAPI = new PlotAPI((JavaPlugin)this.plugin);
            if (this.plotAPI != null && (hooked = PlaceholderAPI.registerPlaceholderHook("PlotSquared", new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (p == null) {
                        return "";
                    }
                    switch (identifier) {
                        case "currentplot_alias": {
                            return PlotSquaredHook.this.getCurrentPlot(p);
                        }
                        case "currentplot_owner": {
                            return PlotSquaredHook.this.getCurrentPlotOwner(p);
                        }
                        case "currentplot_helpers_size": {
                            return PlotSquaredHook.this.getCurrentPlotHelpers(p);
                        }
                        case "currentplot_x": {
                            return PlotSquaredHook.this.getCurrentPlotX(p);
                        }
                        case "currentplot_y": {
                            return PlotSquaredHook.this.getCurrentPlotY(p);
                        }
                        case "currentplot_world": {
                            return PlotSquaredHook.this.getCurrentPlotWorld(p);
                        }
                        case "has_plot": {
                            return PlotSquaredHook.this.hasPlot(p);
                        }
                        case "has_build_rights": {
                            return PlotSquaredHook.this.hasRights(p);
                        }
                        case "plot_count": {
                            return PlotSquaredHook.this.getPlotCount(p);
                        }
                        case "allowed_plot_count": {
                            return PlotSquaredHook.this.getAllowedPlotCount(p);
                        }
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into PlotSquared for placeholders!");
            }
        }
    }

    private String getCurrentPlotX(Player p) {
        if (this.plotAPI.isInPlot(p)) {
            Plot plot = this.plotAPI.getPlot(p);
            if (plot == null) {
                return "";
            }
            if (plot.id.x != null) {
                return String.valueOf(plot.id.x);
            }
        }
        return "";
    }

    private String getCurrentPlotY(Player p) {
        if (this.plotAPI.isInPlot(p)) {
            Plot plot = this.plotAPI.getPlot(p);
            if (plot == null) {
                return "";
            }
            if (plot.id.y != null) {
                return String.valueOf(plot.id.y);
            }
        }
        return "";
    }

    private String getCurrentPlotWorld(Player p) {
        if (this.plotAPI.isInPlot(p)) {
            Plot plot = this.plotAPI.getPlot(p);
            if (plot == null) {
                return "";
            }
            if (plot.getWorld() != null) {
                return plot.getWorld().getName();
            }
        }
        return "";
    }

    private String getCurrentPlotHelpers(Player p) {
        if (this.plotAPI.isInPlot(p)) {
            Plot plot = this.plotAPI.getPlot(p);
            if (plot == null) {
                return "";
            }
            if (plot.helpers != null) {
                return String.valueOf(plot.helpers.size());
            }
        }
        return "";
    }

    private String getCurrentPlot(Player p) {
        if (this.plotAPI.isInPlot(p)) {
            Plot plot = this.plotAPI.getPlot(p);
            if (plot == null) {
                return "";
            }
            if (plot.settings.getAlias() != null) {
                return plot.settings.getAlias();
            }
        }
        return "";
    }

    private String getPlotCount(Player p) {
        if (this.plotAPI != null) {
            return String.valueOf(this.plotAPI.getPlayerPlotCount(p.getWorld(), p));
        }
        return "";
    }

    private String getAllowedPlotCount(Player p) {
        if (this.plotAPI != null) {
            return String.valueOf(this.plotAPI.getAllowedPlots(p));
        }
        return "";
    }

    private String hasPlot(Player p) {
        if (this.plotAPI != null) {
            if (this.plotAPI.hasPlot(p.getWorld(), p)) {
                return PlaceholderAPIPlugin.booleanTrue();
            }
            return PlaceholderAPIPlugin.booleanFalse();
        }
        return "";
    }

    private String hasRights(Player p) {
        if (this.plotAPI != null && this.plotAPI.getPlot(p) != null) {
            if (this.plotAPI.getPlot(p).hasRights(p)) {
                return PlaceholderAPIPlugin.booleanTrue();
            }
            return PlaceholderAPIPlugin.booleanFalse();
        }
        return "";
    }

    private String getCurrentPlotOwner(Player p) {
        if (this.plotAPI != null && this.plotAPI.getPlot(p) != null) {
            if (this.plotAPI.getPlot(p).getOwner() != null && PlotHelper.getPlayerName((UUID)this.plotAPI.getPlot(p).getOwner()) != null) {
                return PlotHelper.getPlayerName((UUID)this.plotAPI.getPlot(p).getOwner());
            }
            return "";
        }
        return "";
    }
}

