/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.mydeblob.prisongangs.PrisonGangs;
import com.mydeblob.prisongangs.api.GangsAPI;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PrisonGangsHook {
    private PlaceholderAPIPlugin plugin;

    public PrisonGangsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        PrisonGangs gangs;
        if (Bukkit.getPluginManager().isPluginEnabled("PrisonGangs") && (gangs = (PrisonGangs)Bukkit.getPluginManager().getPlugin("PrisonGangs")) != null && (hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)gangs, new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "in_gang": {
                        return PrisonGangsHook.this.inGang(p);
                    }
                    case "gang_name": {
                        return PrisonGangsHook.this.getGang(p);
                    }
                    case "gang_size": {
                        return PrisonGangsHook.this.getGangSize(p);
                    }
                    case "gang_rank": {
                        return PrisonGangsHook.this.getGangRank(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into PrisonGangs for placeholders!");
        }
    }

    private String inGang(Player p) {
        if (GangsAPI.inGang((Player)p)) {
            return "&aYes";
        }
        return "&cNo";
    }

    private String getGang(Player p) {
        return GangsAPI.inGang((Player)p) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }

    private String getGangSize(Player p) {
        if (GangsAPI.inGang((Player)p) && GangsAPI.getGang((Player)p) != null && GangsAPI.getGang((Player)p).getAllPlayers() != null) {
            return String.valueOf(GangsAPI.getGang((Player)p).getAllPlayers().size());
        }
        return "0";
    }

    private String getGangRank(Player p) {
        String rank;
        if (GangsAPI.inGang((Player)p) && GangsAPI.getGang((Player)p) != null && (rank = GangsAPI.getGang((Player)p).getPlayer(p).getRank().name()) != null) {
            return rank;
        }
        return "";
    }
}

