/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import net.slipcor.pvpstats.PVPData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PvPStatsHook {
    private PlaceholderAPIPlugin plugin;

    public PvPStatsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("pvpstats") && (hooked = PlaceholderAPI.registerPlaceholderHook("pvpstats", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "kills": {
                        return PvPStatsHook.this.getKills(p);
                    }
                    case "deaths": {
                        return PvPStatsHook.this.getDeaths(p);
                    }
                    case "elo": {
                        return PvPStatsHook.this.getElo(p);
                    }
                    case "killstreak": {
                        return PvPStatsHook.this.getStreak(p);
                    }
                    case "maxstreak": {
                        return PvPStatsHook.this.getMaxStreak(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into pvpstats for placeholders!");
        }
    }

    private String getKills(Player p) {
        return String.valueOf(PVPData.getKills((String)p.getName()));
    }

    private String getDeaths(Player p) {
        return String.valueOf(PVPData.getDeaths((String)p.getName()));
    }

    private String getElo(Player p) {
        return String.valueOf(PVPData.getEloScore((String)p.getName()));
    }

    private String getStreak(Player p) {
        return String.valueOf(PVPData.getStreak((String)p.getName()));
    }

    private String getMaxStreak(Player p) {
        return String.valueOf(PVPData.getMaxStreak((String)p.getName()));
    }
}

