/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import src.john01dav.sqlperms.SQLPerms;
import src.john01dav.sqlperms.database.DataStore;

public class SQLPermsHook {
    private PlaceholderAPIPlugin plugin;
    private SQLPerms sqlperms;

    public SQLPermsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("SQLPerms")) {
            boolean hooked;
            this.sqlperms = (SQLPerms)Bukkit.getPluginManager().getPlugin("SQLPerms");
            if (this.sqlperms != null && (hooked = PlaceholderAPI.registerPlaceholderHook((Plugin)this.sqlperms, new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (p == null) {
                        return "";
                    }
                    if (identifier.contains("rank_")) {
                        String channel = identifier.split("rank_")[1];
                        return SQLPermsHook.this.getPrefix(p, channel);
                    }
                    if (identifier.contains("prefix_")) {
                        String channel = identifier.split("prefix_")[1];
                        return SQLPermsHook.this.getPrefix(p, SQLPermsHook.this.getGroup(p, channel));
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into SQLPerms for placeholders!");
            }
        }
    }

    private String getPrefix(Player p, String rank) {
        if (rank == null || rank.isEmpty()) {
            return rank;
        }
        String prefix = this.sqlperms.getConfigManager().getPermissionsConfigurationManager().getPrefix(rank);
        if (prefix == null || prefix.isEmpty()) {
            return "";
        }
        return prefix;
    }

    private String getGroup(Player p, String s) {
        DataStore store = this.sqlperms.getDataStore();
        if (store == null) {
            return "";
        }
        String rank = store.getRank(p.getUniqueId(), s);
        if (rank != null) {
            return rank;
        }
        return "";
    }
}

