/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.coder_m.teams.TeamManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TeamsHook {
    private PlaceholderAPIPlugin plugin;

    public TeamsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("Teams") && TeamManager.getTeamManager() != null && (hooked = PlaceholderAPI.registerPlaceholderHook("Teams", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "team": {
                        return TeamsHook.this.getTeamName(p);
                    }
                    case "is_leader": {
                        return TeamsHook.this.isTeamLeader(p);
                    }
                    case "leader": {
                        return TeamsHook.this.getTeamLeader(p);
                    }
                    case "size": {
                        return TeamsHook.this.getTeamSize(p);
                    }
                    case "leaders_size": {
                        return TeamsHook.this.getLeaderSize(p);
                    }
                    case "friendly_fire": {
                        return TeamsHook.this.getFf(p);
                    }
                    case "home_location": {
                        return TeamsHook.this.getHomeLocation(p);
                    }
                    case "home_x": {
                        return TeamsHook.this.getHomeX(p);
                    }
                    case "home_y": {
                        return TeamsHook.this.getHomeY(p);
                    }
                    case "home_z": {
                        return TeamsHook.this.getHomeZ(p);
                    }
                    case "home_world": {
                        return TeamsHook.this.getHomeWorld(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into Teams for placeholders!");
        }
    }

    private String getTeamName(Player p) {
        if (TeamManager.getTeamManager().getInTeam(p) != null && !TeamManager.getTeamManager().getInTeam(p).isEmpty()) {
            return (String)TeamManager.getTeamManager().getInTeam(p).get(0);
        }
        return "";
    }

    private String getTeamSize(Player p) {
        if (this.getTeamName(p) != "") {
            return String.valueOf(TeamManager.getTeamManager().getTeamSize(this.getTeamName(p)));
        }
        return "";
    }

    private String getLeaderSize(Player p) {
        if (this.getTeamName(p) != "") {
            return String.valueOf(TeamManager.getTeamManager().getTeamLeaderAmount(p));
        }
        return "";
    }

    private String isTeamLeader(Player p) {
        if (this.getTeamName(p) != "") {
            if (TeamManager.getTeamManager().isTeamLeader(p)) {
                return PlaceholderAPIPlugin.booleanTrue();
            }
            return PlaceholderAPIPlugin.booleanFalse();
        }
        return "";
    }

    private String getFf(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getFriendlyFire(this.getTeamName(p)) != null) {
            return TeamManager.getTeamManager().getFriendlyFire(this.getTeamName(p));
        }
        return "";
    }

    private String getHomeLocation(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)) != null) {
            Location l = TeamManager.getTeamManager().getTeamHome(this.getTeamName(p));
            String loc = String.valueOf(l.getBlockX()) + " " + l.getBlockY() + " " + l.getBlockZ();
            return loc;
        }
        return "";
    }

    private String getHomeWorld(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)) != null) {
            return TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)).getWorld().getName();
        }
        return "";
    }

    private String getHomeX(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)) != null) {
            Location l = TeamManager.getTeamManager().getTeamHome(this.getTeamName(p));
            return String.valueOf(l.getBlockX());
        }
        return "";
    }

    private String getHomeY(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)) != null) {
            Location l = TeamManager.getTeamManager().getTeamHome(this.getTeamName(p));
            return String.valueOf(l.getBlockY());
        }
        return "";
    }

    private String getHomeZ(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamHome(this.getTeamName(p)) != null) {
            Location l = TeamManager.getTeamManager().getTeamHome(this.getTeamName(p));
            return String.valueOf(l.getBlockZ());
        }
        return "";
    }

    private String getTeamLeader(Player p) {
        if (this.getTeamName(p) != "" && TeamManager.getTeamManager().getTeamLeader(this.getTeamName(p)) != null) {
            return TeamManager.getTeamManager().getTeamLeader(this.getTeamName(p));
        }
        return "";
    }
}

