/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TownyHook {
    private PlaceholderAPIPlugin plugin;

    public TownyHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("Towny") && (hooked = PlaceholderAPI.registerPlaceholderHook("Towny", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "town": {
                        return TownyHook.this.getPlayersTown(p);
                    }
                    case "friends": {
                        return TownyHook.this.getPlayersFriends(p);
                    }
                    case "nation": {
                        return TownyHook.this.getPlayersNation(p);
                    }
                    case "title": {
                        return TownyHook.this.getPlayersTownyTitle(p);
                    }
                    case "town_residents": {
                        return TownyHook.this.getTownResidents(p);
                    }
                    case "town_size": {
                        return TownyHook.this.getTownSize(p);
                    }
                    case "town_tag": {
                        return TownyHook.this.getTownTag(p);
                    }
                    case "town_balance": {
                        return TownyHook.this.getTownBankBalance(p);
                    }
                    case "town_mayor": {
                        return TownyHook.this.getTownMayor(p);
                    }
                    case "surname": {
                        return TownyHook.this.getPlayersSurname(p);
                    }
                    case "town_rank": {
                        return TownyHook.this.getTownRank(p);
                    }
                    case "nation_rank": {
                        return TownyHook.this.getNationRank(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into Towny for placeholders!");
        }
    }

    private String getPlayersTown(Player p) {
        String town = "";
        try {
            town = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return town;
    }

    private String getPlayersFriends(Player p) {
        String res = "";
        try {
            res = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getFriends().size());
        }
        catch (Exception e) {
            return "";
        }
        return res;
    }

    private String getPlayersNation(Player p) {
        String nation = "";
        try {
            nation = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getNation().getName());
        }
        catch (Exception e) {
            return "";
        }
        return nation;
    }

    private String getPlayersTownyTitle(Player p) {
        String title = "";
        try {
            title = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTitle());
        }
        catch (Exception e) {
            return "";
        }
        return title;
    }

    private String getPlayersSurname(Player p) {
        String title = "";
        try {
            title = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getSurname());
        }
        catch (Exception e) {
            return "";
        }
        return title;
    }

    private String getTownResidents(Player p) {
        String res = "";
        try {
            res = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getNumResidents());
        }
        catch (Exception e) {
            return "";
        }
        return res;
    }

    private String getTownBankBalance(Player p) {
        String bal = "";
        try {
            bal = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getHoldingBalance());
        }
        catch (Exception e) {
            return "";
        }
        return bal;
    }

    private String getTownMayor(Player p) {
        String mayor = "";
        try {
            mayor = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getMayor().getName());
        }
        catch (Exception e) {
            return "";
        }
        return mayor;
    }

    private String getTownRank(Player p) {
        String rank;
        block3: {
            rank = "";
            try {
                List ranks = TownyUniverse.getDataSource().getResident(p.getName()).getTownRanks();
                if (ranks == null || ranks.isEmpty()) break block3;
                for (String r : ranks) {
                    if (!TownyUniverse.getDataSource().getResident(p.getName()).hasTownRank(r)) continue;
                    rank = r;
                    break;
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        return rank;
    }

    private String getNationRank(Player p) {
        String rank;
        block3: {
            rank = "";
            try {
                List ranks = TownyUniverse.getDataSource().getResident(p.getName()).getNationRanks();
                if (ranks == null || ranks.isEmpty()) break block3;
                for (String r : ranks) {
                    if (!TownyUniverse.getDataSource().getResident(p.getName()).hasNationRank(r)) continue;
                    rank = r;
                    break;
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        return rank;
    }

    private String getTownSize(Player p) {
        String size = "";
        try {
            size = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getTotalBlocks());
        }
        catch (Exception e) {
            return "";
        }
        return size;
    }

    private String getTownTag(Player p) {
        String tag = "";
        try {
            tag = String.valueOf(TownyUniverse.getDataSource().getResident(p.getName()).getTown().getTag());
        }
        catch (Exception e) {
            return "";
        }
        return tag;
    }
}

