/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import teozfrank.ultimatevotes.util.UltimateVotesAPI;

public class UltimateVotesHook {
    private PlaceholderAPIPlugin plugin;

    public UltimateVotesHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("UltimateVotes") && (hooked = PlaceholderAPI.registerPlaceholderHook("UltimateVotes", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "monthlyvotes": {
                        return UltimateVotesHook.this.getMonthly(p);
                    }
                    case "totalvotes": {
                        return UltimateVotesHook.this.getTotal(p);
                    }
                    case "hasvoted": {
                        return UltimateVotesHook.this.hasVoted(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into UltimateVotes for placeholders!");
        }
    }

    private String getMonthly(Player p) {
        return String.valueOf(UltimateVotesAPI.getPlayerMonthlyVotes((UUID)p.getUniqueId()));
    }

    private String getTotal(Player p) {
        return String.valueOf(UltimateVotesAPI.getPlayerTotalVotes((UUID)p.getUniqueId()));
    }

    private String hasVoted(Player p) {
        return UltimateVotesAPI.hasVotedToday((UUID)p.getUniqueId()) ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
    }
}

