/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private PlaceholderAPIPlugin plugin;
    private static Permission perms = null;
    private static Economy econ = null;
    private static Chat chat = null;

    public VaultHook(PlaceholderAPIPlugin instance) {
        this.plugin = instance;
    }

    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            boolean hooked;
            boolean ecoHooked;
            if (this.setupEconomy() && (ecoHooked = PlaceholderAPI.registerPlaceholderHook("Vaulteco", new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (p == null) {
                        return "";
                    }
                    if (identifier.equals("balance")) {
                        return String.valueOf(VaultHook.this.getBalance((OfflinePlayer)p));
                    }
                    if (identifier.equals("balance_fixed")) {
                        return VaultHook.this.rounded(VaultHook.this.getBalance((OfflinePlayer)p));
                    }
                    if (identifier.equals("balance_formatted")) {
                        return VaultHook.this.formatted(VaultHook.this.getBalance((OfflinePlayer)p));
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into Vault for economy placeholders!");
            }
            if (this.setupPerms() && (hooked = PlaceholderAPI.registerPlaceholderHook("Vault", new PlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player p, String identifier) {
                    if (identifier.startsWith("rankprefix_")) {
                        int i = 1;
                        try {
                            i = Integer.parseInt(identifier.split("rankprefix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupPrefix(p, i);
                    }
                    if (identifier.startsWith("ranksuffix_")) {
                        int i = 1;
                        try {
                            i = Integer.parseInt(identifier.split("ranksuffix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupSuffix(p, i);
                    }
                    if (identifier.startsWith("groupprefix_")) {
                        int i = 1;
                        try {
                            i = Integer.parseInt(identifier.split("groupprefix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupPrefix(p, i);
                    }
                    if (identifier.startsWith("groupsuffix_")) {
                        int i = 1;
                        try {
                            i = Integer.parseInt(identifier.split("groupsuffix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupSuffix(p, i);
                    }
                    switch (identifier) {
                        case "rank": 
                        case "group": {
                            return VaultHook.this.getMainGroup(p) != null ? VaultHook.this.getMainGroup(p) : "";
                        }
                        case "prefix": {
                            return VaultHook.this.getPlayerPrefix(p) != null ? VaultHook.this.getPlayerPrefix(p) : "";
                        }
                        case "groupprefix": 
                        case "rankprefix": {
                            return VaultHook.this.getGroupPrefix(p) != null ? VaultHook.this.getGroupPrefix(p) : "";
                        }
                        case "suffix": {
                            return VaultHook.this.getPlayerSuffix(p) != null ? VaultHook.this.getPlayerSuffix(p) : "";
                        }
                        case "ranksuffix": 
                        case "groupsuffix": {
                            return VaultHook.this.getGroupSuffix(p) != null ? VaultHook.this.getGroupSuffix(p) : "";
                        }
                        case "prefix_color": {
                            return VaultHook.this.getGroupPrefixColor(p) != null ? VaultHook.this.getGroupPrefixColor(p) : "";
                        }
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into Vault for permissions placeholders!");
            }
        }
    }

    private String rounded(double amt) {
        long send = (long)amt;
        return String.valueOf(send);
    }

    private String formatted(double amount) {
        int p;
        String format;
        String p2;
        if (amount >= 1.0E15) {
            int p3;
            String format2 = String.format("%.2f", amount / 1.0E15);
            String p22 = format2.substring((p3 = format2.indexOf(".")) + 1);
            if (p22.endsWith("0")) {
                format2 = p22.startsWith("0") ? format2.substring(0, format2.length() - 3) : format2.substring(0, format2.length() - 1);
            }
            return String.valueOf(format2) + " Quadrillion";
        }
        if (amount >= 1.0E12) {
            int p4;
            String format3 = String.format("%.2f", amount / 1.0E12);
            String p23 = format3.substring((p4 = format3.indexOf(".")) + 1);
            if (p23.endsWith("0")) {
                format3 = p23.startsWith("0") ? format3.substring(0, format3.length() - 3) : format3.substring(0, format3.length() - 1);
            }
            return String.valueOf(format3) + " Trillion";
        }
        if (amount >= 1.0E9) {
            int p5;
            String format4 = String.format("%.2f", amount / 1.0E9);
            String p24 = format4.substring((p5 = format4.indexOf(".")) + 1);
            if (p24.endsWith("0")) {
                format4 = p24.startsWith("0") ? format4.substring(0, format4.length() - 3) : format4.substring(0, format4.length() - 1);
            }
            return String.valueOf(format4) + " Billion";
        }
        if (amount >= 1000000.0) {
            int p6;
            String format5 = String.format("%.2f", amount / 1000000.0);
            String p25 = format5.substring((p6 = format5.indexOf(".")) + 1);
            if (p25.endsWith("0")) {
                format5 = p25.startsWith("0") ? format5.substring(0, format5.length() - 3) : format5.substring(0, format5.length() - 1);
            }
            return String.valueOf(format5) + " Million";
        }
        if (amount >= 1000.0 && (p2 = (format = String.format("%.2f", amount / 1000.0)).substring((p = format.indexOf(".")) + 1)).endsWith("0")) {
            format = p2.startsWith("0") ? format.substring(0, format.length() - 3) : format.substring(0, format.length() - 1);
            return String.valueOf(format) + " Thousand";
        }
        int amt = (int)amount;
        return String.valueOf(amt);
    }

    private boolean setupEconomy() {
        if (this.plugin.getConfig().getBoolean("hooks.vault_eco")) {
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return false;
            }
            econ = (Economy)rsp.getProvider();
            return econ != null;
        }
        return false;
    }

    private boolean setupPerms() {
        if (this.plugin.getConfig().getBoolean("hooks.vault_perms")) {
            RegisteredServiceProvider chatProvider;
            RegisteredServiceProvider permsProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (permsProvider != null && permsProvider.getPlugin() != null) {
                perms = (Permission)permsProvider.getProvider();
            }
            if ((chatProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class)) != null && chatProvider.getPlugin() != null) {
                chat = (Chat)chatProvider.getProvider();
            }
            return perms != null && chat != null;
        }
        return false;
    }

    public boolean useVaultChat() {
        return chat != null;
    }

    public boolean useVaultEcon() {
        return econ != null;
    }

    public boolean useVaultPerms() {
        return perms != null;
    }

    public String getVaultVersion() {
        return Bukkit.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion();
    }

    public String[] getGroups(Player p) {
        if (perms.getPlayerGroups(p) != null) {
            return perms.getPlayerGroups(p);
        }
        return new String[]{""};
    }

    public double getBalance(OfflinePlayer p) {
        if (econ != null) {
            return econ.getBalance(p);
        }
        return 0.0;
    }

    public String getMainGroup(Player p) {
        if (perms.getPrimaryGroup(p) != null) {
            return String.valueOf(perms.getPrimaryGroup(p));
        }
        return "";
    }

    public boolean opHasPermission(Player p, String perm) {
        if (perms.getPrimaryGroup(p) != null) {
            return perms.groupHas(p.getWorld(), perms.getPrimaryGroup(p), perm);
        }
        return false;
    }

    public boolean addPerm(Player p, String perm) {
        return perms.playerAdd(p, perm);
    }

    public String getPlayerPrefix(Player p) {
        if (chat.getPlayerPrefix(p) != null) {
            return String.valueOf(chat.getPlayerPrefix(p));
        }
        return "";
    }

    public String getPlayerSuffix(Player p) {
        if (chat.getPlayerSuffix(p) != null) {
            return String.valueOf(chat.getPlayerSuffix(p));
        }
        return "";
    }

    public String getGroupSuffix(Player p) {
        if (perms.getPrimaryGroup(p) == null) {
            return "";
        }
        if (chat.getGroupSuffix(p.getWorld(), perms.getPrimaryGroup(p)) != null) {
            return String.valueOf(chat.getGroupSuffix(p.getWorld(), perms.getPrimaryGroup(p)));
        }
        return "";
    }

    public String getGroupPrefix(Player p) {
        if (perms.getPrimaryGroup(p) == null) {
            return "";
        }
        if (chat.getGroupPrefix(p.getWorld(), perms.getPrimaryGroup(p)) != null) {
            return String.valueOf(chat.getGroupPrefix(p.getWorld(), perms.getPrimaryGroup(p)));
        }
        return "";
    }

    public String getGroupSuffix(Player p, int i) {
        if (perms.getPlayerGroups(p) == null) {
            return "";
        }
        String[] groups = perms.getPlayerGroups(p);
        if (i > groups.length) {
            return "";
        }
        int count = 1;
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (count < i) {
                ++count;
            } else if (chat.getGroupSuffix(p.getWorld(), group) != null) {
                return String.valueOf(chat.getGroupSuffix(p.getWorld(), group));
            }
            ++n2;
        }
        return "";
    }

    public String getGroupPrefix(Player p, int i) {
        if (perms.getPlayerGroups(p) == null) {
            return "";
        }
        String[] groups = perms.getPlayerGroups(p);
        if (i > groups.length) {
            return "";
        }
        int count = 1;
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (count < i) {
                ++count;
            } else if (chat.getGroupPrefix(p.getWorld(), group) != null) {
                return String.valueOf(chat.getGroupPrefix(p.getWorld(), group));
            }
            ++n2;
        }
        return "";
    }

    public String getGroupPrefixColor(Player p) {
        if (perms.getPlayerGroups(p) == null) {
            return "";
        }
        String[] stringArray = perms.getPlayerGroups(p);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            if (chat.getGroupPrefix(p.getWorld(), group) != null) {
                return String.valueOf(chat.getGroupPrefix(p.getWorld(), group).substring(0, 2));
            }
            ++n2;
        }
        return "";
    }

    public boolean hasPerm(Player p, String perm) {
        if (perms != null) {
            return perms.has(p, perm);
        }
        return p.hasPermission(perm);
    }

    public String[] getServerGroups() {
        if (perms.getGroups() != null) {
            return perms.getGroups();
        }
        return new String[]{""};
    }
}

