/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.hooks;

import com.mooglemods.wickedskywars.controllers.PlayerController;
import com.mooglemods.wickedskywars.player.GamePlayer;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class WickedSkywarsHook {
    private PlaceholderAPIPlugin plugin;

    public WickedSkywarsHook(PlaceholderAPIPlugin i) {
        this.plugin = i;
    }

    public void hook() {
        boolean hooked;
        if (Bukkit.getPluginManager().isPluginEnabled("WickedSkyWars") && (hooked = PlaceholderAPI.registerPlaceholderHook("WickedSkyWars", new PlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player p, String identifier) {
                if (p == null) {
                    return "";
                }
                switch (identifier) {
                    case "score": {
                        return WickedSkywarsHook.this.getScore(p);
                    }
                    case "kills": {
                        return WickedSkywarsHook.this.getKills(p);
                    }
                    case "deaths": {
                        return WickedSkywarsHook.this.getDeaths(p);
                    }
                    case "played": 
                    case "gamesplayed": {
                        return WickedSkywarsHook.this.getGamesPlayed(p);
                    }
                    case "gameswon": 
                    case "won": {
                        return WickedSkywarsHook.this.getGamesWon(p);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into WickedSkyWars for placeholders!");
        }
    }

    private String getScore(Player p) {
        GamePlayer gamePlayer = PlayerController.get().get(p);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getScore());
    }

    private String getKills(Player p) {
        GamePlayer gamePlayer = PlayerController.get().get(p);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getKills());
    }

    private String getDeaths(Player p) {
        GamePlayer gamePlayer = PlayerController.get().get(p);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getDeaths());
    }

    private String getGamesPlayed(Player p) {
        GamePlayer gamePlayer = PlayerController.get().get(p);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getGamesPlayed());
    }

    private String getGamesWon(Player p) {
        GamePlayer gamePlayer = PlayerController.get().get(p);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getGamesWon());
    }
}

