/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.javascript;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.javascript.JavascriptReturnType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class JavascriptPlaceholder {
    private String identifier;
    private String expression;
    private String trueResult;
    private String falseResult;
    private JavascriptReturnType type;
    private static ScriptEngine engine = null;

    public JavascriptPlaceholder(String identifier, JavascriptReturnType type, String expression, String trueResult, String falseResult) {
        if (type == null) {
            throw new IllegalArgumentException("Javascript placeholder type must either be 'boolean' or 'javascript'!");
        }
        this.type = type;
        if (identifier == null) {
            throw new IllegalArgumentException("Javascript placeholder identifier must not be null!");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Javascript placeholder expression must not be null!");
        }
        this.identifier = identifier;
        this.expression = expression;
        if (type == JavascriptReturnType.BOOLEAN) {
            if (trueResult == null) {
                throw new IllegalArgumentException("Javascript boolean placeholder must contain a true_result!");
            }
            if (falseResult == null) {
                throw new IllegalArgumentException("Javascript boolean placeholder must contain a false_result!");
            }
            this.trueResult = trueResult;
            this.falseResult = falseResult;
        }
    }

    public static void cleanup() {
        engine = null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTrueResult() {
        return this.trueResult;
    }

    public String getFalseResult() {
        return this.falseResult;
    }

    public JavascriptReturnType getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String evaluate(Player p) {
        Object result;
        block4: {
            if (engine == null) {
                engine = new ScriptEngineManager().getEngineByName("javascript");
                engine.put("BukkitServer", Bukkit.getServer());
            }
            String exp = PlaceholderAPI.setPlaceholders(p, this.expression);
            try {
                engine.put("BukkitPlayer", p);
                result = engine.eval(exp);
                if (this.type != JavascriptReturnType.BOOLEAN) return result.toString();
                if (result instanceof Boolean) break block4;
                return "invalid javascript";
            }
            catch (Exception ex) {
                PlaceholderAPIPlugin.getInstance().log.severe("Error in javascript placeholder - " + this.identifier);
                ex.printStackTrace();
                return null;
            }
        }
        if (!((Boolean)result).booleanValue()) return PlaceholderAPI.setPlaceholders(p, this.falseResult);
        return PlaceholderAPI.setPlaceholders(p, this.trueResult);
    }
}

