/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.api.profiles;

import com.google.gson.Gson;
import com.mojang.api.http.BasicHttpClient;
import com.mojang.api.http.HttpBody;
import com.mojang.api.http.HttpClient;
import com.mojang.api.http.HttpHeader;
import com.mojang.api.profiles.Profile;
import com.mojang.api.profiles.ProfileCriteria;
import com.mojang.api.profiles.ProfileRepository;
import com.mojang.api.profiles.ProfileSearchResult;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HttpProfileRepository
implements ProfileRepository {
    private static final int MAX_PAGES_TO_CHECK = 100;
    private static Gson gson = new Gson();
    private HttpClient client;

    public HttpProfileRepository() {
        this(BasicHttpClient.getInstance());
    }

    public HttpProfileRepository(HttpClient client) {
        this.client = client;
    }

    @Override
    public Profile[] findProfilesByCriteria(ProfileCriteria ... criteria) {
        try {
            ProfileSearchResult result;
            HttpBody body = new HttpBody(gson.toJson(criteria));
            ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
            headers.add(new HttpHeader("Content-Type", "application/json"));
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (int i = 1; i <= 100 && (result = this.post(new URL("https://api.mojang.com/profiles/page/" + i), body, headers)).getSize() != 0; ++i) {
                profiles.addAll(Arrays.asList(result.getProfiles()));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Profile[0];
        }
    }

    private ProfileSearchResult post(URL url, HttpBody body, List<HttpHeader> headers) throws IOException {
        String response = this.client.post(url, body, headers);
        return gson.fromJson(response, ProfileSearchResult.class);
    }
}

