/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.Locale;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;

public class BPConfig {
    protected Config config;
    private boolean useUUIDs;
    private boolean useRegexPerms;
    private boolean groupPermission;
    private BackEndType backEndType;
    private UUIDPlayerDBType UUIDPlayerDBType;
    private String tablePrefix;
    private int fetcherCooldown;
    private boolean saveAllUsers;
    private boolean deleteUsersOnCleanup;
    private boolean notifyPromote;
    private boolean notifyDemote;
    private boolean tabComplete;
    private Locale locale;
    private boolean terminatePrefixReset;
    private boolean terminateSuffixReset;
    private boolean terminatePrefixSpace;
    private boolean terminateSuffixSpace;
    private boolean debug;
    private int cleanupInterval;
    private int cleanupThreshold;
    private boolean asyncCommands;

    public BPConfig(Config config) {
        this.config = config;
    }

    public void load() {
        this.config.load();
        this.useUUIDs = this.config.getBoolean("useUUIDs", false);
        this.useRegexPerms = this.config.getBoolean("useregexperms", false);
        this.groupPermission = this.config.getBoolean("grouppermission", true);
        this.backEndType = this.config.getEnumValue("backendtype", BackEndType.YAML);
        this.UUIDPlayerDBType = this.config.getEnumValue("uuidplayerdb", net.alpenblock.bungeeperms.io.UUIDPlayerDBType.YAML);
        this.tablePrefix = this.config.getString("tablePrefix", "bungeeperms_");
        this.fetcherCooldown = this.config.getInt("uuidfetcher.cooldown", 3000);
        this.saveAllUsers = this.config.getBoolean("saveAllUsers", true);
        this.deleteUsersOnCleanup = this.config.getBoolean("deleteUsersOnCleanup", false);
        this.notifyPromote = this.config.getBoolean("notify.promote", false);
        this.notifyDemote = this.config.getBoolean("notify.demote", false);
        this.tabComplete = this.config.getBoolean("tabcomplete", false);
        this.locale = Locale.forLanguageTag(this.config.getString("locale", Statics.localeString(new Locale("en", "GB"))));
        this.terminatePrefixReset = this.config.getBoolean("terminate.prefix.reset", true);
        this.terminateSuffixReset = this.config.getBoolean("terminate.suffix.reset", true);
        this.terminatePrefixSpace = this.config.getBoolean("terminate.prefix.space", true);
        this.terminateSuffixSpace = this.config.getBoolean("terminate.suffix.space", true);
        this.cleanupInterval = this.config.getInt("cleanup.interval", 1800);
        this.cleanupThreshold = this.config.getInt("cleanup.threshold", 600);
        this.asyncCommands = this.config.getBoolean("async-commands", true);
        this.validate();
    }

    public void validate() {
        if (this.useUUIDs) {
            if (this.UUIDPlayerDBType == net.alpenblock.bungeeperms.io.UUIDPlayerDBType.None) {
                BungeePerms.getLogger().warning(Lang.translate(Lang.MessageType.MISCONFIGURATION, new Object[0]) + ": " + Lang.translate(Lang.MessageType.MISCONFIG_USEUUID_NONE_UUID_DB, new Object[0]));
            }
        }
    }

    public void setUseUUIDs(boolean useUUIDs) {
        this.useUUIDs = useUUIDs;
        this.config.setBool("useUUIDs", useUUIDs);
        this.config.save();
    }

    public void setUUIDPlayerDB(UUIDPlayerDBType type) {
        this.UUIDPlayerDBType = type;
        this.config.setEnumValue("uuidplayerdb", type);
        this.config.save();
    }

    public void setBackendType(BackEndType type) {
        this.backEndType = type;
        this.config.setEnumValue("backendtype", type);
        this.config.save();
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean isUseUUIDs() {
        return this.useUUIDs;
    }

    public boolean isUseRegexPerms() {
        return this.useRegexPerms;
    }

    public boolean isGroupPermission() {
        return this.groupPermission;
    }

    public BackEndType getBackEndType() {
        return this.backEndType;
    }

    public UUIDPlayerDBType getUUIDPlayerDBType() {
        return this.UUIDPlayerDBType;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public int getFetcherCooldown() {
        return this.fetcherCooldown;
    }

    public boolean isSaveAllUsers() {
        return this.saveAllUsers;
    }

    public boolean isDeleteUsersOnCleanup() {
        return this.deleteUsersOnCleanup;
    }

    public boolean isNotifyPromote() {
        return this.notifyPromote;
    }

    public boolean isNotifyDemote() {
        return this.notifyDemote;
    }

    public boolean isTabComplete() {
        return this.tabComplete;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isTerminatePrefixReset() {
        return this.terminatePrefixReset;
    }

    public boolean isTerminateSuffixReset() {
        return this.terminateSuffixReset;
    }

    public boolean isTerminatePrefixSpace() {
        return this.terminatePrefixSpace;
    }

    public boolean isTerminateSuffixSpace() {
        return this.terminateSuffixSpace;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getCleanupInterval() {
        return this.cleanupInterval;
    }

    public int getCleanupThreshold() {
        return this.cleanupThreshold;
    }

    public boolean isAsyncCommands() {
        return this.asyncCommands;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

