/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.logging.Logger;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.CleanupTask;
import net.alpenblock.bungeeperms.CommandHandler;
import net.alpenblock.bungeeperms.Debug;
import net.alpenblock.bungeeperms.FileExtractor;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.PermissionsChecker;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.PermissionsResolver;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.platform.EventDispatcher;
import net.alpenblock.bungeeperms.platform.EventListener;
import net.alpenblock.bungeeperms.platform.NetworkNotifier;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.PluginMessageSender;

public class BungeePerms {
    public static final String CHANNEL = "bungeeperms";
    private static BungeePerms instance;
    private static Logger logger;
    private final PlatformPlugin plugin;
    private final BPConfig config;
    private final Debug debug;
    private final PermissionsManager permissionsManager;
    private final CommandHandler commandHandler;
    private final PermissionsChecker permissionsChecker;
    private final PluginMessageSender pluginMessageSender;
    private final NetworkNotifier networkNotifier;
    private final EventListener eventListener;
    private final EventDispatcher eventDispatcher;
    private final PermissionsResolver permissionsResolver;
    private final CleanupTask cleanupTask;
    private int cleanupTaskId = -1;
    private boolean enabled;

    public BungeePerms(PlatformPlugin plugin, BPConfig config, PluginMessageSender pluginMessageSender, NetworkNotifier networkNotifier, EventListener eventListener, EventDispatcher eventDispatcher) {
        instance = this;
        logger = plugin.getLogger();
        this.plugin = plugin;
        this.config = config;
        this.debug = new Debug(plugin, config.getConfig(), "BP");
        FileExtractor.extractAll();
        Lang.load(plugin.getPluginFolderPath() + "/lang/" + Statics.localeString(config.getLocale()) + ".yml");
        this.permissionsManager = new PermissionsManager(plugin, config, this.debug);
        this.permissionsChecker = new PermissionsChecker();
        this.commandHandler = new CommandHandler(plugin, this.permissionsChecker, config);
        this.pluginMessageSender = pluginMessageSender;
        this.networkNotifier = networkNotifier;
        this.eventListener = eventListener;
        this.eventDispatcher = eventDispatcher;
        this.permissionsResolver = new PermissionsResolver();
        this.cleanupTask = new CleanupTask();
    }

    public void load() {
        Lang.load(this.plugin.getPluginFolderPath() + "/lang/" + Statics.localeString(this.config.getLocale()) + ".yml");
        this.permissionsResolver.setUseRegex(this.config.isUseRegexPerms());
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        logger.info("Activating BungeePerms ...");
        this.permissionsManager.enable();
        this.eventListener.enable();
        this.cleanupTaskId = this.plugin.registerRepeatingTask(this.cleanupTask, 0L, this.config.getCleanupInterval() * 1000);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        logger.info("Deactivating BungeePerms ...");
        this.plugin.cancelTask(this.cleanupTaskId);
        this.cleanupTaskId = -1;
        this.eventListener.disable();
        this.permissionsManager.disable();
    }

    public void reload(boolean notifynetwork) {
        this.disable();
        this.load();
        this.permissionsManager.reload();
        if (notifynetwork) {
            this.networkNotifier.reloadAll("");
        }
        this.enable();
    }

    public PlatformPlugin getPlugin() {
        return this.plugin;
    }

    public BPConfig getConfig() {
        return this.config;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public PermissionsChecker getPermissionsChecker() {
        return this.permissionsChecker;
    }

    public PluginMessageSender getPluginMessageSender() {
        return this.pluginMessageSender;
    }

    public NetworkNotifier getNetworkNotifier() {
        return this.networkNotifier;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public PermissionsResolver getPermissionsResolver() {
        return this.permissionsResolver;
    }

    public CleanupTask getCleanupTask() {
        return this.cleanupTask;
    }

    public int getCleanupTaskId() {
        return this.cleanupTaskId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static BungeePerms getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return logger;
    }

    static {
        logger = Logger.getLogger(CHANNEL);
    }
}

