/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.alpenblock.bungeeperms.BPConfig;
import net.alpenblock.bungeeperms.BPPermission;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.ChatColor;
import net.alpenblock.bungeeperms.Color;
import net.alpenblock.bungeeperms.Group;
import net.alpenblock.bungeeperms.HelpProvider;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.Messages;
import net.alpenblock.bungeeperms.Permable;
import net.alpenblock.bungeeperms.PermissionsChecker;
import net.alpenblock.bungeeperms.PermissionsManager;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.User;
import net.alpenblock.bungeeperms.World;
import net.alpenblock.bungeeperms.io.BackEndType;
import net.alpenblock.bungeeperms.io.UUIDPlayerDBType;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.Sender;
import net.alpenblock.bungeeperms.uuid.UUIDFetcher;

public class CommandHandler {
    protected PlatformPlugin plugin;
    protected PermissionsChecker checker;
    protected BPConfig config;

    public boolean onCommand(Sender sender, String cmd, String label, String[] args) {
        if (!cmd.equalsIgnoreCase("bungeeperms")) {
            return false;
        }
        if (BungeePerms.getInstance().getConfig().isDebug()) {
            BungeePerms.getInstance().getPlugin().getLogger().info(sender.getName() + " issued bungeeperms command /" + cmd + " " + Statics.arrayToString(args, 0, args.length, " "));
        }
        if (args.length == 0) {
            sender.sendMessage(Lang.translate(Lang.MessageType.BUNGEEPERMS, new Object[0]));
            sender.sendMessage(Lang.translate(Lang.MessageType.VERSION, this.plugin.getVersion()));
            sender.sendMessage(Lang.translate(Lang.MessageType.AUTHOR, this.plugin.getAuthor()));
            return true;
        }
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                return this.handleHelp(sender, args);
            }
            if (args[0].equalsIgnoreCase("reload")) {
                return this.handleReload(sender, args);
            }
            if (args[0].equalsIgnoreCase("debug")) {
                return this.handleDebug(sender, args);
            }
            if (args[0].equalsIgnoreCase("users")) {
                return this.handleUsers(sender, args);
            }
            if (args[0].equalsIgnoreCase("user")) {
                return this.handleUserCommands(sender, args);
            }
            if (args[0].equalsIgnoreCase("groups")) {
                return this.handleGroups(sender, args);
            }
            if (args[0].equalsIgnoreCase("group")) {
                return this.handleGroupCommands(sender, args);
            }
            if (args[0].equalsIgnoreCase("promote")) {
                return this.handlePromote(sender, args);
            }
            if (args[0].equalsIgnoreCase("demote")) {
                return this.handleDemote(sender, args);
            }
            if (args[0].equalsIgnoreCase("format")) {
                return this.handleFormat(sender, args);
            }
            if (args[0].equalsIgnoreCase("cleanup")) {
                return this.handleCleanup(sender, args);
            }
            if (args[0].equalsIgnoreCase("migrate")) {
                return this.handleMigrate(sender, args);
            }
            if (args[0].equalsIgnoreCase("uuid")) {
                return this.handleUUID(sender, args);
            }
        }
        return false;
    }

    private boolean handleHelp(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.help", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 1, 2)) {
            return true;
        }
        int page = 1;
        if (args.length == 2) {
            try {
                page = Integer.parseInt(args[1]);
                if (page < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_INT_VALUE, new Object[0]));
                return true;
            }
        }
        HelpProvider.sendHelpPage(sender, --page);
        return true;
    }

    private boolean handleReload(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.reload", true)) {
            return true;
        }
        BungeePerms.getInstance().reload(true);
        sender.sendMessage(Lang.translate(Lang.MessageType.PERMISSIONS_RELOADED, new Object[0]));
        return true;
    }

    private boolean handleDebug(Sender sender, String[] args) {
        boolean val;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.debug", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 2)) {
            return true;
        }
        try {
            val = this.parseTrueFalse(args[1]);
        }
        catch (Exception e) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_BOOL_VALUE, new Object[0]));
            return true;
        }
        if (val) {
            this.config.setDebug(true);
            sender.sendMessage(Lang.translate(Lang.MessageType.DEBUG_ENABLED, new Object[0]));
            return true;
        }
        this.config.setDebug(false);
        sender.sendMessage(Lang.translate(Lang.MessageType.DEBUG_DISABLED, new Object[0]));
        return true;
    }

    private boolean handleUsers(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.users.list", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 1, 2)) {
            return true;
        }
        List<String> users = this.pm().getRegisteredUsers();
        if (users.isEmpty()) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_USERS_FOUND, new Object[0]));
            return true;
        }
        if (args.length == 1) {
            String out = Lang.translate(Lang.MessageType.REGISTERED_USERS, new Object[0]);
            for (int i = 0; i < users.size(); ++i) {
                out = out + (Object)((Object)Color.User) + users.get(i) + (Object)((Object)Color.Text) + (i + 1 < users.size() ? ", " : "");
            }
            sender.sendMessage(out);
            return true;
        }
        if (!args[1].equalsIgnoreCase("-c")) {
            return false;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.REGISTERED_USERS_COUNT, this.pm().getRegisteredUsers().size()));
        return true;
    }

    private boolean handleUserCommands(Sender sender, String[] args) {
        if (args.length < 3) {
            Messages.sendTooLessArgsMessage(sender);
            return true;
        }
        if (args[2].equalsIgnoreCase("list")) {
            return this.handleUserCommandsList(sender, args);
        }
        if (args[2].equalsIgnoreCase("groups")) {
            return this.handleUserCommandsGroups(sender, args);
        }
        if (args[2].equalsIgnoreCase("info")) {
            return this.handleUserCommandsInfo(sender, args);
        }
        if (args[2].equalsIgnoreCase("delete")) {
            return this.handleUserCommandsDelete(sender, args);
        }
        if (Statics.argAlias(args[2], "add", "addperm", "addpermission")) {
            return this.handleUserCommandsPermAdd(sender, args);
        }
        if (Statics.argAlias(args[2], "remove", "removeperm", "removepermission")) {
            return this.handleUserCommandsPermRemove(sender, args);
        }
        if (Statics.argAlias(args[2], "has", "check")) {
            return this.handleUserCommandsHas(sender, args);
        }
        if (args[2].equalsIgnoreCase("addgroup")) {
            return this.handleUserCommandsGroupAdd(sender, args);
        }
        if (args[2].equalsIgnoreCase("removegroup")) {
            return this.handleUserCommandsGroupRemove(sender, args);
        }
        if (args[2].equalsIgnoreCase("setgroup")) {
            return this.handleUserCommandsGroupSet(sender, args);
        }
        if (args[2].equalsIgnoreCase("display")) {
            return this.handleUserCommandsDisplay(sender, args);
        }
        if (args[2].equalsIgnoreCase("prefix")) {
            return this.handleUserCommandsPrefix(sender, args);
        }
        if (args[2].equalsIgnoreCase("suffix")) {
            return this.handleUserCommandsSuffix(sender, args);
        }
        if (Statics.argAlias(args[2], "group", "perm", "permission")) {
            if (!Statics.matchArgs(sender, args, 5)) {
                return true;
            }
            String[] newargs = new String[]{args[0], args[1], args[3] + args[2], args[4]};
            return this.onCommand(sender, "bungeeperms", "bp", newargs);
        }
        return false;
    }

    private boolean handleUserCommandsList(Sender sender, String[] args) {
        int page;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.perms.list", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        boolean specialpage = args.length > 3 && Statics.isInt(args[args.length - 1]);
        int n = page = specialpage ? Integer.parseInt(args[args.length - 1]) : 1;
        if (page < 1) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_INT_VALUE, new Object[0]));
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String server = args.length > 3 + (specialpage ? 1 : 0) ? args[3].toLowerCase() : null;
        String world = args.length > 4 + (specialpage ? 1 : 0) ? args[4].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        if (this.config.isUseUUIDs()) {
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_PERMISSIONS_LIST_HEADER_UUID, user.getName(), user.getUUID()));
        } else {
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_PERMISSIONS_LIST_HEADER, user.getName()));
        }
        List<BPPermission> perms = user.getPermsWithOrigin(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.PERMISSIONS_LIST_HEADER_PAGE, page, perms.size() / 20 + (perms.size() % 20 > 0 ? 1 : 0)));
        for (int i = (page - 1) * 20; i < page * 20 && i < perms.size(); ++i) {
            BPPermission perm = perms.get(i);
            sender.sendMessage(Lang.translate(Lang.MessageType.PERMISSIONS_LIST_ITEM, perm.getPermission(), !perm.isGroup() && perm.getOrigin().equalsIgnoreCase(player) ? Lang.translate(Lang.MessageType.OWN, new Object[0]) : perm.getOrigin(), perm.getServer() != null ? " | " + (Object)((Object)Color.Value) + perm.getServer() + (Object)((Object)Color.Text) : "", perm.getWorld() != null ? " | " + (Object)((Object)Color.Value) + perm.getWorld() + (Object)((Object)Color.Text) : ""));
        }
        return true;
    }

    private boolean handleUserCommandsGroups(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.groups", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_GROUPS_HEADER, user.getName()));
        for (Group g : user.getGroups()) {
            sender.sendMessage((Object)((Object)Color.Text) + "- " + (Object)((Object)Color.Value) + g.getName());
        }
        return true;
    }

    private boolean handleUserCommandsInfo(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.info", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 5)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String server = args.length > 3 ? args[3].toLowerCase() : null;
        String world = args.length > 4 ? args[4].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_ABOUT, user.getName()));
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_UUID, user.getUUID()));
        String groups = "";
        for (int i = 0; i < user.getGroups().size(); ++i) {
            groups = groups + (Object)((Object)Color.Value) + user.getGroups().get(i).getName() + (Object)((Object)Color.Text) + " (" + (Object)((Object)Color.Value) + user.getGroups().get(i).getPerms().size() + (Object)((Object)Color.Text) + ")" + (i + 1 < user.getGroups().size() ? ", " : "");
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_GROUPS, groups));
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_PERMISSIONS, user.getOwnPermissionsCount(server, world)));
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_ALL_PERMISSIONS_COUNT, user.getPermissionsCount(server, world)));
        Permable perm = user;
        if (server != null) {
            perm = ((User)perm).getServer(server);
            if (world != null) {
                perm = ((Server)perm).getWorld(world);
            }
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.DISPLAY, !Statics.isEmpty(perm.getDisplay()) ? perm.getDisplay() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        sender.sendMessage(Lang.translate(Lang.MessageType.PREFIX, !Statics.isEmpty(perm.getPrefix()) ? perm.getPrefix() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        sender.sendMessage(Lang.translate(Lang.MessageType.SUFFIX, !Statics.isEmpty(perm.getSuffix()) ? perm.getSuffix() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        String buildPrefix = user.buildPrefix(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.PREFIX_FULL, !Statics.isEmpty(buildPrefix) ? buildPrefix : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        String buildSuffix = user.buildSuffix(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.SUFFIX_FULL, !Statics.isEmpty(buildSuffix) ? buildSuffix : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        return true;
    }

    private boolean handleUserCommandsDelete(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.delete", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        this.pm().deleteUser(user);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_DELETED, new Object[0]));
        return true;
    }

    private boolean handleUserCommandsPermAdd(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.perms.add", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        if (server == null) {
            if (user.getExtraPerms().contains("-" + perm)) {
                this.pm().removeUserPerm(user, "-" + perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM, perm, user.getName()));
            } else if (!user.getExtraPerms().contains(perm)) {
                this.pm().addUserPerm(user, perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM, perm, user.getName()));
            } else {
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_ALREADY_HAS_PERM, user.getName(), perm));
            }
        } else {
            Server srv = user.getServer(server);
            if (world == null) {
                if (srv.getPerms().contains("-" + perm)) {
                    this.pm().removeUserPerServerPerm(user, server, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM_SERVER, perm, user.getName(), server));
                } else if (!srv.getPerms().contains(perm)) {
                    this.pm().addUserPerServerPerm(user, server, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM_SERVER, perm, user.getName(), server));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ALREADY_HAS_PERM_SERVER, user.getName(), perm, server));
                }
            } else {
                World w = srv.getWorld(world);
                if (w.getPerms().contains("-" + perm)) {
                    this.pm().removeUserPerServerWorldPerm(user, server, world, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM_SERVER_WORLD, perm, user.getName(), server, world));
                } else if (!w.getPerms().contains(perm)) {
                    this.pm().addUserPerServerWorldPerm(user, server, world, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_PERM_SERVER_WORLD, perm, user.getName(), server, world));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_ALREADY_HAS_PERM_SERVER_WORLD, user.getName(), perm, server, world));
                }
            }
        }
        return true;
    }

    private boolean handleUserCommandsPermRemove(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.perms.remove", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        if (server == null) {
            if (user.getExtraPerms().contains(perm)) {
                this.pm().removeUserPerm(user, perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM, perm, user.getName()));
            } else if (!user.getExtraPerms().contains("-" + perm)) {
                this.pm().addUserPerm(user, "-" + perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM, perm, user.getName()));
            } else {
                sender.sendMessage(Lang.translate(Lang.MessageType.USER_NEVER_HAD_PERM, user.getName(), perm));
            }
        } else {
            Server srv = user.getServer(server);
            if (world == null) {
                if (srv.getPerms().contains(perm)) {
                    this.pm().removeUserPerServerPerm(user, server, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM_SERVER, perm, user.getName(), server));
                } else if (!srv.getPerms().contains("-" + perm)) {
                    this.pm().addUserPerServerPerm(user, server, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM_SERVER, perm, user.getName(), server));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_NEVER_HAD_PERM_SERVER, user.getName(), perm, server));
                }
            } else {
                World w = srv.getWorld(world);
                if (w.getPerms().contains(perm)) {
                    this.pm().removeUserPerServerWorldPerm(user, server, world, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM_SERVER_WORLD, perm, user.getName(), server, world));
                } else if (!w.getPerms().contains("-" + perm)) {
                    this.pm().addUserPerServerWorldPerm(user, server, world, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_PERM_SERVER_WORLD, perm, user.getName(), server, world));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.USER_NEVER_HAD_PERM_SERVER_WORLD, user.getName(), perm, server, world));
                }
            }
        }
        return true;
    }

    private boolean handleUserCommandsHas(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.perms.has", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        if (server == null) {
            boolean has = this.checker.hasPerm(player, perm.toLowerCase());
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_HAS_PERM, user.getName(), perm, this.formatBool(has)));
        } else if (world == null) {
            boolean has = this.checker.hasPermOnServer(user.getName(), perm.toLowerCase(), server);
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_HAS_PERM_SERVER, user.getName(), perm, server, this.formatBool(has)));
        } else {
            boolean has = this.checker.hasPermOnServerInWorld(user.getName(), perm.toLowerCase(), server, world);
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_HAS_PERM_SERVER_WORLD, user.getName(), perm, server, world, this.formatBool(has)));
        }
        return true;
    }

    private boolean handleUserCommandsGroupAdd(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.group.add", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String groupname = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        User u = this.pm().getUser(player);
        if (u == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        List<Group> groups = u.getGroups();
        for (Group g : groups) {
            if (!g.getName().equalsIgnoreCase(group.getName())) continue;
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_ALREADY_IN_GROUP, groupname));
            return true;
        }
        this.pm().addUserGroup(u, group);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_ADDED_GROUP, groupname, u.getName()));
        return true;
    }

    private boolean handleUserCommandsGroupRemove(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.group.remove", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String groupname = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        User u = this.pm().getUser(player);
        if (u == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        List<Group> groups = u.getGroups();
        for (Group g : groups) {
            if (!g.getName().equalsIgnoreCase(group.getName())) continue;
            this.pm().removeUserGroup(u, group);
            sender.sendMessage(Lang.translate(Lang.MessageType.USER_REMOVED_GROUP, groupname, u.getName()));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_IN_GROUP, groupname));
        return true;
    }

    private boolean handleUserCommandsGroupSet(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.group.set", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String groupname = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        User u = this.pm().getUser(player);
        if (u == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        List<Group> laddergroups = this.pm().getLadderGroups(group.getLadder());
        for (Group g : laddergroups) {
            this.pm().removeUserGroup(u, g);
        }
        this.pm().addUserGroup(u, group);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_SET_GROUP, groupname, u.getName()));
        return true;
    }

    private boolean handleUserCommandsDisplay(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.display", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String display = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        this.pm().setUserDisplay(user, display, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_SET_DISPLAY, user.getName()));
        return true;
    }

    private boolean handleUserCommandsPrefix(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.prefix", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String prefix = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        this.pm().setUserPrefix(user, prefix, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_SET_PREFIX, user.getName()));
        return true;
    }

    private boolean handleUserCommandsSuffix(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.user.suffix", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        String suffix = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        this.pm().setUserSuffix(user, suffix, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.USER_SET_SUFFIX, user.getName()));
        return true;
    }

    private boolean handleGroups(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.groups", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 1)) {
            return true;
        }
        if (this.pm().getGroups().isEmpty()) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_GROUPS_FOUND, new Object[0]));
        } else {
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUPS_LIST_HEADER, new Object[0]));
            for (String l : this.pm().getLadders()) {
                for (Group g : this.pm().getLadderGroups(l)) {
                    sender.sendMessage((Object)((Object)Color.Text) + "- " + (Object)((Object)Color.Value) + g.getName() + (Object)((Object)Color.Text) + " (" + (Object)((Object)Color.Value) + l + (Object)((Object)Color.Text) + ")");
                }
            }
        }
        return true;
    }

    private boolean handleGroupCommands(Sender sender, String[] args) {
        if (args.length < 3) {
            Messages.sendTooLessArgsMessage(sender);
            return true;
        }
        if (args[2].equalsIgnoreCase("list")) {
            return this.handleGroupCommandsList(sender, args);
        }
        if (args[2].equalsIgnoreCase("info")) {
            return this.handleGroupCommandsInfo(sender, args);
        }
        if (args[2].equalsIgnoreCase("users")) {
            return this.handleGroupCommandsUsers(sender, args);
        }
        if (args[2].equalsIgnoreCase("create")) {
            return this.handleGroupCommandsCreate(sender, args);
        }
        if (args[2].equalsIgnoreCase("delete")) {
            return this.handleGroupCommandsDelete(sender, args);
        }
        if (Statics.argAlias(args[2], "add", "addperm", "addpermission")) {
            return this.handleGroupCommandsPermAdd(sender, args);
        }
        if (Statics.argAlias(args[2], "remove", "removeperm", "removepermission")) {
            return this.handleGroupCommandsPermRemove(sender, args);
        }
        if (Statics.argAlias(args[2], "has", "check")) {
            return this.handleGroupCommandsHas(sender, args);
        }
        if (Statics.argAlias(args[2], "addinherit", "addinheritance")) {
            return this.handleGroupCommandsInheritAdd(sender, args);
        }
        if (Statics.argAlias(args[2], "removeinherit", "removeinheritance")) {
            return this.handleGroupCommandsInheritRemove(sender, args);
        }
        if (args[2].equalsIgnoreCase("rank")) {
            return this.handleGroupCommandsRank(sender, args);
        }
        if (args[2].equalsIgnoreCase("weight")) {
            return this.handleGroupCommandsWeight(sender, args);
        }
        if (args[2].equalsIgnoreCase("ladder")) {
            return this.handleGroupCommandsLadder(sender, args);
        }
        if (args[2].equalsIgnoreCase("default")) {
            return this.handleGroupCommandsDefault(sender, args);
        }
        if (args[2].equalsIgnoreCase("display")) {
            return this.handleGroupCommandsDisplay(sender, args);
        }
        if (args[2].equalsIgnoreCase("prefix")) {
            return this.handleGroupCommandsPrefix(sender, args);
        }
        if (args[2].equalsIgnoreCase("suffix")) {
            return this.handleGroupCommandsSuffix(sender, args);
        }
        if (Statics.argAlias(args[2], "perm", "permission")) {
            if (!Statics.matchArgs(sender, args, 5)) {
                return true;
            }
            String[] newargs = new String[]{args[0], args[1], args[3] + args[2], args[4]};
            return this.onCommand(sender, "bungeeperms", "bp", newargs);
        }
        return false;
    }

    private boolean handleGroupCommandsList(Sender sender, String[] args) {
        int page;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.perms.list", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        boolean specialpage = args.length > 3 && Statics.isInt(args[args.length - 1]);
        int n = page = specialpage ? Integer.parseInt(args[args.length - 1]) : 1;
        if (page < 1) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_INT_VALUE, new Object[0]));
            return true;
        }
        String groupname = args[1];
        String server = args.length > 3 + (specialpage ? 1 : 0) ? args[3].toLowerCase() : null;
        String world = args.length > 4 + (specialpage ? 1 : 0) ? args[4].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_PERMISSIONS_LIST_HEADER, group.getName()));
        List<BPPermission> perms = group.getPermsWithOrigin(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.PERMISSIONS_LIST_HEADER_PAGE, page, perms.size() / 20 + (perms.size() % 20 > 0 ? 1 : 0)));
        for (int i = (page - 1) * 20; i < page * 20 && i < perms.size(); ++i) {
            BPPermission perm = perms.get(i);
            sender.sendMessage(Lang.translate(Lang.MessageType.PERMISSIONS_LIST_ITEM, perm.getPermission(), !perm.getOrigin().equalsIgnoreCase(groupname) ? Lang.translate(Lang.MessageType.OWN, new Object[0]) : perm.getOrigin(), perm.getServer() != null ? " | " + (Object)((Object)Color.Value) + perm.getServer() + (Object)((Object)Color.Text) : "", perm.getWorld() != null ? " | " + (Object)((Object)Color.Value) + perm.getWorld() + (Object)((Object)Color.Text) : ""));
        }
        return true;
    }

    private boolean handleGroupCommandsInfo(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.info", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 5)) {
            return true;
        }
        String groupname = args[1];
        String server = args.length > 3 ? args[3].toLowerCase() : null;
        String world = args.length > 4 ? args[4].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ABOUT, group.getName()));
        String inheritances = "";
        for (int i = 0; i < group.getInheritances().size(); ++i) {
            inheritances = inheritances + (Object)((Object)Color.Value) + group.getInheritances().get(i) + (Object)((Object)Color.Text) + " (" + (Object)((Object)Color.Value) + this.pm().getGroup(group.getInheritances().get(i)).getPerms().size() + (Object)((Object)Color.Text) + ")" + (i + 1 < group.getInheritances().size() ? ", " : "");
        }
        if (inheritances.length() == 0) {
            inheritances = (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")";
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_INHERITANCES, inheritances));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_PERMISSONS, group.getOwnPermissionsCount(server, world)));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ALL_PERMISSIONS, group.getPermissionsCount(server, world)));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_RANK, group.getRank()));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_WEIGHT, group.getWeight()));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_LADDER, group.getLadder()));
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_DEFAULT, this.formatBool(group.isDefault())));
        Permable perm = group;
        if (server != null) {
            perm = ((Group)perm).getServer(server);
            if (world != null) {
                perm = ((Server)perm).getWorld(world);
            }
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.DISPLAY, !Statics.isEmpty(perm.getDisplay()) ? perm.getDisplay() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        sender.sendMessage(Lang.translate(Lang.MessageType.PREFIX, !Statics.isEmpty(perm.getPrefix()) ? perm.getPrefix() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        sender.sendMessage(Lang.translate(Lang.MessageType.SUFFIX, !Statics.isEmpty(perm.getSuffix()) ? perm.getSuffix() : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        String buildPrefix = group.buildPrefix(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.PREFIX_FULL, !Statics.isEmpty(buildPrefix) ? buildPrefix : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        String buildSuffix = group.buildSuffix(server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.SUFFIX_FULL, !Statics.isEmpty(buildSuffix) ? buildSuffix : (Object)((Object)Color.Text) + "(" + Lang.translate(Lang.MessageType.NONE, new Object[0]) + ")"));
        return true;
    }

    private boolean handleGroupCommandsUsers(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.users", true)) {
            return true;
        }
        if (args.length > 4) {
            Messages.sendTooManyArgsMessage(sender);
            return true;
        }
        String groupname = args[1];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        List<String> users = this.pm().getGroupUsers(group);
        if (users.isEmpty()) {
            sender.sendMessage(Lang.translate(Lang.MessageType.NO_USERS_FOUND, new Object[0]));
        }
        if (args.length == 3) {
            String out = Lang.translate(Lang.MessageType.GROUP_USERS_HEADER, group.getName());
            for (int i = 0; i < users.size(); ++i) {
                out = out + (Object)((Object)Color.User) + users.get(i) + (Object)((Object)Color.Text) + (i + 1 < users.size() ? ", " : "");
            }
            sender.sendMessage(out);
            return true;
        }
        if (args.length == 4) {
            if (!args[3].equalsIgnoreCase("-c")) {
                return false;
            }
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_USERS_HEADER, users.size(), group.getName()));
            return true;
        }
        return true;
    }

    private boolean handleGroupCommandsCreate(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.create", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3)) {
            return true;
        }
        String groupname = args[1];
        if (this.pm().getGroup(groupname) != null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        Group group = new Group(groupname, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, Server>(), 1000, 1000, "default", false, null, null, null);
        this.pm().addGroup(group);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_CREATED, groupname));
        return true;
    }

    private boolean handleGroupCommandsDelete(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.delete", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3)) {
            return true;
        }
        String groupname = args[1];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_DELETION_IN_PROGRESS, new Object[0]));
        this.pm().deleteGroup(group);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_DELETED, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsPermAdd(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.perms.add", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String groupname = args[1];
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        if (server == null) {
            if (group.getPerms().contains("-" + perm)) {
                this.pm().removeGroupPerm(group, "-" + perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM, perm, group.getName()));
            } else if (!group.getPerms().contains(perm)) {
                this.pm().addGroupPerm(group, perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM, perm, group.getName()));
            } else {
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ALREADY_HAS_PERM, group.getName(), perm));
            }
        } else {
            Server srv = group.getServer(server);
            if (world == null) {
                List<String> perserverperms = srv.getPerms();
                if (perserverperms.contains("-" + perm)) {
                    this.pm().removeGroupPerServerPerm(group, server, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM_SERVER, perm, group.getName(), server));
                } else if (!perserverperms.contains(perm)) {
                    this.pm().addGroupPerServerPerm(group, server, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM_SERVER, perm, group.getName(), server));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ALREADY_HAS_PERM_SERVER, group.getName(), perm, server));
                }
            } else {
                World w = srv.getWorld(world);
                List<String> perserverworldperms = w.getPerms();
                if (perserverworldperms.contains("-" + perm)) {
                    this.pm().removeGroupPerServerWorldPerm(group, server, world, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM_SERVER_WORLD, perm, group.getName(), server, world));
                } else if (!perserverworldperms.contains(perm)) {
                    this.pm().addGroupPerServerWorldPerm(group, server, world, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_PERM_SERVER_WORLD, perm, group.getName(), server, world));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ALREADY_HAS_PERM_SERVER_WORLD, group.getName(), perm, server, world));
                }
            }
        }
        return true;
    }

    private boolean handleGroupCommandsPermRemove(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.perms.remove", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String groupname = args[1];
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        if (server == null) {
            if (group.getPerms().contains(perm)) {
                this.pm().removeGroupPerm(group, perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM, perm, group.getName()));
            } else if (!group.getPerms().contains("-" + perm)) {
                this.pm().addGroupPerm(group, "-" + perm);
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM, perm, group.getName()));
            } else {
                sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_NEVER_HAD_PERM, group.getName(), perm));
            }
        } else {
            Server srv = group.getServer(server);
            if (world == null) {
                List<String> perserverperms = srv.getPerms();
                if (perserverperms.contains(perm)) {
                    this.pm().removeGroupPerServerPerm(group, server, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM_SERVER, perm, group.getName(), server));
                } else if (!perserverperms.contains("-" + perm)) {
                    this.pm().addGroupPerServerPerm(group, server, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM_SERVER, perm, group.getName(), server));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_NEVER_HAD_PERM_SERVER, group.getName(), perm, server));
                }
            } else {
                World w = srv.getWorld(world);
                List<String> perserverworldperms = w.getPerms();
                if (perserverworldperms.contains(perm)) {
                    this.pm().removeGroupPerServerWorldPerm(group, server, world, perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM_SERVER_WORLD, perm, group.getName(), server, world));
                } else if (!perserverworldperms.contains("-" + perm)) {
                    this.pm().addGroupPerServerWorldPerm(group, server, world, "-" + perm);
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_PERM_SERVER_WORLD, perm, group.getName(), server, world));
                } else {
                    sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_NEVER_HAD_PERM_SERVER_WORLD, group.getName(), perm, server, world));
                }
            }
        }
        return true;
    }

    private boolean handleGroupCommandsHas(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.perms.has", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4, 6)) {
            return true;
        }
        String groupname = args[1];
        String perm = args[3].toLowerCase();
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        if (server == null) {
            boolean has = group.has(perm.toLowerCase());
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_HAS_PERM, group.getName(), perm, this.formatBool(has)));
        } else if (world == null) {
            boolean has = group.hasOnServer(perm.toLowerCase(), server);
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_HAS_PERM_SERVER, group.getName(), perm, server, this.formatBool(has)));
        } else {
            boolean has = group.hasOnServerInWorld(perm.toLowerCase(), server, world);
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_HAS_PERM_SERVER_WORLD, group.getName(), perm, server, world, this.formatBool(has)));
        }
        return true;
    }

    private boolean handleGroupCommandsInheritAdd(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.inheritances.add", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        String addgroup = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        Group toadd = this.pm().getGroup(addgroup);
        if (toadd == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, addgroup));
            return true;
        }
        List<String> inheritances = group.getInheritances();
        for (String s : inheritances) {
            if (!s.equalsIgnoreCase(toadd.getName())) continue;
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_ALREADY_INHERITS, groupname, addgroup));
            return true;
        }
        this.pm().addGroupInheritance(group, toadd);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_ADDED_INHERITANCE, addgroup, groupname));
        return true;
    }

    private boolean handleGroupCommandsInheritRemove(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.inheritances.remove", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        String removegroup = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        Group toremove = this.pm().getGroup(removegroup);
        if (toremove == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, removegroup));
            return true;
        }
        List<String> inheritances = group.getInheritances();
        for (String s : inheritances) {
            if (!s.equalsIgnoreCase(toremove.getName())) continue;
            this.pm().removeGroupInheritance(group, toremove);
            sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_REMOVED_INHERITANCE, removegroup, groupname));
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_ALREADY_INHERITS, groupname, removegroup));
        return true;
    }

    private boolean handleGroupCommandsRank(Sender sender, String[] args) {
        int rank;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.rank", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        try {
            rank = Integer.parseInt(args[3]);
            if (rank < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_INT_VALUE, new Object[0]));
            return true;
        }
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().rankGroup(group, rank);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_RANK, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsWeight(Sender sender, String[] args) {
        int weight;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.weight", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        try {
            weight = Integer.parseInt(args[3]);
            if (weight < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_INT_VALUE, new Object[0]));
            return true;
        }
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().weightGroup(group, weight);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_WEIGHT, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsLadder(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.ladder", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        String ladder = args[3];
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().ladderGroup(group, ladder);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_LADDER, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsDefault(Sender sender, String[] args) {
        boolean isdefault;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.default", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 4)) {
            return true;
        }
        String groupname = args[1];
        try {
            isdefault = this.parseTrueFalse(args[3]);
        }
        catch (Exception e) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_INVALID_BOOL_VALUE, new Object[0]));
            return true;
        }
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().setGroupDefault(group, isdefault);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_DEFAULT, group.getName(), isdefault ? Lang.translate(Lang.MessageType.DEFAULT, new Object[0]) : Lang.translate(Lang.MessageType.NONDEFAULT, new Object[0])));
        return true;
    }

    private boolean handleGroupCommandsDisplay(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.display", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String groupname = args[1];
        String display = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().setGroupDisplay(group, display, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_DISPLAY, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsPrefix(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.prefix", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String groupname = args[1];
        String prefix = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().setGroupPrefix(group, prefix, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_PREFIX, group.getName()));
        return true;
    }

    private boolean handleGroupCommandsSuffix(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.group.suffix", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 3, 6)) {
            return true;
        }
        String groupname = args[1];
        String suffix = args.length > 3 ? args[3] : null;
        String server = args.length > 4 ? args[4].toLowerCase() : null;
        String world = args.length > 5 ? args[5].toLowerCase() : null;
        Group group = this.pm().getGroup(groupname);
        if (group == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_GROUP_NOT_EXISTING, groupname));
            return true;
        }
        this.pm().setGroupSuffix(group, suffix, server, world);
        sender.sendMessage(Lang.translate(Lang.MessageType.GROUP_SET_SUFFIX, group.getName()));
        return true;
    }

    private boolean handlePromote(Sender sender, String[] args) {
        Sender s;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.promote", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 2, 3)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        Group playergroup = null;
        Group nextgroup = null;
        if (args.length == 3) {
            String ladder = args[2];
            playergroup = user.getGroupByLadder(ladder);
            if (playergroup != null) {
                nextgroup = this.pm().getNextGroup(playergroup);
            } else {
                List<Group> laddergroups = this.pm().getLadderGroups(ladder);
                if (!laddergroups.isEmpty()) {
                    nextgroup = laddergroups.get(0);
                }
            }
        } else {
            playergroup = this.pm().getMainGroup(user);
            if (playergroup == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NO_GROUPS, user.getName()));
                return true;
            }
            nextgroup = this.pm().getNextGroup(playergroup);
        }
        if (nextgroup == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_CANNOT_BE_PROMOTED, user.getName()));
            return true;
        }
        if (!this.checker.hasOrConsole(sender, "bungeeperms.promote." + nextgroup.getName(), true)) {
            return true;
        }
        if (sender.isPlayer()) {
            User issuer = this.pm().getUser(sender.getName());
            if (issuer == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_NOT_EXISTING, new Object[0]));
                return true;
            }
            Group issuergroup = this.pm().getMainGroup(issuer);
            if (issuergroup == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_NO_GROUPS, new Object[0]));
                return true;
            }
            if (issuergroup.getRank() >= nextgroup.getRank()) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_CANNOT_PROMOTE, user.getName()));
                return true;
            }
        }
        if (playergroup != null) {
            this.pm().removeUserGroup(user, playergroup);
        }
        this.pm().addUserGroup(user, nextgroup);
        sender.sendMessage(Lang.translate(Lang.MessageType.PROMOTE_MESSAGE, user.getName(), nextgroup.getName()));
        if (this.config.isNotifyPromote() && (s = this.plugin.getPlayer(user.getName())) != null) {
            s.sendMessage(Lang.translate(Lang.MessageType.PROMOTE_MESSAGE_TO_USER, nextgroup.getName()));
        }
        return true;
    }

    private boolean handleDemote(Sender sender, String[] args) {
        Sender s;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.demote", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 2, 3)) {
            return true;
        }
        String player = Statics.getFullPlayerName(args[1]);
        User user = this.pm().getUser(player);
        if (user == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NOT_EXISTING, player));
            return true;
        }
        Group playergroup = null;
        Group previousgroup = null;
        if (args.length == 3) {
            String ladder = args[2];
            playergroup = user.getGroupByLadder(ladder);
            if (playergroup != null) {
                previousgroup = this.pm().getPreviousGroup(playergroup);
            }
        } else {
            playergroup = this.pm().getMainGroup(user);
            if (playergroup == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_NO_GROUPS, user.getName()));
                return true;
            }
            previousgroup = this.pm().getPreviousGroup(playergroup);
        }
        if (previousgroup == null) {
            sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_CANNOT_BE_DEMOTED, user.getName()));
            return true;
        }
        if (!this.checker.hasOrConsole(sender, "bungeeperms.demote." + previousgroup.getName(), true)) {
            return true;
        }
        if (sender.isPlayer()) {
            User issuer = this.pm().getUser(sender.getName());
            if (issuer == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_NOT_EXISTING, new Object[0]));
                return true;
            }
            Group issuergroup = this.pm().getMainGroup(issuer);
            if (issuergroup == null) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_NO_GROUPS, new Object[0]));
                return true;
            }
            if (issuergroup.getRank() >= playergroup.getRank()) {
                sender.sendMessage(Lang.translate(Lang.MessageType.ERR_USER_YOU_CANNOT_DEMOTE, user.getName()));
                return true;
            }
        }
        if (playergroup != null) {
            this.pm().removeUserGroup(user, playergroup);
        }
        this.pm().addUserGroup(user, previousgroup);
        sender.sendMessage(Lang.translate(Lang.MessageType.DEMOTE_MESSAGE, user.getName(), previousgroup.getName()));
        if (this.config.isNotifyDemote() && (s = this.plugin.getPlayer(user.getName())) != null) {
            s.sendMessage(Lang.translate(Lang.MessageType.DEMOTE_MESSAGE_TO_USER, previousgroup.getName()));
        }
        return true;
    }

    private boolean handleFormat(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.format", true)) {
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.FORMATTING, new Object[0]));
        this.pm().format();
        sender.sendMessage(Lang.translate(Lang.MessageType.FORMATTING_DONE, new Object[0]));
        return true;
    }

    private boolean handleCleanup(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.cleanup", true)) {
            return true;
        }
        sender.sendMessage(Lang.translate(Lang.MessageType.CLEANING, new Object[0]));
        sender.sendMessage((Object)((Object)Color.Text) + "Cleaning up permissions file/table ...");
        int deleted = this.pm().cleanup();
        sender.sendMessage(Lang.translate(Lang.MessageType.CLEANING_DONE, deleted));
        sender.sendMessage((Object)((Object)Color.Message) + "Finished cleaning. Deleted " + (Object)((Object)Color.Value) + deleted + " users" + (Object)((Object)Color.Message) + ".");
        return true;
    }

    private boolean handleMigrate(Sender sender, String[] args) {
        if (!this.checker.hasOrConsole(sender, "bungeeperms.migrate", true)) {
            return true;
        }
        if (args.length < 2) {
            Messages.sendTooLessArgsMessage(sender);
            return true;
        }
        String migratetype = args[1];
        if (migratetype.equalsIgnoreCase("backend")) {
            return this.handleMigrateBackend(sender, args);
        }
        if (migratetype.equalsIgnoreCase("useuuid")) {
            return this.handleMigrateUseUUID(sender, args);
        }
        if (migratetype.equalsIgnoreCase("uuidplayerdb")) {
            return this.handleMigrateUUIDPlayerDB(sender, args);
        }
        return false;
    }

    private boolean handleMigrateBackend(Sender sender, String[] args) {
        if (args.length == 2) {
            sender.sendMessage((Object)((Object)Color.Text) + "Currently using " + (Object)((Object)Color.Value) + this.pm().getBackEnd().getType().name() + (Object)((Object)Color.Text) + " as backend");
            if (this.pm().getBackEnd().getType() == BackEndType.MySQL) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The MySQL backend is deprecated! Please consider to use MySQL2.");
            }
        } else if (args.length == 3) {
            String stype = args[2];
            BackEndType type = BackEndType.getByName(stype);
            if (type == null) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid backend type! " + (Object)((Object)Color.Value) + BackEndType.YAML.name() + (Object)((Object)Color.Error) + " or " + (Object)((Object)Color.Value) + BackEndType.MySQL2.name() + (Object)((Object)Color.Error) + " is required!");
                return true;
            }
            if (type == BackEndType.MySQL) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The MySQL backend is deprecated! Please use MySQL2.");
                return true;
            }
            if (type == this.pm().getBackEnd().getType()) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid backend type! You can't migrate to same type!");
                return true;
            }
            sender.sendMessage((Object)((Object)Color.Text) + "Migrating permissions to " + (Object)((Object)Color.Value) + type.name() + (Object)((Object)Color.Text) + " ...");
            this.pm().migrateBackEnd(type);
            sender.sendMessage((Object)((Object)Color.Message) + "Finished migration.");
        } else {
            Messages.sendTooManyArgsMessage(sender);
        }
        return true;
    }

    private boolean handleMigrateUseUUID(Sender sender, String[] args) {
        if (args.length == 2) {
            sender.sendMessage((Object)((Object)Color.Text) + "Currently using " + (Object)((Object)Color.Value) + (this.config.isUseUUIDs() ? "UUIDs" : "player names") + (Object)((Object)Color.Text) + " for player identification");
        } else if (args.length == 3) {
            String stype = args[2];
            Boolean type = null;
            try {
                type = this.parseTrueFalse(stype);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid use-uuid type! " + (Object)((Object)Color.Value) + "true" + (Object)((Object)Color.Error) + " or " + (Object)((Object)Color.Value) + "false" + (Object)((Object)Color.Error) + " is required!");
                return true;
            }
            if (type.booleanValue() == this.config.isUseUUIDs()) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid use-uuid type! You can't migrate to same type!");
                return true;
            }
            if (type.booleanValue()) {
                sender.sendMessage((Object)((Object)Color.Text) + "Migrating permissions using UUIDs for player identification ...");
                sender.sendMessage((Object)((Object)Color.Text) + "Fetching UUIDs ...");
                UUIDFetcher fetcher = new UUIDFetcher(this.pm().getBackEnd().getRegisteredUsers(), this.config.getFetcherCooldown());
                fetcher.fetchUUIDs();
                Map<String, UUID> uuids = fetcher.getUUIDs();
                sender.sendMessage((Object)((Object)Color.Message) + "Finished fetching.");
                sender.sendMessage((Object)((Object)Color.Text) + "Migrating player identification ...");
                this.pm().migrateUseUUID(uuids);
                sender.sendMessage((Object)((Object)Color.Message) + "Finished player identification migration.");
                sender.sendMessage((Object)((Object)Color.Text) + "Applying fetched data to player-uuid-database ...");
                for (Map.Entry<String, UUID> e : uuids.entrySet()) {
                    this.pm().getUUIDPlayerDB().update(e.getValue(), e.getKey());
                }
                sender.sendMessage((Object)((Object)Color.Message) + "Finished applying of fetched data to player-uuid-database.");
            } else {
                sender.sendMessage((Object)((Object)Color.Text) + "Migrating permissions using player names for player identification ...");
                sender.sendMessage((Object)((Object)Color.Text) + "Fetching " + (type != false ? "UUIDs" : "player names") + " ...");
                UUIDFetcher fetcher = new UUIDFetcher(this.pm().getBackEnd().getRegisteredUsers(), this.config.getFetcherCooldown());
                fetcher.fetchPlayerNames();
                Map<UUID, String> playernames = fetcher.getPlayerNames();
                sender.sendMessage((Object)((Object)Color.Message) + "Finished fetching.");
                sender.sendMessage((Object)((Object)Color.Text) + "Migrating player identification ...");
                this.pm().migrateUsePlayerNames(playernames);
                sender.sendMessage((Object)((Object)Color.Message) + "Finished player identification migration.");
                sender.sendMessage((Object)((Object)Color.Text) + "Applying fetched data to player-uuid-database ...");
                for (Map.Entry<UUID, String> e : playernames.entrySet()) {
                    this.pm().getUUIDPlayerDB().update(e.getKey(), e.getValue());
                }
                sender.sendMessage((Object)((Object)Color.Message) + "Finished applying of fetched data to player-uuid-database.");
            }
            sender.sendMessage((Object)((Object)Color.Message) + "Finished migration.");
        } else {
            Messages.sendTooManyArgsMessage(sender);
        }
        return true;
    }

    private boolean handleMigrateUUIDPlayerDB(Sender sender, String[] args) {
        if (args.length == 2) {
            sender.sendMessage((Object)((Object)Color.Text) + "Currently using " + (Object)((Object)Color.Value) + this.pm().getUUIDPlayerDB().getType().name() + (Object)((Object)Color.Text) + " as uuid player database");
        } else if (args.length == 3) {
            String stype = args[2];
            UUIDPlayerDBType type = UUIDPlayerDBType.getByName(stype);
            if (type == null) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid backend type! " + (Object)((Object)Color.Value) + UUIDPlayerDBType.None.name() + (Object)((Object)Color.Error) + ", " + (Object)((Object)Color.Value) + UUIDPlayerDBType.YAML.name() + (Object)((Object)Color.Error) + " or " + (Object)((Object)Color.Value) + UUIDPlayerDBType.MySQL.name() + (Object)((Object)Color.Error) + " is required!");
                return true;
            }
            if (type == this.pm().getUUIDPlayerDB().getType()) {
                sender.sendMessage((Object)((Object)Color.Error) + "Invalid uuid-player-database type! You can't migrate to same type!");
                return true;
            }
            sender.sendMessage((Object)((Object)Color.Text) + "Migrating uuid-player-database to " + (Object)((Object)Color.Value) + type.name() + (Object)((Object)Color.Text) + " ...");
            this.pm().migrateUUIDPlayerDB(type);
            sender.sendMessage((Object)((Object)Color.Message) + "Finished migration.");
        } else {
            Messages.sendTooManyArgsMessage(sender);
        }
        return true;
    }

    private boolean handleUUID(Sender sender, String[] args) {
        UUID uuid;
        String name;
        String params;
        if (!this.checker.hasOrConsole(sender, "bungeeperms.uuid", true)) {
            return true;
        }
        if (!Statics.matchArgs(sender, args, 2, 3)) {
            return true;
        }
        boolean reverse = false;
        boolean mojang = false;
        String what = args[1];
        UUID uuidwhat = Statics.parseUUID(what);
        if (args.length > 2 && (params = args[2]).startsWith("-")) {
            reverse = params.contains("r");
            mojang = params.contains("m");
        }
        if (reverse && uuidwhat == null) {
            sender.sendMessage((Object)((Object)Color.Error) + "UUID invalid!");
            return true;
        }
        if (mojang && reverse) {
            name = UUIDFetcher.getPlayerNameFromMojang(uuidwhat);
            if (name == null) {
                sender.sendMessage((Object)((Object)Color.Text) + "Mojang does not know this player.");
            } else {
                sender.sendMessage((Object)((Object)Color.Text) + "Mojang says: Player name of " + (Object)((Object)Color.Value) + uuidwhat + (Object)((Object)Color.Text) + " is " + (Object)((Object)Color.User) + name + (Object)((Object)Color.Text) + ".");
            }
        } else if (mojang && !reverse) {
            uuid = UUIDFetcher.getUUIDFromMojang(what, null);
            if (uuid == null) {
                sender.sendMessage((Object)((Object)Color.Text) + "Mojang does not know this player.");
            } else {
                sender.sendMessage((Object)((Object)Color.Text) + "Mojang says: UUID of " + (Object)((Object)Color.User) + what + (Object)((Object)Color.Text) + " is " + (Object)((Object)Color.Value) + uuid + (Object)((Object)Color.Text) + ".");
            }
        } else if (!mojang && reverse) {
            name = this.pm().getUUIDPlayerDB().getPlayerName(uuidwhat);
            if (name == null) {
                sender.sendMessage((Object)((Object)Color.Text) + "The UUID-player database does not know this player.");
            } else {
                sender.sendMessage((Object)((Object)Color.Text) + "The UUID-player database says: Player name of " + (Object)((Object)Color.Value) + uuidwhat + (Object)((Object)Color.Text) + " is " + (Object)((Object)Color.User) + name + (Object)((Object)Color.Text) + ".");
            }
        } else if (!mojang && !reverse) {
            uuid = this.pm().getUUIDPlayerDB().getUUID(what);
            if (uuid == null) {
                sender.sendMessage((Object)((Object)Color.Text) + "The UUID-player database does not know this player.");
            } else {
                sender.sendMessage((Object)((Object)Color.Text) + "The UUID-player database says: UUID of " + (Object)((Object)Color.User) + what + (Object)((Object)Color.Text) + " is " + (Object)((Object)Color.Value) + uuid + (Object)((Object)Color.Text) + ".");
            }
        }
        return true;
    }

    private PermissionsManager pm() {
        return BungeePerms.getInstance().getPermissionsManager();
    }

    private boolean parseTrueFalse(String truefalse) {
        if (Statics.argAlias(truefalse, "true", "yes", "t", "y", "+")) {
            return true;
        }
        if (Statics.argAlias(truefalse, "false", "no", "f", "n", "-")) {
            return false;
        }
        throw new IllegalArgumentException("truefalse does not represent a boolean value");
    }

    private String formatBool(boolean b) {
        return (Object)((Object)(b ? ChatColor.GREEN : ChatColor.RED)) + String.valueOf(b).toUpperCase();
    }

    @ConstructorProperties(value={"plugin", "checker", "config"})
    public CommandHandler(PlatformPlugin plugin, PermissionsChecker checker, BPConfig config) {
        this.plugin = plugin;
        this.checker = checker;
        this.config = config;
    }
}

