/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.alpenblock.bungeeperms.config.FileConfiguration;
import net.alpenblock.bungeeperms.config.YamlConfiguration;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;

public class Config {
    private boolean allowsave;
    private FileConfiguration fconfig;
    private String path;

    public Config(PlatformPlugin p, String path) {
        this(p.getPluginFolder() + path);
    }

    public Config(String path) {
        this.path = path;
        this.createFile();
        this.fconfig = new YamlConfiguration();
        this.allowsave = false;
    }

    public void load() {
        this.createFile();
        try {
            this.fconfig.load(this.path);
            this.allowsave = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.allowsave = false;
        }
    }

    public void save() {
        this.createFile();
        try {
            if (!this.allowsave) {
                throw new IllegalStateException("config failed to load; save not allowed");
            }
            this.fconfig.save(this.path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createFile() {
        File file = new File(this.path);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getString(String key, String def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getString(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public int getInt(String key, int def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getInt(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public long getLong(String key, long def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getInt(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getBoolean(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public <T extends Enum> T getEnumValue(String key, T def) {
        if (this.fconfig.contains(key)) {
            Enum[] constants;
            String s = this.getString(key, def.name());
            for (Enum constant : constants = (Enum[])def.getDeclaringClass().getEnumConstants()) {
                if (!constant.name().equalsIgnoreCase(s)) continue;
                return (T)constant;
            }
            return def;
        }
        this.load();
        this.fconfig.set(key, def.name());
        this.save();
        return def;
    }

    public List<String> getListString(String key, List<String> def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getStringList(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public double getDouble(String key, double def) {
        if (this.fconfig.contains(key)) {
            return this.fconfig.getDouble(key);
        }
        this.fconfig.set(key, def);
        this.save();
        return def;
    }

    public void setString(String key, String val) {
        this.fconfig.set(key, val);
    }

    public void setStringAndSave(String key, String val) {
        this.fconfig.set(key, val);
        this.save();
    }

    public void setInt(String key, int val) {
        this.fconfig.set(key, val);
    }

    public void setIntAndSave(String key, int val) {
        this.fconfig.set(key, val);
        this.save();
    }

    public void setLong(String key, long val) {
        this.fconfig.set(key, val);
    }

    public void setLongAndSave(String key, long val) {
        this.fconfig.set(key, val);
        this.save();
    }

    public void setBool(String key, boolean val) {
        this.fconfig.set(key, val);
    }

    public void setBoolAndSave(String key, boolean val) {
        this.fconfig.set(key, val);
        this.save();
    }

    public <T extends Enum> void setEnumValue(String key, T val) {
        this.fconfig.set(key, val.name());
    }

    public <T extends Enum> void setEnumAndSave(String key, T val) {
        this.fconfig.set(key, val.name());
        this.save();
    }

    public void setListString(String key, List<String> val) {
        this.fconfig.set(key, val);
    }

    public void setListStringAndSave(String key, List<String> val) {
        this.fconfig.set(key, val);
        this.save();
    }

    public List<String> getSubNodes(String node) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (Object o : this.fconfig.getConfigurationSection(node).getKeys(false).toArray()) {
                ret.add((String)o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void deleteNode(String node) {
        this.fconfig.set(node, null);
        this.save();
    }

    public boolean keyExists(String node) {
        return this.fconfig.contains(node);
    }
}

