/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.Config;
import net.alpenblock.bungeeperms.DebugFormatter;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;

public class Debug {
    private Logger logger;
    private String path;
    private Config config;
    private PlatformPlugin plugin;
    private boolean showexceptions;
    private boolean showlogs;

    public Debug(PlatformPlugin p, Config conf, String loggername) {
        this.plugin = p;
        this.config = conf;
        this.loadconfig();
        File file = new File(this.path);
        try {
            if (!file.isFile() || !file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            this.logger = Logger.getLogger(loggername + "Debug");
            this.logger.setUseParentHandlers(false);
            FileHandler fh = new FileHandler(this.path, true);
            fh.setFormatter(new DebugFormatter());
            this.logger.addHandler(fh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadconfig() {
        this.path = this.config.getString("debug.path", this.plugin.getPluginFolderPath() + "/debug.log");
        this.showexceptions = this.config.getBoolean("debug.showexceptions", true);
        this.showlogs = this.config.getBoolean("debug.showlogs", false);
    }

    public void log(String str) {
        File file = new File(this.path);
        if (!file.isFile()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (str == null) {
            str = "null";
        }
        this.logger.info(str);
        if (this.showlogs) {
            BungeePerms.getLogger().info("[Debug] " + str);
        }
    }

    public void log(Object o) {
        if (o == null) {
            this.log("null");
        } else {
            this.log(o.toString());
        }
    }

    public void log(Exception e) {
        File file = new File(this.path);
        if (!file.isFile()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.logger.log(Level.SEVERE, e.getMessage(), e);
        if (this.showexceptions) {
            e.printStackTrace();
        }
    }
}

