/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.alpenblock.bungeeperms.BPPermission;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.ChatColor;
import net.alpenblock.bungeeperms.PermEntity;
import net.alpenblock.bungeeperms.Server;
import net.alpenblock.bungeeperms.Statics;
import net.alpenblock.bungeeperms.World;

public class Group
implements Comparable<Group>,
PermEntity {
    private Map<String, List<String>> cachedPerms;
    private String name;
    private List<String> inheritances;
    private List<String> perms;
    private Map<String, Server> servers;
    private int rank;
    private int weight;
    private String ladder;
    private boolean isdefault;
    private String display;
    private String prefix;
    private String suffix;

    public Group(String name, List<String> inheritances, List<String> perms, Map<String, Server> servers, int rank, int weight, String ladder, boolean isdefault, String display, String prefix, String suffix) {
        this.name = name;
        this.inheritances = inheritances;
        this.perms = perms;
        this.servers = servers;
        this.rank = rank;
        this.weight = weight;
        this.ladder = ladder;
        this.isdefault = isdefault;
        this.display = display;
        this.prefix = prefix;
        this.suffix = suffix;
        this.cachedPerms = new HashMap<String, List<String>>();
    }

    @Override
    public Server getServer(String name) {
        if ((name = Statics.toLower(name)) == null) {
            return null;
        }
        Server s = this.servers.get(name);
        if (s == null) {
            s = new Server(name, new ArrayList<String>(), new HashMap<String, World>(), null, null, null);
            this.servers.put(name, s);
        }
        return s;
    }

    public boolean isDefault() {
        return this.isdefault;
    }

    public void setIsdefault(boolean isdefault) {
        this.isdefault = isdefault;
    }

    public List<String> getEffectivePerms() {
        List<String> effperms = this.cachedPerms.get("global");
        if (effperms == null) {
            effperms = this.calcEffectivePerms();
            this.cachedPerms.put("global", effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> getEffectivePerms(String server) {
        List<String> effperms = this.cachedPerms.get(server = Statics.toLower(server));
        if (effperms == null) {
            effperms = this.calcEffectivePerms(server);
            this.cachedPerms.put(server, effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> getEffectivePerms(String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> effperms = this.cachedPerms.get(server + ";" + world);
        if (effperms == null) {
            effperms = this.calcEffectivePerms(server, world);
            this.cachedPerms.put(server + ";" + world, effperms);
        }
        return new ArrayList<String>(effperms);
    }

    public List<String> calcEffectivePerms() {
        List<String> ret = new ArrayList<String>();
        for (Group g : BungeePerms.getInstance().getPermissionsManager().getGroups()) {
            if (!this.inheritances.contains(g.getName())) continue;
            List<String> gperms = g.getEffectivePerms();
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public List<String> calcEffectivePerms(String server) {
        server = Statics.toLower(server);
        List<String> ret = new ArrayList<String>();
        for (Group g : BungeePerms.getInstance().getPermissionsManager().getGroups()) {
            if (!this.inheritances.contains(g.getName())) continue;
            List<String> gperms = g.getEffectivePerms(server);
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        Server srv = this.servers.get(server);
        if (srv != null) {
            List<String> perserverperms = srv.getPerms();
            ret.addAll(perserverperms);
        }
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public List<String> calcEffectivePerms(String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> ret = new ArrayList<String>();
        for (Group g : BungeePerms.getInstance().getPermissionsManager().getGroups()) {
            if (!this.inheritances.contains(g.getName())) continue;
            List<String> gperms = g.getEffectivePerms(server, world);
            ret.addAll(gperms);
        }
        ret.addAll(this.perms);
        Server srv = this.servers.get(server);
        if (srv != null) {
            List<String> perserverperms = srv.getPerms();
            ret.addAll(perserverperms);
            World w = srv.getWorld(world);
            List<String> serverworldperms = w.getPerms();
            ret.addAll(serverworldperms);
        }
        ret = BungeePerms.getInstance().getPermissionsResolver().simplify(ret);
        return ret;
    }

    public boolean has(String perm) {
        perm = Statics.toLower(perm);
        List<String> perms = this.getEffectivePerms();
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, Statics.toLower(perm));
        return has != null && has != false;
    }

    public boolean hasOnServer(String perm, String server) {
        perm = Statics.toLower(perm);
        server = Statics.toLower(server);
        List<String> perms = this.getEffectivePerms(server);
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, perm);
        return has != null && has != false;
    }

    public boolean hasOnServerInWorld(String perm, String server, String world) {
        perm = Statics.toLower(perm);
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> perms = this.getEffectivePerms(server, world);
        Boolean has = BungeePerms.getInstance().getPermissionsResolver().has(perms, perm);
        return has != null && has != false;
    }

    public void recalcPerms() {
        this.recalcPerms0();
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(this);
    }

    public void recalcPerms(String server) {
        this.recalcPerms0(server);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(this);
    }

    public void recalcPerms(String server, String world) {
        this.recalcPerms0(server, world);
        BungeePerms.getInstance().getEventDispatcher().dispatchGroupChangeEvent(this);
    }

    public void recalcPerms0() {
        for (Map.Entry<String, List<String>> e : this.cachedPerms.entrySet()) {
            String where = e.getKey();
            List<String> l = Statics.toList(where, ";");
            String server = Statics.toLower(l.get(0));
            if (l.size() == 1) {
                if (server.equalsIgnoreCase("global")) {
                    this.cachedPerms.put("global", this.calcEffectivePerms());
                    continue;
                }
                List<String> effperms = this.calcEffectivePerms(server);
                this.cachedPerms.put(server, effperms);
                continue;
            }
            if (l.size() != 2) continue;
            String world = Statics.toLower(l.get(1));
            this.recalcPerms0(server, world);
        }
    }

    public void recalcPerms0(String server) {
        for (Map.Entry<String, List<String>> e : this.cachedPerms.entrySet()) {
            String where = e.getKey();
            List<String> l = Statics.toList(where, ";");
            String lserver = Statics.toLower(l.get(0));
            if (!lserver.equalsIgnoreCase(server)) continue;
            if (l.size() == 1) {
                List<String> effperms = this.calcEffectivePerms(lserver);
                this.cachedPerms.put(lserver, effperms);
                continue;
            }
            if (l.size() != 2) continue;
            String world = Statics.toLower(l.get(1));
            this.recalcPerms0(lserver, world);
        }
    }

    public void recalcPerms0(String server, String world) {
        server = Statics.toLower(server);
        world = Statics.toLower(world);
        List<String> effperms = this.calcEffectivePerms(server, world);
        this.cachedPerms.put(server + ";" + world, effperms);
    }

    public List<BPPermission> getPermsWithOrigin(String server, String world) {
        ArrayList<BPPermission> ret = new ArrayList<BPPermission>();
        for (Group group : BungeePerms.getInstance().getPermissionsManager().getGroups()) {
            if (!this.inheritances.contains(group.getName())) continue;
            List<BPPermission> inheritgroupperms = group.getPermsWithOrigin(server, world);
            for (BPPermission bPPermission : inheritgroupperms) {
                ret.add(bPPermission);
            }
        }
        for (String string : this.perms) {
            BPPermission perm = new BPPermission(string, this.name, true, null, null);
            ret.add(perm);
        }
        for (Map.Entry entry : this.servers.entrySet()) {
            if (server == null || !((String)entry.getKey()).equalsIgnoreCase(server)) continue;
            List<String> perserverperms = ((Server)entry.getValue()).getPerms();
            for (String string : perserverperms) {
                BPPermission perm = new BPPermission(string, this.name, true, (String)entry.getKey(), null);
                ret.add(perm);
            }
            for (Map.Entry entry2 : ((Server)entry.getValue()).getWorlds().entrySet()) {
                if (world == null || !((String)entry2.getKey()).equalsIgnoreCase(world)) continue;
                List<String> perserverworldperms = ((World)entry2.getValue()).getPerms();
                for (String s : perserverworldperms) {
                    BPPermission perm = new BPPermission(s, this.name, true, (String)entry.getKey(), (String)entry2.getKey());
                    ret.add(perm);
                }
            }
        }
        return ret;
    }

    public int getOwnPermissionsCount(String server, String world) {
        int count = this.perms.size();
        Server s = this.getServer(server);
        if (s == null) {
            return count;
        }
        count += s.getPerms().size();
        World w = s.getWorld(world);
        if (world == null) {
            return count;
        }
        return count += w.getPerms().size();
    }

    public int getPermissionsCount(String server, String world) {
        int count = this.getOwnPermissionsCount(server, world);
        for (String group : this.inheritances) {
            Group g = BungeePerms.getInstance().getPermissionsManager().getGroup(group);
            if (g == null) continue;
            count += g.getPermissionsCount(server, world);
        }
        return count;
    }

    public String buildPrefix(String server, String world) {
        String prefix = "";
        prefix = prefix + Statics.formatDisplay(this.prefix);
        Server s = this.getServer(server);
        if (s != null) {
            prefix = prefix + Statics.formatDisplay(s.getPrefix());
            World w = s.getWorld(world);
            if (w != null) {
                prefix = prefix + Statics.formatDisplay(w.getPrefix());
            }
        }
        return prefix.isEmpty() ? prefix : prefix.substring(0, prefix.length() - 1) + (Object)((Object)ChatColor.RESET);
    }

    public String buildSuffix(String server, String world) {
        String suffix = "";
        suffix = suffix + Statics.formatDisplay(this.suffix);
        Server s = this.getServer(server);
        if (s != null) {
            suffix = suffix + Statics.formatDisplay(s.getSuffix());
            World w = s.getWorld(world);
            if (w != null) {
                suffix = suffix + Statics.formatDisplay(w.getSuffix());
            }
        }
        return suffix.isEmpty() ? suffix : suffix.substring(0, suffix.length() - 1) + (Object)((Object)ChatColor.RESET);
    }

    @Override
    public int compareTo(Group g) {
        return -Integer.compare(this.rank, g.getRank());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getInheritances() {
        return this.inheritances;
    }

    @Override
    public List<String> getPerms() {
        return this.perms;
    }

    @Override
    public Map<String, Server> getServers() {
        return this.servers;
    }

    public int getRank() {
        return this.rank;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getLadder() {
        return this.ladder;
    }

    public boolean isIsdefault() {
        return this.isdefault;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setInheritances(List<String> inheritances) {
        this.inheritances = inheritances;
    }

    @Override
    public void setPerms(List<String> perms) {
        this.perms = perms;
    }

    public void setServers(Map<String, Server> servers) {
        this.servers = servers;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setLadder(String ladder) {
        this.ladder = ladder;
    }

    @Override
    public void setDisplay(String display) {
        this.display = display;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String toString() {
        return "Group(cachedPerms=" + this.getCachedPerms() + ", name=" + this.getName() + ", inheritances=" + this.getInheritances() + ", perms=" + this.getPerms() + ", servers=" + this.getServers() + ", rank=" + this.getRank() + ", weight=" + this.getWeight() + ", ladder=" + this.getLadder() + ", isdefault=" + this.isIsdefault() + ", display=" + this.getDisplay() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$cachedPerms = this.getCachedPerms();
        Map<String, List<String>> other$cachedPerms = other.getCachedPerms();
        if (this$cachedPerms == null ? other$cachedPerms != null : !((Object)this$cachedPerms).equals(other$cachedPerms)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$inheritances = this.getInheritances();
        List<String> other$inheritances = other.getInheritances();
        if (this$inheritances == null ? other$inheritances != null : !((Object)this$inheritances).equals(other$inheritances)) {
            return false;
        }
        List<String> this$perms = this.getPerms();
        List<String> other$perms = other.getPerms();
        if (this$perms == null ? other$perms != null : !((Object)this$perms).equals(other$perms)) {
            return false;
        }
        Map<String, Server> this$servers = this.getServers();
        Map<String, Server> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        if (this.getRank() != other.getRank()) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        String this$ladder = this.getLadder();
        String other$ladder = other.getLadder();
        if (this$ladder == null ? other$ladder != null : !this$ladder.equals(other$ladder)) {
            return false;
        }
        if (this.isIsdefault() != other.isIsdefault()) {
            return false;
        }
        String this$display = this.getDisplay();
        String other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
    }

    public boolean canEqual(Object other) {
        return other instanceof Group;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Map<String, List<String>> $cachedPerms = this.getCachedPerms();
        result = result * 31 + ($cachedPerms == null ? 0 : ((Object)$cachedPerms).hashCode());
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        List<String> $inheritances = this.getInheritances();
        result = result * 31 + ($inheritances == null ? 0 : ((Object)$inheritances).hashCode());
        List<String> $perms = this.getPerms();
        result = result * 31 + ($perms == null ? 0 : ((Object)$perms).hashCode());
        Map<String, Server> $servers = this.getServers();
        result = result * 31 + ($servers == null ? 0 : ((Object)$servers).hashCode());
        result = result * 31 + this.getRank();
        result = result * 31 + this.getWeight();
        String $ladder = this.getLadder();
        result = result * 31 + ($ladder == null ? 0 : $ladder.hashCode());
        result = result * 31 + (this.isIsdefault() ? 1231 : 1237);
        String $display = this.getDisplay();
        result = result * 31 + ($display == null ? 0 : $display.hashCode());
        String $prefix = this.getPrefix();
        result = result * 31 + ($prefix == null ? 0 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 31 + ($suffix == null ? 0 : $suffix.hashCode());
        return result;
    }

    private Map<String, List<String>> getCachedPerms() {
        return this.cachedPerms;
    }

    private void setCachedPerms(Map<String, List<String>> cachedPerms) {
        this.cachedPerms = cachedPerms;
    }
}

