/*
 * Decompiled with CFR 0.152.
 */
package net.alpenblock.bungeeperms;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import net.alpenblock.bungeeperms.BungeePerms;
import net.alpenblock.bungeeperms.ChatColor;
import net.alpenblock.bungeeperms.Lang;
import net.alpenblock.bungeeperms.platform.MessageEncoder;
import net.alpenblock.bungeeperms.platform.PlatformPlugin;
import net.alpenblock.bungeeperms.platform.Sender;

public class HelpProvider {
    private static final int PAGE_SIZE = 7;
    private static final List<HelpEntry> HELP_ENTRIES = new ArrayList<HelpEntry>();

    private static MessageEncoder makeClickCommand(String cmd, String help) {
        return HelpProvider.enc().append(cmd).color(ChatColor.GOLD).event(new MessageEncoder.ClickEvent(MessageEncoder.ClickEvent.Action.RUN_COMMAND, cmd)).event(new MessageEncoder.HoverEvent(MessageEncoder.HoverEvent.Action.SHOW_TEXT, HelpProvider.enc().append("Click to execute"))).append("").reset().append(" - ").color(ChatColor.WHITE).append(help).color(ChatColor.GRAY);
    }

    private static MessageEncoder makeSuggestCommand(String cmd, String help) {
        return HelpProvider.enc().append(cmd).color(ChatColor.GOLD).event(new MessageEncoder.ClickEvent(MessageEncoder.ClickEvent.Action.SUGGEST_COMMAND, cmd)).event(new MessageEncoder.HoverEvent(MessageEncoder.HoverEvent.Action.SHOW_TEXT, HelpProvider.enc().append("Click to suggest"))).append("").reset().append(" - ").color(ChatColor.WHITE).append(help).color(ChatColor.GRAY);
    }

    private static PlatformPlugin plugin() {
        return BungeePerms.getInstance().getPlugin();
    }

    private static MessageEncoder enc() {
        return HelpProvider.plugin().newMessageEncoder();
    }

    public static void sendHelpHeader(Sender sender, int page) {
        sender.sendMessage(HelpProvider.enc().append("                  ------ BungeePerms - Help - Page " + (page + 1) + " -----").color(ChatColor.GOLD));
        sender.sendMessage(HelpProvider.enc().append("Aliases: ").color(ChatColor.GRAY).append("/bp").color(ChatColor.GOLD).append("       ").color(ChatColor.GRAY).append("<required>").color(ChatColor.GOLD).append("       ").color(ChatColor.GRAY).append("[optional]").color(ChatColor.GOLD));
    }

    public static void sendHelpPage(Sender sender, int page) {
        HelpProvider.sendHelpHeader(sender, page);
        int index = -1;
        for (HelpEntry he : HELP_ENTRIES) {
            if (he.getPermission() != null && !BungeePerms.getInstance().getPermissionsChecker().hasPermOrConsole(sender, he.getPermission()) || ++index < page * 7) continue;
            if (index >= (page + 1) * 7) break;
            sender.sendMessage(he.getMessage());
        }
    }

    static {
        HELP_ENTRIES.add(new HelpEntry(null, HelpProvider.makeClickCommand("/bp", Lang.translate(Lang.MessageType.HELP_WELCOME, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.help", HelpProvider.makeSuggestCommand("/bp help [page]", Lang.translate(Lang.MessageType.HELP_HELP, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.reload", HelpProvider.makeClickCommand("/bp reload", Lang.translate(Lang.MessageType.HELP_RELOAD, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.debug", HelpProvider.makeSuggestCommand("/bp debug <true|false>", Lang.translate(Lang.MessageType.HELP_DEBUG, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.users", HelpProvider.makeSuggestCommand("/bp users [-c]", Lang.translate(Lang.MessageType.HELP_USERS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.info", HelpProvider.makeSuggestCommand("/bp user <user> info [server [world]]", Lang.translate(Lang.MessageType.HELP_USER_INFO, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.delete", HelpProvider.makeSuggestCommand("/bp user <user> delete", Lang.translate(Lang.MessageType.HELP_USER_DELETE, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.display", HelpProvider.makeSuggestCommand("/bp user <user> display [displayname [server [world]]]", Lang.translate(Lang.MessageType.HELP_USER_DISPLAY, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.prefix", HelpProvider.makeSuggestCommand("/bp user <user> prefix [prefix [server [world]]]", Lang.translate(Lang.MessageType.HELP_USER_PREFIX, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.suffix", HelpProvider.makeSuggestCommand("/bp user <user> suffix [suffix [server [world]]]", Lang.translate(Lang.MessageType.HELP_USER_SUFFIX, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.perms.add", HelpProvider.makeSuggestCommand("/bp user <user> addperm <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_USER_ADDPERM, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.perms.remove", HelpProvider.makeSuggestCommand("/bp user <user> removeperm <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_USER_REMOVEPERM, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.perms.has", HelpProvider.makeSuggestCommand("/bp user <user> has <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_USER_HAS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.perms.list", HelpProvider.makeSuggestCommand("/bp user <user> list [server [world]]", Lang.translate(Lang.MessageType.HELP_USER_LIST, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.group.add", HelpProvider.makeSuggestCommand("/bp user <user> addgroup <group>", Lang.translate(Lang.MessageType.HELP_USER_ADDGROUP, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.group.remove", HelpProvider.makeSuggestCommand("/bp user <user> removegroup <group>", Lang.translate(Lang.MessageType.HELP_USER_REMOVEGROUP, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.group.set", HelpProvider.makeSuggestCommand("/bp user <user> setgroup <group>", Lang.translate(Lang.MessageType.HELP_USER_SETGROUP, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.user.groups", HelpProvider.makeSuggestCommand("/bp user <user> groups", Lang.translate(Lang.MessageType.HELP_USER_GROUPS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.groups", HelpProvider.makeClickCommand("/bp groups", Lang.translate(Lang.MessageType.HELP_GROUPS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.info", HelpProvider.makeSuggestCommand("/bp group <group> info [server [world]]", Lang.translate(Lang.MessageType.HELP_GROUP_INFO, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.users", HelpProvider.makeSuggestCommand("/bp group <group> users [-c]", Lang.translate(Lang.MessageType.HELP_GROUP_USERS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.create", HelpProvider.makeSuggestCommand("/bp group <group> create", Lang.translate(Lang.MessageType.HELP_GROUP_CREATE, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.delete", HelpProvider.makeSuggestCommand("/bp group <group> delete", Lang.translate(Lang.MessageType.HELP_GROUP_DELETE, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.inheritances.add", HelpProvider.makeSuggestCommand("/bp group <group> addinherit <addgroup>", Lang.translate(Lang.MessageType.HELP_GROUP_ADDINHERIT, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.inheritances.remove", HelpProvider.makeSuggestCommand("/bp group <group> removeinherit <removegroup>", Lang.translate(Lang.MessageType.HELP_GROUP_REMOVEINHERIT, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.rank", HelpProvider.makeSuggestCommand("/bp group <group> rank <new rank>", Lang.translate(Lang.MessageType.HELP_GROUP_RANK, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.weight", HelpProvider.makeSuggestCommand("/bp group <group> weight <new weight>", Lang.translate(Lang.MessageType.HELP_GROUP_WEIGHT, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.ladder", HelpProvider.makeSuggestCommand("/bp group <group> ladder <new ladder>", Lang.translate(Lang.MessageType.HELP_GROUP_LADDER, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.default", HelpProvider.makeSuggestCommand("/bp group <group> default <true|false>", Lang.translate(Lang.MessageType.HELP_GROUP_DEFAULT, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.display", HelpProvider.makeSuggestCommand("/bp group <group> display [displayname [server [world]]]", Lang.translate(Lang.MessageType.HELP_GROUP_DISPLAY, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.prefix", HelpProvider.makeSuggestCommand("/bp group <group> prefix [prefix [server [world]]]", Lang.translate(Lang.MessageType.HELP_GROUP_PREFIX, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.suffix", HelpProvider.makeSuggestCommand("/bp group <group> suffix [suffix [server [world]]]", Lang.translate(Lang.MessageType.HELP_GROUP_SUFFIX, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.perms.add", HelpProvider.makeSuggestCommand("/bp group <group> addperm <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_GROUP_ADDPERM, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.perms.remove", HelpProvider.makeSuggestCommand("/bp group <group> removeperm <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_GROUP_REMOVEPERM, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.perms.has", HelpProvider.makeSuggestCommand("/bp group <group> has <perm> [server [world]]", Lang.translate(Lang.MessageType.HELP_GROUP_HAS, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.group.perms.list", HelpProvider.makeSuggestCommand("/bp group <group> list", Lang.translate(Lang.MessageType.HELP_GROUP_LIST, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.promote", HelpProvider.makeSuggestCommand("/bp promote <user> [ladder]", Lang.translate(Lang.MessageType.HELP_PROMOTE, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.demote", HelpProvider.makeSuggestCommand("/bp demote <user> [ladder]", Lang.translate(Lang.MessageType.HELP_DEMOTE, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.format", HelpProvider.makeClickCommand("/bp format", Lang.translate(Lang.MessageType.HELP_FORMAT, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.cleanup", HelpProvider.makeClickCommand("/bp cleanup", Lang.translate(Lang.MessageType.HELP_CLEANUP, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.migrate", HelpProvider.makeSuggestCommand("/bp migrate <backend> [yaml|mysql|mysql2]", Lang.translate(Lang.MessageType.HELP_MIGRATE_BACKEND, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.migrate", HelpProvider.makeSuggestCommand("/bp migrate <useuuid> [true|false]", Lang.translate(Lang.MessageType.HELP_MIGRATE_USEUUID, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.migrate", HelpProvider.makeSuggestCommand("/bp migrate <uuidplayerdb> [None|YAML|MySQL]", Lang.translate(Lang.MessageType.HELP_MIGRATE_UUIDPLAYERDB, new Object[0]))));
        HELP_ENTRIES.add(new HelpEntry("bungeeperms.uuid", HelpProvider.makeSuggestCommand("/bp uuid <player|uuid> [-rm]", Lang.translate(Lang.MessageType.HELP_UUID, new Object[0]))));
    }

    private static class HelpEntry {
        private final String permission;
        private final MessageEncoder message;

        public String getPermission() {
            return this.permission;
        }

        public MessageEncoder getMessage() {
            return this.message;
        }

        @ConstructorProperties(value={"permission", "message"})
        public HelpEntry(String permission, MessageEncoder message) {
            this.permission = permission;
            this.message = message;
        }
    }
}

